/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.items;

import StevenDimDoors.mod_pocketDim.blocks.BaseDimDoor;
import StevenDimDoors.mod_pocketDim.core.DimLink;
import StevenDimDoors.mod_pocketDim.core.LinkType;
import StevenDimDoors.mod_pocketDim.core.NewDimData;
import StevenDimDoors.mod_pocketDim.core.PocketManager;
import StevenDimDoors.mod_pocketDim.mod_pocketDim;
import StevenDimDoors.mod_pocketDim.util.Point4D;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class ItemRiftSignature
extends Item {
    public ItemRiftSignature() {
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.field_77787_bX = true;
        this.func_77637_a(mod_pocketDim.dimDoorsCreativeTab);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        return stack.func_77960_j() != 0;
    }

    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("dimdoors:" + this.func_77658_a().replace("item.", ""));
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        int adjustedY = ItemRiftSignature.adjustYForSpecialBlocks(world, x, y + 2, z);
        if (!player.func_82247_a(x, adjustedY, z, side, stack)) {
            return true;
        }
        Point4DOrientation source = ItemRiftSignature.getSource(stack);
        int orientation = MathHelper.func_76128_c((double)((double)((player.field_70177_z + 180.0f) * 4.0f / 360.0f) - 0.5)) & 3;
        if (source != null) {
            NewDimData sourceDimension = PocketManager.getDimensionData(source.getDimension());
            NewDimData destinationDimension = PocketManager.getDimensionData(world);
            DimLink link = sourceDimension.createLink(source.getX(), source.getY(), source.getZ(), LinkType.NORMAL, source.getOrientation());
            DimLink reverse = destinationDimension.createLink(x, adjustedY, z, LinkType.NORMAL, orientation);
            destinationDimension.setLinkDestination(link, x, adjustedY, z);
            sourceDimension.setLinkDestination(reverse, source.getX(), source.getY(), source.getZ());
            mod_pocketDim.blockRift.tryPlacingRift(world, x, adjustedY, z);
            WorldServer sourceWorld = DimensionManager.getWorld((int)sourceDimension.id());
            mod_pocketDim.blockRift.tryPlacingRift((World)sourceWorld, source.getX(), source.getY(), source.getZ());
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            ItemRiftSignature.clearSource(stack);
            mod_pocketDim.sendChat(player, "Rift Created");
            world.func_72956_a((Entity)player, "dimdoors:riftEnd", 0.6f, 1.0f);
        } else {
            ItemRiftSignature.setSource(stack, x, adjustedY, z, orientation, PocketManager.createDimensionData(world));
            mod_pocketDim.sendChat(player, "Location Stored in Rift Signature");
            world.func_72956_a((Entity)player, "dimdoors:riftStart", 0.6f, 1.0f);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        Point4DOrientation source = ItemRiftSignature.getSource(par1ItemStack);
        if (source != null) {
            par3List.add(StatCollector.func_74837_a((String)"info.riftSignature.bound", (Object[])new Object[]{source.getX(), source.getY(), source.getZ(), source.getDimension()}));
        } else {
            mod_pocketDim.translateAndAdd("info.riftSignature.unbound", par3List);
        }
    }

    public static int adjustYForSpecialBlocks(World world, int x, int y, int z) {
        int targetY = y - 2;
        Block block = world.func_147439_a(x, targetY, z);
        if (block == null) {
            return targetY + 2;
        }
        if (block.isReplaceable((IBlockAccess)world, x, targetY, z)) {
            return targetY + 1;
        }
        if (block instanceof BaseDimDoor) {
            if (((BaseDimDoor)block).isUpperDoorBlock(world.func_72805_g(x, targetY, z))) {
                return targetY;
            }
            return targetY + 1;
        }
        return targetY + 2;
    }

    public static void setSource(ItemStack itemStack, int x, int y, int z, int orientation, NewDimData dimension) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("linkX", x);
        tag.func_74768_a("linkY", y);
        tag.func_74768_a("linkZ", z);
        tag.func_74768_a("orientation", orientation);
        tag.func_74768_a("linkDimID", dimension.id());
        itemStack.func_77982_d(tag);
        itemStack.func_77964_b(1);
    }

    public static void clearSource(ItemStack itemStack) {
        NBTTagCompound tag = itemStack.func_77978_p();
        tag.func_82580_o("linkX");
        tag.func_82580_o("linkY");
        tag.func_82580_o("linkZ");
        tag.func_82580_o("orientation");
        tag.func_82580_o("linkDimID");
        itemStack.func_77964_b(0);
    }

    public static Point4DOrientation getSource(ItemStack itemStack) {
        if (itemStack.func_77960_j() != 0) {
            if (itemStack.func_77942_o()) {
                NBTTagCompound tag = itemStack.func_77978_p();
                Integer x = tag.func_74762_e("linkX");
                Integer y = tag.func_74762_e("linkY");
                Integer z = tag.func_74762_e("linkZ");
                Integer orientation = tag.func_74762_e("orientation");
                Integer dimID = tag.func_74762_e("linkDimID");
                if (x != null && y != null && z != null && orientation != null && dimID != null) {
                    return new Point4DOrientation(x, y, z, orientation, dimID);
                }
            }
            itemStack.func_77964_b(0);
        }
        return null;
    }

    static class Point4DOrientation {
        private Point4D point;
        private int orientation;

        Point4DOrientation(int x, int y, int z, int orientation, int dimID) {
            this.point = new Point4D(x, y, z, dimID);
            this.orientation = orientation;
        }

        int getX() {
            return this.point.getX();
        }

        int getY() {
            return this.point.getY();
        }

        int getZ() {
            return this.point.getZ();
        }

        int getDimension() {
            return this.point.getDimension();
        }

        int getOrientation() {
            return this.orientation;
        }

        Point4D getPoint() {
            return this.point;
        }
    }
}

