/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.items;

import StevenDimDoors.mod_pocketDim.blocks.BaseDimDoor;
import StevenDimDoors.mod_pocketDim.config.DDProperties;
import StevenDimDoors.mod_pocketDim.core.DimLink;
import StevenDimDoors.mod_pocketDim.core.PocketManager;
import StevenDimDoors.mod_pocketDim.mod_pocketDim;
import StevenDimDoors.mod_pocketDim.tileentities.TileEntityDimDoor;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BaseItemDoor
extends ItemDoor {
    private static HashMap<ItemDoor, BaseItemDoor> doorItemMapping = new HashMap();
    private static DDProperties properties = null;

    public BaseItemDoor(Material material, ItemDoor vanillaDoor) {
        super(material);
        this.func_77625_d(64);
        this.func_77637_a(mod_pocketDim.dimDoorsCreativeTab);
        if (properties == null) {
            properties = DDProperties.instance();
        }
        doorItemMapping.put(this, this);
        if (vanillaDoor != null) {
            doorItemMapping.put(vanillaDoor, this);
        }
    }

    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("dimdoors:" + this.func_77658_a().replace("item.", ""));
    }

    public abstract void func_77624_a(ItemStack var1, EntityPlayer var2, List var3, boolean var4);

    protected abstract BaseDimDoor getDoorBlock();

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public static boolean tryToPlaceDoor(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side) {
        if (world.field_72995_K) {
            return false;
        }
        BaseItemDoor mappedItem = doorItemMapping.get(stack.func_77973_b());
        if (mappedItem == null) {
            return false;
        }
        BaseDimDoor doorBlock = mappedItem.getDoorBlock();
        if (BaseItemDoor.placeDoorOnBlock((Block)doorBlock, stack, player, world, x, y, z, side)) {
            return true;
        }
        return BaseItemDoor.placeDoorOnRift((Block)doorBlock, world, player, stack);
    }

    public static boolean placeDoorOnBlock(Block doorBlock, ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side) {
        if (world.field_72995_K) {
            return false;
        }
        if (side == 1 && !world.field_72995_K) {
            Block block = world.func_147439_a(x, y, z);
            if (!block.isAir((IBlockAccess)world, x, y, z) && !block.isReplaceable((IBlockAccess)world, x, y, z)) {
                ++y;
            }
            if (BaseItemDoor.canPlace(world, x, y, z) && BaseItemDoor.canPlace(world, x, y + 1, z) && player.func_82247_a(x, y, z, side, stack) && player.func_82247_a(x, y + 1, z, side, stack) && stack.field_77994_a > 0 && (stack.func_77973_b() instanceof BaseItemDoor || PocketManager.getLink(x, y + 1, z, world) != null)) {
                int orientation = MathHelper.func_76128_c((double)((double)((player.field_70177_z + 180.0f) * 4.0f / 360.0f) - 0.5)) & 3;
                BaseItemDoor.func_150924_a((World)world, (int)x, (int)y, (int)z, (int)orientation, (Block)doorBlock);
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean placeDoorOnRift(Block doorBlock, World world, EntityPlayer player, ItemStack stack) {
        int z;
        int y;
        int x;
        DimLink link;
        if (world.field_72995_K) {
            return false;
        }
        MovingObjectPosition hit = BaseItemDoor.doRayTrace(player.field_70170_p, player, true);
        if (hit != null && world.func_147439_a(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d) == mod_pocketDim.blockRift && (link = PocketManager.getLink(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d, world.field_73011_w.field_76574_g)) != null && player.func_82247_a(x = hit.field_72311_b, y = hit.field_72312_c, z = hit.field_72309_d, hit.field_72310_e, stack) && player.func_82247_a(x, y - 1, z, hit.field_72310_e, stack) && BaseItemDoor.canPlace(world, x, y, z) && BaseItemDoor.canPlace(world, x, y - 1, z)) {
            int orientation = MathHelper.func_76128_c((double)((double)((player.field_70177_z + 180.0f) * 4.0f / 360.0f) - 0.5)) & 3;
            BaseItemDoor.func_150924_a((World)world, (int)x, (int)(y - 1), (int)z, (int)orientation, (Block)doorBlock);
            if (!(stack.func_77973_b() instanceof BaseItemDoor)) {
                ((TileEntityDimDoor)world.func_147438_o((int)x, (int)y, (int)z)).hasGennedPair = true;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    public static boolean canPlace(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block == mod_pocketDim.blockRift || block.isAir((IBlockAccess)world, x, y, z) || block.func_149688_o().func_76222_j();
    }

    protected static MovingObjectPosition doRayTrace(World par1World, EntityPlayer par2EntityPlayer, boolean par3) {
        float f = 1.0f;
        float f1 = par2EntityPlayer.field_70127_C + (par2EntityPlayer.field_70125_A - par2EntityPlayer.field_70127_C) * f;
        float f2 = par2EntityPlayer.field_70126_B + (par2EntityPlayer.field_70177_z - par2EntityPlayer.field_70126_B) * f;
        double d0 = par2EntityPlayer.field_70169_q + (par2EntityPlayer.field_70165_t - par2EntityPlayer.field_70169_q) * (double)f;
        double d1 = par2EntityPlayer.field_70167_r + (par2EntityPlayer.field_70163_u - par2EntityPlayer.field_70167_r) * (double)f + (double)(par1World.field_72995_K ? par2EntityPlayer.func_70047_e() - par2EntityPlayer.getDefaultEyeHeight() : par2EntityPlayer.func_70047_e());
        double d2 = par2EntityPlayer.field_70166_s + (par2EntityPlayer.field_70161_v - par2EntityPlayer.field_70166_s) * (double)f;
        Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = 5.0;
        if (par2EntityPlayer instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)par2EntityPlayer).field_71134_c.getBlockReachDistance();
        }
        Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return par1World.func_72901_a(vec3, vec31, par3);
    }
}

