/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.helpers;

import StevenDimDoors.mod_pocketDim.Point3D;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;

public class yCoordHelper {
    private static final int MAXIMUM_UNCOVERED_Y = 245;

    private yCoordHelper() {
    }

    public static int getFirstUncovered(World world, int x, int yStart, int z) {
        return yCoordHelper.getFirstUncovered(world, x, yStart, z, false);
    }

    public static int getFirstUncovered(World world, int x, int yStart, int z, boolean fromTop) {
        int y;
        Chunk chunk = world.func_72863_F().func_73158_c(x >> 4, z >> 4);
        int localX = x < 0 ? x % 16 + 16 : x % 16;
        int localZ = z < 0 ? z % 16 + 16 : z % 16;
        int height = 245;
        if (!fromTop) {
            boolean covered = true;
            for (y = yStart; y < height && covered; ++y) {
                covered = yCoordHelper.isCoveredBlock(chunk, localX, y - 1, localZ) || yCoordHelper.isCoveredBlock(chunk, localX, y, localZ);
            }
        } else {
            boolean covered = false;
            for (y = 245; y > 1 && !covered; --y) {
                covered = yCoordHelper.isCoveredBlock(chunk, localX, y - 1, localZ);
            }
            if (!covered) {
                y = 63;
            }
            ++y;
        }
        return y;
    }

    public static boolean isCoveredBlock(Chunk chunk, int localX, int y, int localZ) {
        if (y < 0) {
            return false;
        }
        Block block = chunk.func_150810_a(localX, y, localZ);
        if (block == null) {
            return false;
        }
        Material material = block.func_149688_o();
        return material.func_76224_d() || !material.func_76222_j();
    }

    public static Point3D findSafeCubeUp(World world, int x, int startY, int z) {
        int localX = x < 0 ? x % 16 + 16 : x % 16;
        int localZ = z < 0 ? z % 16 + 16 : z % 16;
        int cornerX = x - localX;
        int cornerZ = z - localZ;
        localX = MathHelper.func_76125_a((int)localX, (int)1, (int)14);
        localZ = MathHelper.func_76125_a((int)localZ, (int)1, (int)14);
        Chunk chunk = yCoordHelper.initializeChunkArea(world, x >> 4, z >> 4);
        int height = world.func_72940_L();
        int layers = -1000000;
        for (int y = Math.max(startY - 1, 0); y < height; ++y) {
            boolean isSafe = true;
            for (int dx = -1; dx <= 1 && isSafe; ++dx) {
                for (int dz = -1; dz <= 1 && isSafe; ++dz) {
                    Block block = chunk.func_150810_a(localX + dx, y, localZ + dz);
                    int metadata = chunk.func_76628_c(localX + dx, y, localZ + dz);
                    if (block.isAir((IBlockAccess)world, x, y, z) || block.func_149688_o().func_76222_j() && !block.func_149688_o().func_76224_d()) continue;
                    if (!(block.func_149688_o().func_76222_j() || block.func_149662_c() && !block.hasTileEntity(metadata))) {
                        isSafe = false;
                    }
                    layers = 0;
                }
            }
            if (!isSafe || ++layers != 3) continue;
            return new Point3D(localX + cornerX, y - 2, localZ + cornerZ);
        }
        return null;
    }

    public static Point3D findSafeCubeDown(World world, int x, int startY, int z) {
        int localX = x < 0 ? x % 16 + 16 : x % 16;
        int localZ = z < 0 ? z % 16 + 16 : z % 16;
        int cornerX = x - localX;
        int cornerZ = z - localZ;
        localX = MathHelper.func_76125_a((int)localX, (int)1, (int)14);
        localZ = MathHelper.func_76125_a((int)localZ, (int)1, (int)14);
        Chunk chunk = yCoordHelper.initializeChunkArea(world, x >> 4, z >> 4);
        int height = world.func_72940_L();
        int layers = 0;
        for (int y = Math.min(startY + 2, height - 1); y >= 0; --y) {
            boolean isSafe = true;
            boolean hasBlocks = false;
            for (int dx = -1; dx <= 1 && isSafe; ++dx) {
                for (int dz = -1; dz <= 1 && isSafe; ++dz) {
                    Block block = chunk.func_150810_a(localX + dx, y, localZ + dz);
                    int metadata = chunk.func_76628_c(localX + dx, y, localZ + dz);
                    if (block.isAir((IBlockAccess)world, x, y, z) || block.func_149688_o().func_76222_j() && !block.func_149688_o().func_76224_d()) continue;
                    if (!(block.func_149688_o().func_76222_j() || block.func_149662_c() && !block.hasTileEntity(metadata))) {
                        if (layers >= 3) {
                            return new Point3D(localX + cornerX, y + 1, localZ + cornerZ);
                        }
                        isSafe = false;
                    }
                    hasBlocks = true;
                }
            }
            if (!isSafe) continue;
            ++layers;
            if (!hasBlocks) continue;
            if (layers >= 3) {
                return new Point3D(localX + cornerX, y, localZ + cornerZ);
            }
            layers = 0;
        }
        return null;
    }

    private static Chunk initializeChunkArea(World world, int chunkX, int chunkZ) {
        IChunkProvider provider = world.func_72863_F();
        Chunk target = provider.func_73158_c(chunkX, chunkZ);
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                provider.func_73158_c(chunkX, chunkZ);
            }
        }
        return target;
    }

    public static Point3D findDropPoint(World world, int x, int startY, int z) {
        int GAP_HEIGHT = 2;
        int localX = x < 0 ? x % 16 + 16 : x % 16;
        int localZ = z < 0 ? z % 16 + 16 : z % 16;
        int cornerX = x - localX;
        int cornerZ = z - localZ;
        localX = MathHelper.func_76125_a((int)localX, (int)1, (int)14);
        localZ = MathHelper.func_76125_a((int)localZ, (int)1, (int)14);
        Chunk chunk = yCoordHelper.initializeChunkArea(world, x >> 4, z >> 4);
        int height = world.func_72940_L();
        int[] gaps = new int[9];
        for (int y = Math.min(startY, height - 1); y > 0; --y) {
            int dz;
            int dx;
            int index = 0;
            for (dx = -1; dx <= 1; ++dx) {
                dz = -1;
                while (dz <= 1) {
                    if (!chunk.func_150810_a(localX + dx, y, localZ + dz).isAir((IBlockAccess)world, x + dx, y, z + dz)) {
                        gaps[index] = 0;
                    } else {
                        int n = index;
                        gaps[n] = gaps[n] + 1;
                    }
                    ++dz;
                    ++index;
                }
            }
            if (gaps[index / 2] == 2) {
                return new Point3D(localX + cornerX, y + 2 - 1, localZ + cornerZ);
            }
            index = 0;
            for (dx = -1; dx <= 1; ++dx) {
                dz = -1;
                while (dz <= 1) {
                    if (gaps[index] == 2) {
                        return new Point3D(localX + cornerX + dx, y + 2 - 1, localZ + cornerZ + dz);
                    }
                    ++dz;
                    ++index;
                }
            }
        }
        return null;
    }

    public static int adjustDestinationY(int y, int worldHeight, int entranceY, int dungeonHeight) {
        int destY = y;
        int pocketTop = dungeonHeight - 1 + destY - entranceY;
        if (pocketTop >= worldHeight) {
            destY = worldHeight - 1 - (dungeonHeight - 1) + entranceY;
        }
        if (destY < entranceY) {
            destY = entranceY;
        }
        return destY;
    }
}

