/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.helpers;

import StevenDimDoors.mod_pocketDim.config.DDProperties;
import StevenDimDoors.mod_pocketDim.core.DimLink;
import StevenDimDoors.mod_pocketDim.core.LinkType;
import StevenDimDoors.mod_pocketDim.core.NewDimData;
import StevenDimDoors.mod_pocketDim.core.PocketManager;
import StevenDimDoors.mod_pocketDim.dungeon.DungeonData;
import StevenDimDoors.mod_pocketDim.dungeon.DungeonSchematic;
import StevenDimDoors.mod_pocketDim.dungeon.pack.DungeonPack;
import StevenDimDoors.mod_pocketDim.dungeon.pack.DungeonPackConfig;
import StevenDimDoors.mod_pocketDim.dungeon.pack.DungeonPackConfigReader;
import StevenDimDoors.mod_pocketDim.dungeon.pack.DungeonType;
import StevenDimDoors.mod_pocketDim.helpers.copyfile;
import StevenDimDoors.mod_pocketDim.items.ItemDimensionalDoor;
import StevenDimDoors.mod_pocketDim.mod_pocketDim;
import StevenDimDoors.mod_pocketDim.util.FileFilters;
import StevenDimDoors.mod_pocketDim.util.WeightedContainer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;

public class DungeonHelper {
    private static DungeonHelper instance = null;
    private static DDProperties properties = null;
    public static final Pattern SCHEMATIC_NAME_PATTERN = Pattern.compile("[A-Za-z0-9_\\-]+");
    public static final Pattern DUNGEON_NAME_PATTERN = Pattern.compile("[A-Za-z0-9\\-]+");
    public static final String SCHEMATIC_FILE_EXTENSION = ".schematic";
    private static final String DEFAULT_ERROR_SCHEMATIC_PATH = "/schematics/core/somethingBroke.schematic";
    private static final String DUNGEON_CREATION_GUIDE_SOURCE_PATH = "/assets/dimdoors/text/How_to_add_dungeons.txt";
    private static final String BUNDLED_PACK_BASE_PATH = "/schematics/";
    private static final String STANDARD_CONFIG_FILE_NAME = "rules.txt";
    private static final int NETHER_DIMENSION_ID = -1;
    private static final int MIN_PACK_SWITCH_CHANCE = 0;
    private static final int PACK_SWITCH_CHANCE_PER_LEVEL = 1;
    private static final int MAX_PACK_SWITCH_CHANCE = 500;
    private static final int START_PACK_SWITCH_CHANCE = 55;
    private static final int DEFAULT_DUNGEON_WEIGHT = 100;
    public static final int MIN_DUNGEON_WEIGHT = 1;
    public static final int MAX_DUNGEON_WEIGHT = 10000;
    private static final int MAX_EXPORT_RADIUS = 50;
    public static final short MAX_DUNGEON_WIDTH = 101;
    public static final short MAX_DUNGEON_HEIGHT = 101;
    public static final short MAX_DUNGEON_LENGTH = 101;
    private ArrayList<DungeonData> untaggedDungeons = new ArrayList();
    private ArrayList<DungeonData> registeredDungeons = new ArrayList();
    private DungeonPack RuinsPack;
    private DungeonPack NetherPack;
    private HashMap<String, DungeonPack> dungeonPackMapping = new HashMap();
    private ArrayList<DungeonPack> dungeonPackList = new ArrayList();
    private DungeonData defaultError;

    private DungeonHelper() {
        if (properties == null) {
            properties = DDProperties.instance();
        }
        this.registerDungeons();
    }

    public static DungeonHelper initialize() {
        if (instance != null) {
            throw new IllegalStateException("Cannot initialize DungeonHelper twice");
        }
        instance = new DungeonHelper();
        return instance;
    }

    public static DungeonHelper instance() {
        if (instance == null) {
            throw new IllegalStateException("Instance of DungeonHelper requested before initialization");
        }
        return instance;
    }

    private void registerDungeons() {
        File file = new File(DungeonHelper.properties.CustomSchematicDirectory);
        if (file.exists() || file.mkdir()) {
            copyfile.copyFile(DUNGEON_CREATION_GUIDE_SOURCE_PATH, file.getAbsolutePath() + "/How_to_add_dungeons.txt");
        }
        DungeonPackConfigReader reader = new DungeonPackConfigReader();
        this.registerBundledDungeons(reader);
        this.registerCustomDungeons(DungeonHelper.properties.CustomSchematicDirectory, reader);
    }

    private static DungeonPackConfig loadDungeonPackConfig(String configPath, String name, boolean isInternal, DungeonPackConfigReader reader) {
        block3: {
            try {
                DungeonPackConfig config = isInternal ? (DungeonPackConfig)reader.readFromResource(configPath) : (DungeonPackConfig)reader.readFromFile(configPath);
                config.setName(name);
                return config;
            }
            catch (FileNotFoundException e) {
                System.err.println("Could not find a dungeon pack config file: " + configPath);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                if (e.getCause() == null) break block3;
                System.err.println(e.getCause());
            }
        }
        return null;
    }

    private DungeonPack registerDungeonPack(String directory, Iterable<String> schematics, boolean isInternal, boolean verbose, DungeonPackConfigReader reader) {
        File packDirectory = new File(directory);
        String name = packDirectory.getName().toUpperCase();
        DungeonPack pack = this.dungeonPackMapping.get(name);
        if (pack == null) {
            String configPath = isInternal ? directory + "/" + STANDARD_CONFIG_FILE_NAME : directory + File.separator + STANDARD_CONFIG_FILE_NAME;
            DungeonPackConfig config = DungeonHelper.loadDungeonPackConfig(configPath, name, isInternal, reader);
            if (config == null) {
                System.err.println("Could not load config file: " + configPath);
                return null;
            }
            pack = new DungeonPack(config);
            this.dungeonPackMapping.put(name, pack);
            this.dungeonPackList.add(pack);
        } else {
            System.err.println("A dungeon pack has the same name as another pack that has already been loaded: " + directory);
            System.err.println("We will try to load its schematics but will not check its config file.");
        }
        for (String schematicPath : schematics) {
            this.registerDungeon(schematicPath, pack, isInternal, verbose);
        }
        return pack;
    }

    public List<DungeonData> getRegisteredDungeons() {
        return Collections.unmodifiableList(this.registeredDungeons);
    }

    public List<DungeonData> getUntaggedDungeons() {
        return Collections.unmodifiableList(this.untaggedDungeons);
    }

    public DungeonData getDefaultErrorDungeon() {
        return this.defaultError;
    }

    public DungeonPack getDungeonPack(String name) {
        return this.dungeonPackMapping.get(name.toUpperCase());
    }

    private DungeonPack getDimDungeonPack(NewDimData dimension) {
        DungeonPack pack;
        DungeonData dungeon = dimension.dungeon();
        if (dungeon != null) {
            pack = dungeon.dungeonType().Owner;
            if (pack == null) {
                pack = this.RuinsPack;
            }
        } else {
            pack = dimension.id() == -1 ? this.NetherPack : this.RuinsPack;
        }
        return pack;
    }

    public DimLink createCustomDungeonDoor(World world, int x, int y, int z) {
        NewDimData dimension = PocketManager.getDimensionData(world);
        DimLink link = dimension.createLink(x, y + 1, z, LinkType.POCKET, 3);
        ItemDimensionalDoor.func_150924_a((World)world, (int)x, (int)y, (int)z, (int)3, (Block)mod_pocketDim.warpDoor);
        return link;
    }

    public boolean validateDungeonType(String type, DungeonPack pack) {
        return pack.isKnownType(type);
    }

    public boolean validateSchematicName(String name, DungeonPack pack) {
        if (!name.endsWith(SCHEMATIC_FILE_EXTENSION)) {
            return false;
        }
        String[] dungeonData = name.substring(0, name.length() - SCHEMATIC_FILE_EXTENSION.length()).split("_");
        if (dungeonData.length < 3 || dungeonData.length > 4) {
            return false;
        }
        if (!this.validateDungeonType(dungeonData[0], pack)) {
            return false;
        }
        if (!SCHEMATIC_NAME_PATTERN.matcher(dungeonData[1]).matches()) {
            return false;
        }
        if (!dungeonData[2].equalsIgnoreCase("open") && !dungeonData[2].equalsIgnoreCase("closed")) {
            return false;
        }
        if (dungeonData.length == 4) {
            try {
                int weight = Integer.parseInt(dungeonData[3]);
                if (weight < 1 || weight > 10000) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public void registerDungeon(String schematicPath, DungeonPack pack, boolean isInternal, boolean verbose) {
        File schematicFile = new File(schematicPath);
        String name = schematicFile.getName();
        String path = isInternal ? schematicPath : schematicFile.getAbsolutePath();
        try {
            if (this.validateSchematicName(name, pack)) {
                String[] dungeonData = name.substring(0, name.length() - SCHEMATIC_FILE_EXTENSION.length()).split("_");
                DungeonType dungeonType = pack.getType(dungeonData[0]);
                boolean isOpen = dungeonData[2].equalsIgnoreCase("open");
                int weight = dungeonData.length == 4 ? Integer.parseInt(dungeonData[3]) : 100;
                DungeonData dungeon = new DungeonData(path, isInternal, dungeonType, isOpen, weight);
                pack.addDungeon(dungeon);
                this.registeredDungeons.add(dungeon);
                if (verbose) {
                    System.out.println("Registered dungeon: " + name);
                }
            } else {
                if (verbose) {
                    System.out.println("The following dungeon name is invalid for its given pack. It will not be generated naturally: " + schematicPath);
                }
                this.untaggedDungeons.add(new DungeonData(path, isInternal, DungeonType.UNKNOWN_TYPE, true, 100));
                System.out.println("Registered untagged dungeon: " + name);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to register dungeon: " + name);
            e.printStackTrace();
        }
    }

    private void registerCustomDungeons(String path, DungeonPackConfigReader reader) {
        File directory = new File(path);
        FileFilters.FileExtensionFilter schematicFileFilter = new FileFilters.FileExtensionFilter(SCHEMATIC_FILE_EXTENSION);
        if (this.RuinsPack == null) {
            throw new IllegalStateException("Cannot register custom dungeons without first loading the Ruins dungeon pack.");
        }
        File[] schematics = directory.listFiles(schematicFileFilter);
        if (schematics != null) {
            for (File schematicFile : schematics) {
                this.registerDungeon(schematicFile.getPath(), this.RuinsPack, false, true);
            }
        } else {
            System.err.println("Could not retrieve the list of schematics stored in the custom dungeons directory!");
        }
        schematics = null;
        File[] packDirectories = directory.listFiles(new FileFilters.DirectoryFilter());
        if (packDirectories != null) {
            for (File packDirectory : packDirectories) {
                File[] packFiles = packDirectory.listFiles(schematicFileFilter);
                if (packFiles != null) {
                    ArrayList<String> packFilePaths = new ArrayList<String>(packFiles.length);
                    for (File packFile : packFiles) {
                        packFilePaths.add(packFile.getPath());
                    }
                    this.registerDungeonPack(packDirectory.getAbsolutePath(), packFilePaths, false, true, reader);
                    continue;
                }
                System.err.println("Could not retrieve the list of schematics in a dungeon pack: " + packDirectory.getPath());
            }
        } else {
            System.err.println("Could not retrieve the list of dungeon pack directories in the custom dungeons directory!");
        }
    }

    private void registerBundledDungeons(DungeonPackConfigReader reader) {
        this.defaultError = new DungeonData(DEFAULT_ERROR_SCHEMATIC_PATH, true, DungeonType.UNKNOWN_TYPE, true, 100);
        this.RuinsPack = this.registerBundledPack("Ruins", reader);
        this.NetherPack = this.registerBundledPack("Nether", reader);
        System.out.println("Finished registering bundled dungeon packs");
    }

    private DungeonPack registerBundledPack(String name, DungeonPackConfigReader reader) {
        System.out.println("Registering bundled dungeon pack: " + name);
        String packPath = BUNDLED_PACK_BASE_PATH + name.toLowerCase();
        String listPath = packPath + ".txt";
        InputStream listStream = this.getClass().getResourceAsStream(listPath);
        if (listStream == null) {
            throw new IllegalStateException("Failed to open the list of bundled dungeon schematics for " + name);
        }
        ArrayList<String> schematics = new ArrayList<String>();
        try {
            BufferedReader listReader = new BufferedReader(new InputStreamReader(listStream));
            String schematicPath = listReader.readLine();
            while (schematicPath != null) {
                if (!(schematicPath = schematicPath.trim()).isEmpty()) {
                    schematics.add(schematicPath);
                }
                schematicPath = listReader.readLine();
            }
            listReader.close();
        }
        catch (IOException e) {
            throw new RuntimeException("An unexpected error occured while trying to read the list of schematics for the " + name + " bundled dungeon pack. This would inevitably cause Dimensional Doors to crash during runtime.", e);
        }
        DungeonPack pack = this.registerDungeonPack(packPath, schematics, true, false, reader);
        if (pack == null) {
            throw new RuntimeException("Failed to load the " + name + " bundled dungeon pack. This would inevitably cause Dimensional Doors to crash during runtime.");
        }
        return pack;
    }

    public boolean exportDungeon(World world, int centerX, int centerY, int centerZ, String exportPath) {
        try {
            DungeonSchematic dungeon = DungeonSchematic.copyFromWorld(world, centerX - 50, centerY - 50, centerZ - 50, (short)101, (short)101, (short)101, true);
            dungeon.applyExportFilters(properties);
            dungeon.writeToFile(exportPath);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public DungeonData selectNextDungeon(NewDimData parent, Random random) {
        DungeonData selection;
        DungeonPack pack = this.getDimDungeonPack(parent);
        try {
            DungeonPackConfig config = pack.getConfig();
            DungeonPack selectedPack = pack;
            if (config.allowPackChangeOut()) {
                int packSwitchChance = parent.isPocketDimension() ? 0 + parent.packDepth() * 1 : 55;
                if (random.nextInt(500) < packSwitchChance) {
                    selectedPack = this.getRandomDungeonPack(pack, random);
                }
            }
            selection = selectedPack.getNextDungeon(parent, random);
        }
        catch (Exception e) {
            System.err.println("An exception occurred while selecting a dungeon:");
            e.printStackTrace();
            selection = !pack.isEmpty() ? pack.getRandomDungeon(random) : this.defaultError;
        }
        return selection;
    }

    private DungeonPack getRandomDungeonPack(DungeonPack current, Random random) {
        DungeonPack selection = current;
        ArrayList<WeightedContainer<DungeonPack>> packs = new ArrayList<WeightedContainer<DungeonPack>>(this.dungeonPackList.size());
        for (DungeonPack pack : this.dungeonPackList) {
            DungeonPackConfig config = pack.getConfig();
            if (pack == current || !config.allowPackChangeIn() || pack.isEmpty()) continue;
            packs.add(new WeightedContainer<DungeonPack>(pack, config.getPackWeight()));
        }
        if (!packs.isEmpty()) {
            selection = (DungeonPack)((WeightedContainer)WeightedRandom.func_76271_a((Random)random, packs)).getData();
        }
        return selection;
    }

    public ArrayList<String> getDungeonNames() {
        HashSet<String> dungeonNames = new HashSet<String>();
        dungeonNames.addAll(DungeonHelper.parseDungeonNames(this.registeredDungeons));
        dungeonNames.addAll(DungeonHelper.parseDungeonNames(this.untaggedDungeons));
        ArrayList<String> sortedNames = new ArrayList<String>(dungeonNames);
        Collections.sort(sortedNames, String.CASE_INSENSITIVE_ORDER);
        return sortedNames;
    }

    private static ArrayList<String> parseDungeonNames(ArrayList<DungeonData> dungeons) {
        ArrayList<String> names = new ArrayList<String>(dungeons.size());
        for (DungeonData dungeon : dungeons) {
            File schematic = new File(dungeon.schematicPath());
            String name = schematic.getName();
            name = name.substring(0, name.length() - SCHEMATIC_FILE_EXTENSION.length());
            names.add(name);
        }
        return names;
    }

    public static ArrayList<DungeonData> getDungeonChainHistory(NewDimData start, DungeonPack pack, int maxSize) {
        if (start == null) {
            throw new IllegalArgumentException("dimension cannot be null.");
        }
        NewDimData current = start;
        DungeonData dungeon = current.dungeon();
        ArrayList<DungeonData> history = new ArrayList<DungeonData>();
        for (int count = 0; count < maxSize && dungeon != null && dungeon.dungeonType().Owner == pack; ++count) {
            history.add(dungeon);
            current = current.parent();
            dungeon = current.dungeon();
        }
        return history;
    }

    public static ArrayList<DungeonData> listDungeonsInTree(NewDimData root, DungeonPack pack, int maxSize) {
        boolean count = false;
        ArrayList<DungeonData> dungeons = new ArrayList<DungeonData>();
        LinkedList<NewDimData> pendingDimensions = new LinkedList<NewDimData>();
        pendingDimensions.add(root);
        while (dungeons.size() < maxSize && !pendingDimensions.isEmpty()) {
            NewDimData current = (NewDimData)pendingDimensions.remove();
            DungeonData dungeon = current.dungeon();
            if (dungeon == null || dungeon.dungeonType().Owner != pack) continue;
            dungeons.add(dungeon);
            for (NewDimData child : current.children()) {
                pendingDimensions.add(child);
            }
        }
        return dungeons;
    }

    public static NewDimData getAncestor(NewDimData dimension, DungeonPack pack, int maxLevels) {
        NewDimData parent = dimension;
        NewDimData current = null;
        for (int levels = 0; levels <= maxLevels && parent != null && parent.dungeon() != null && parent.dungeon().dungeonType().Owner == pack; parent = parent.parent(), ++levels) {
            current = parent;
        }
        return current;
    }
}

