/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.helpers;

import StevenDimDoors.mod_pocketDim.core.DimLink;
import StevenDimDoors.mod_pocketDim.core.DimensionType;
import StevenDimDoors.mod_pocketDim.core.IDimRegistrationCallback;
import StevenDimDoors.mod_pocketDim.core.LinkType;
import StevenDimDoors.mod_pocketDim.core.NewDimData;
import StevenDimDoors.mod_pocketDim.util.Point4D;
import StevenDimDoors.mod_pocketDim.watcher.ClientLinkData;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;

public class Compactor {
    public static void write(Collection<? extends NewDimData> values, ByteBuf output) throws IOException {
        output.writeInt(values.size());
        for (NewDimData newDimData : values) {
            output.writeInt(newDimData.id());
            output.writeInt(newDimData.root().id());
            output.writeInt(newDimData.type().index);
            output.writeInt(newDimData.linkCount());
            for (DimLink dimLink : newDimData.links()) {
                new ClientLinkData(dimLink).write(output);
            }
        }
    }

    public static void readDimensions(ByteBuf input, IDimRegistrationCallback callback) throws IOException {
        HashSet<Integer> rootIDs = new HashSet<Integer>();
        int dimCount = input.readInt();
        for (int k = 0; k < dimCount; ++k) {
            int id = input.readInt();
            int rootID = input.readInt();
            DimensionType type = DimensionType.getTypeFromIndex(input.readInt());
            if (rootIDs.add(rootID)) {
                callback.registerDimension(rootID, rootID, type);
            }
            NewDimData dimension = callback.registerDimension(id, rootID, type);
            int linkCount = input.readInt();
            for (int h = 0; h < linkCount; ++h) {
                ClientLinkData link = ClientLinkData.read(input);
                Point4D source = link.point;
                dimension.createLink(source.getX(), source.getY(), source.getZ(), LinkType.CLIENT, 0);
            }
        }
    }

    private static class DimComparator
    implements Comparator<NewDimData> {
        private DimComparator() {
        }

        @Override
        public int compare(NewDimData a, NewDimData b) {
            return a.id() - b.id();
        }
    }
}

