/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.helpers;

import StevenDimDoors.experimental.BoundingBox;
import StevenDimDoors.mod_pocketDim.IChunkLoader;
import StevenDimDoors.mod_pocketDim.Point3D;
import StevenDimDoors.mod_pocketDim.core.NewDimData;
import StevenDimDoors.mod_pocketDim.core.PocketManager;
import StevenDimDoors.mod_pocketDim.mod_pocketDim;
import StevenDimDoors.mod_pocketDim.world.PocketBuilder;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import java.io.File;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;

public class ChunkLoaderHelper
implements ForgeChunkManager.LoadingCallback {
    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket ticket : tickets) {
            IChunkLoader loader;
            int z;
            int y;
            boolean loaded = false;
            int x = ticket.getModData().func_74762_e("goldDimDoorX");
            if (world.func_147439_a(x, y = ticket.getModData().func_74762_e("goldDimDoorY"), z = ticket.getModData().func_74762_e("goldDimDoorZ")) == mod_pocketDim.goldenDimensionalDoor && !(loader = (IChunkLoader)world.func_147438_o(x, y, z)).isInitialized()) {
                loader.initialize(ticket);
                loaded = true;
            }
            if (loaded) continue;
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
    }

    public static ForgeChunkManager.Ticket createTicket(int x, int y, int z, World world) {
        ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestTicket((Object)mod_pocketDim.instance, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (ticket != null) {
            NBTTagCompound data = ticket.getModData();
            data.func_74768_a("goldDimDoorX", x);
            data.func_74768_a("goldDimDoorY", y);
            data.func_74768_a("goldDimDoorZ", z);
        }
        return ticket;
    }

    public static void forcePocketChunks(NewDimData pocket, ForgeChunkManager.Ticket ticket) {
        BoundingBox bounds = PocketBuilder.calculateDefaultBounds(pocket);
        Point3D minCorner = bounds.minCorner();
        Point3D maxCorner = bounds.maxCorner();
        int minX = minCorner.getX() >> 4;
        int minZ = minCorner.getZ() >> 4;
        int maxX = maxCorner.getX() >> 4;
        int maxZ = maxCorner.getZ() >> 4;
        for (int chunkX = minX; chunkX <= maxX; ++chunkX) {
            for (int chunkZ = minZ; chunkZ <= maxZ; ++chunkZ) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(chunkX, chunkZ));
            }
        }
    }

    public static void loadForcedChunkWorlds(FMLServerStartingEvent event) {
        for (NewDimData newDimData : PocketManager.getDimensions()) {
            String chunkDir;
            File file;
            if (!newDimData.isPocketDimension() || !(file = new File(chunkDir = DimensionManager.getCurrentSaveRootDirectory() + "/DimensionalDoors/pocketDimID" + newDimData.id())).exists() || !ForgeChunkManager.savedWorldHasForcedChunkTickets((File)file)) continue;
            PocketManager.loadDimension(newDimData.id());
        }
    }
}

