/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.dungeon.pack;

import StevenDimDoors.mod_pocketDim.dungeon.pack.DungeonChainRuleDefinition;
import StevenDimDoors.mod_pocketDim.dungeon.pack.DungeonPackConfig;
import StevenDimDoors.mod_pocketDim.dungeon.pack.DungeonType;
import StevenDimDoors.mod_pocketDim.util.BaseConfigurationProcessor;
import StevenDimDoors.mod_pocketDim.util.ConfigurationProcessingException;
import StevenDimDoors.mod_pocketDim.util.WeightedContainer;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.primitives.Ints;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class DungeonPackConfigReader
extends BaseConfigurationProcessor<DungeonPackConfig> {
    private final int CONFIG_VERSION = 1;
    private final int LOOKAHEAD_LIMIT = 1024;
    private final int MAX_PRODUCT_WEIGHT = 10000;
    private final int MIN_PRODUCT_WEIGHT = 1;
    private final int DEFAULT_PRODUCT_WEIGHT = 100;
    private final int MAX_DUNGEON_PACK_WEIGHT = 10000;
    private final int MIN_DUNGEON_PACK_WEIGHT = 1;
    private final int MAX_DUPLICATE_SEARCH_LEVELS = 5;
    private final int MIN_DUPLICATE_SEARCH_LEVELS = 0;
    private final int DEFAULT_DUNGEON_PACK_WEIGHT = 100;
    private final int MAX_CONDITION_LENGTH = 20;
    private final int MAX_PRODUCT_COUNT = 20;
    private final String COMMENT_MARKER = "##";
    private final Pattern DUNGEON_TYPE_PATTERN = Pattern.compile("[A-Za-z0-9_\\-]{1,20}");
    private final Splitter WHITESPACE_SPLITTER = Splitter.on((CharMatcher)CharMatcher.WHITESPACE).omitEmptyStrings();
    private final String SETTING_SEPARATOR = "=";
    private final String RULE_SEPARATOR = "->";
    private final String WEIGHT_SEPARATOR = "#";

    @Override
    public DungeonPackConfig readFromStream(InputStream inputStream) throws ConfigurationProcessingException {
        BufferedReader reader = null;
        try {
            DungeonPackConfig config = new DungeonPackConfig();
            reader = new BufferedReader(new InputStreamReader(inputStream));
            int version = this.readVersion(reader);
            if (version != 1) {
                throw new ConfigurationProcessingException("The dungeon pack config has an incompatible version.");
            }
            config.setTypeNames(new ArrayList<String>());
            config.setRules(new ArrayList<DungeonChainRuleDefinition>());
            if (this.findSection("Types", reader)) {
                this.processLines(reader, config, new DungeonTypeProcessor());
            }
            config.setAllowDuplicatesInChain(true);
            config.setAllowPackChangeIn(true);
            config.setAllowPackChangeOut(true);
            config.setDistortDoorCoordinates(false);
            config.setPackWeight(100);
            config.setDuplicateSearchLevels(0);
            if (this.findSection("Settings", reader)) {
                this.processLines(reader, config, new DungeonSettingsParser());
            }
            if (this.findSection("Rules", reader)) {
                this.processLines(reader, config, new RuleDefinitionParser());
            }
            DungeonPackConfig dungeonPackConfig = config;
            return dungeonPackConfig;
        }
        catch (ConfigurationProcessingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConfigurationProcessingException("An unexpected error occurred while trying to read the configuration file.", ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    private int readVersion(BufferedReader reader) throws ConfigurationProcessingException, IOException {
        String firstLine = reader.readLine();
        String[] parts = firstLine.split("\\s", 0);
        Integer version = null;
        if (parts.length == 2 && parts[0].equalsIgnoreCase("version")) {
            version = Ints.tryParse((String)parts[1]);
        }
        if (version == null) {
            throw new ConfigurationProcessingException("Could not parse the config format version.");
        }
        return version;
    }

    private void processLines(BufferedReader reader, DungeonPackConfig config, ILineProcessor processor) throws IOException, ConfigurationProcessingException {
        while (reader.ready()) {
            reader.mark(1024);
            String line = reader.readLine();
            if (line.startsWith("##") || (line = line.trim()).length() <= 0) continue;
            if (line.endsWith(":")) {
                reader.reset();
                break;
            }
            processor.process(line, config);
        }
    }

    private boolean findSection(String name, BufferedReader reader) throws IOException, ConfigurationProcessingException {
        boolean found = false;
        boolean matched = false;
        String line = null;
        String label = name + ":";
        while (!found && reader.ready()) {
            reader.mark(1024);
            line = reader.readLine();
            if (line.startsWith("##") || (line = line.trim()).length() <= 0) continue;
            if (line.endsWith(":")) {
                found = true;
                matched = line.equalsIgnoreCase(label);
                continue;
            }
            throw new ConfigurationProcessingException("The dungeon pack config has an incorrect line where a section was expected: " + line);
        }
        if (found && !matched) {
            reader.reset();
        }
        return found;
    }

    private static boolean isKnownDungeonType(String typeName, List<String> typeNames) {
        return typeName.equals(DungeonType.WILDCARD_TYPE.Name) || typeNames.contains(typeName);
    }

    private static boolean parseBoolean(String value) {
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException("The boolean value must be either \"true\" or \"false\", ignoring case.");
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public void writeToStream(OutputStream outputStream, DungeonPackConfig data) throws ConfigurationProcessingException {
        throw new UnsupportedOperationException("DungeonPackConfigReader does not support writing.");
    }

    private class RuleDefinitionParser
    implements ILineProcessor {
        private RuleDefinitionParser() {
        }

        @Override
        public void process(String definition, DungeonPackConfig config) throws ConfigurationProcessingException {
            ArrayList<String> typeNames = config.getTypeNames();
            String[] ruleParts = definition.toUpperCase().split("->", -1);
            if (ruleParts.length != 2) {
                throw new ConfigurationProcessingException("The dungeon pack config has an invalid rule: " + definition);
            }
            String ruleCondition = ruleParts[0];
            String ruleProduct = ruleParts[1];
            ArrayList<String> condition = new ArrayList<String>();
            ArrayList<WeightedContainer<String>> products = new ArrayList<WeightedContainer<String>>();
            for (String typeName : DungeonPackConfigReader.this.WHITESPACE_SPLITTER.split((CharSequence)ruleCondition)) {
                if (!DungeonPackConfigReader.isKnownDungeonType(typeName, typeNames)) {
                    throw new ConfigurationProcessingException("The dungeon pack config has a rule condition with an unknown dungeon type: " + typeName);
                }
                condition.add(typeName);
                if (condition.size() <= 20) continue;
                throw new ConfigurationProcessingException("The dungeon pack config has a rule condition that is too long: " + definition);
            }
            for (String product : DungeonPackConfigReader.this.WHITESPACE_SPLITTER.split((CharSequence)ruleProduct)) {
                Integer weight;
                String[] productParts = product.split("#", -1);
                if (productParts.length > 2 || productParts.length == 0) {
                    throw new ConfigurationProcessingException("The dungeon pack config has a rule with an invalid product: " + product);
                }
                String typeName = productParts[0];
                if (DungeonPackConfigReader.isKnownDungeonType(typeName, typeNames)) {
                    if (productParts.length > 1) {
                        weight = Ints.tryParse((String)productParts[1]);
                        if (weight == null || weight > 10000 || weight < 1) {
                            throw new ConfigurationProcessingException("The dungeon pack config has a rule with an invalid product weight: " + product);
                        }
                    } else {
                        weight = 100;
                    }
                } else {
                    throw new ConfigurationProcessingException("The dungeon pack config has an unknown dungeon type in a rule: " + typeName);
                }
                products.add(new WeightedContainer<String>(typeName, weight));
                if (products.size() <= 20) continue;
                throw new ConfigurationProcessingException("The dungeon pack config has a rule with too many products: " + definition);
            }
            if (products.isEmpty()) {
                throw new ConfigurationProcessingException("The dungeon pack config has a rule with no products: " + definition);
            }
            config.getRules().add(new DungeonChainRuleDefinition(condition, products));
        }
    }

    private class DungeonSettingsParser
    implements ILineProcessor {
        private DungeonSettingsParser() {
        }

        @Override
        public void process(String line, DungeonPackConfig config) throws ConfigurationProcessingException {
            boolean valid;
            block15: {
                valid = true;
                String[] settingParts = line.split("=", 2);
                if (settingParts.length == 2) {
                    try {
                        String name = settingParts[0].trim();
                        String value = settingParts[1].trim();
                        if (name.equalsIgnoreCase("AllowDuplicatesInChain")) {
                            config.setAllowDuplicatesInChain(DungeonPackConfigReader.parseBoolean(value));
                            break block15;
                        }
                        if (name.equalsIgnoreCase("AllowPackChangeOut")) {
                            config.setAllowPackChangeOut(DungeonPackConfigReader.parseBoolean(value));
                            break block15;
                        }
                        if (name.equalsIgnoreCase("AllowPackChangeIn")) {
                            config.setAllowPackChangeIn(DungeonPackConfigReader.parseBoolean(value));
                            break block15;
                        }
                        if (name.equalsIgnoreCase("DistortDoorCoordinates")) {
                            config.setDistortDoorCoordinates(DungeonPackConfigReader.parseBoolean(value));
                            break block15;
                        }
                        if (name.equalsIgnoreCase("PackWeight")) {
                            int weight = Integer.parseInt(value);
                            if (weight >= 1 && weight <= 10000) {
                                config.setPackWeight(weight);
                            } else {
                                valid = false;
                            }
                            break block15;
                        }
                        if (name.equalsIgnoreCase("DuplicateSearchLevels")) {
                            int levels = Integer.parseInt(value);
                            if (levels >= 0 && levels <= 5) {
                                config.setDuplicateSearchLevels(levels);
                            } else {
                                valid = false;
                            }
                            break block15;
                        }
                        valid = false;
                    }
                    catch (Exception e) {
                        valid = false;
                    }
                } else {
                    valid = false;
                }
            }
            if (!valid) {
                throw new ConfigurationProcessingException("The dungeon pack config has an invalid setting: " + line);
            }
        }
    }

    private class DungeonTypeProcessor
    implements ILineProcessor {
        private DungeonTypeProcessor() {
        }

        @Override
        public void process(String line, DungeonPackConfig config) throws ConfigurationProcessingException {
            ArrayList<String> typeNames = config.getTypeNames();
            if (DungeonPackConfigReader.this.DUNGEON_TYPE_PATTERN.matcher(line).matches()) {
                if (!typeNames.contains(line = line.toUpperCase())) {
                    typeNames.add(line);
                }
            } else {
                throw new ConfigurationProcessingException("The dungeon pack config has a dungeon type with illegal characters in its name: " + line);
            }
        }
    }

    private static interface ILineProcessor {
        public void process(String var1, DungeonPackConfig var2) throws ConfigurationProcessingException;
    }
}

