/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.dungeon.pack;

import StevenDimDoors.mod_pocketDim.core.NewDimData;
import StevenDimDoors.mod_pocketDim.dungeon.DungeonData;
import StevenDimDoors.mod_pocketDim.dungeon.pack.DungeonChainRule;
import StevenDimDoors.mod_pocketDim.dungeon.pack.DungeonChainRuleDefinition;
import StevenDimDoors.mod_pocketDim.dungeon.pack.DungeonPackConfig;
import StevenDimDoors.mod_pocketDim.dungeon.pack.DungeonType;
import StevenDimDoors.mod_pocketDim.helpers.DungeonHelper;
import StevenDimDoors.mod_pocketDim.util.WeightedContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.util.WeightedRandom;

public class DungeonPack {
    private static final int MAX_HISTORY_LENGTH = 30;
    private static final int MAX_SUBTREE_LIST_SIZE = 30;
    private final String name;
    private final HashMap<String, DungeonType> nameToTypeMapping;
    private final ArrayList<ArrayList<DungeonData>> groupedDungeons;
    private final ArrayList<DungeonData> allDungeons;
    private final DungeonPackConfig config;
    private final int maxRuleLength;
    private final ArrayList<DungeonChainRule> rules;

    public DungeonPack(DungeonPackConfig config) {
        config.validate();
        this.config = config.clone();
        this.name = config.getName();
        int maxLength = 0;
        int typeCount = config.getTypeNames().size();
        this.allDungeons = new ArrayList();
        this.nameToTypeMapping = new HashMap(typeCount);
        this.groupedDungeons = new ArrayList(typeCount);
        this.groupedDungeons.add(this.allDungeons);
        this.nameToTypeMapping.put(DungeonType.WILDCARD_TYPE.Name, DungeonType.WILDCARD_TYPE);
        int index = 1;
        for (String typeName : config.getTypeNames()) {
            String standardName = typeName.toUpperCase();
            this.nameToTypeMapping.put(standardName, new DungeonType(this, standardName, index));
            this.groupedDungeons.add(new ArrayList());
            ++index;
        }
        ArrayList<DungeonChainRuleDefinition> definitions = config.getRules();
        this.rules = new ArrayList(definitions.size());
        for (DungeonChainRuleDefinition definition : definitions) {
            DungeonChainRule rule = new DungeonChainRule(definition, this.nameToTypeMapping);
            this.rules.add(rule);
            if (maxLength >= rule.length()) continue;
            maxLength = rule.length();
        }
        this.maxRuleLength = maxLength;
        this.config.setRules(null);
        this.config.setTypeNames(null);
    }

    public String getName() {
        return this.name;
    }

    public DungeonPackConfig getConfig() {
        return this.config.clone();
    }

    public boolean isEmpty() {
        return this.allDungeons.isEmpty();
    }

    public DungeonType getType(String typeName) {
        DungeonType result = this.nameToTypeMapping.get(typeName.toUpperCase());
        if (result.Owner == this) {
            return result;
        }
        return null;
    }

    public boolean isKnownType(String typeName) {
        return this.getType(typeName) != null;
    }

    public void addDungeon(DungeonData dungeon) {
        DungeonType type = dungeon.dungeonType();
        if (type.Owner != this) {
            throw new IllegalArgumentException("The dungeon type of generator must belong to this instance of DungeonPack.");
        }
        this.allDungeons.add(dungeon);
        this.groupedDungeons.get(type.ID).add(dungeon);
    }

    public DungeonData getNextDungeon(NewDimData parent, Random random) {
        NewDimData ancestor;
        if (this.allDungeons.isEmpty()) {
            return null;
        }
        int maxSearchLength = this.config.allowDuplicatesInChain() ? this.maxRuleLength : 30;
        ArrayList<DungeonData> history = DungeonHelper.getDungeonChainHistory(parent, this, maxSearchLength);
        ArrayList<DungeonData> subtreeHistory = null;
        if (this.config.getDuplicateSearchLevels() > 0 && (ancestor = DungeonHelper.getAncestor(parent, this, this.config.getDuplicateSearchLevels() - 1)) != null) {
            subtreeHistory = DungeonHelper.listDungeonsInTree(ancestor, this, 30);
        }
        if (subtreeHistory == null) {
            subtreeHistory = new ArrayList<DungeonData>();
        }
        subtreeHistory = new ArrayList();
        return this.getNextDungeon(history, subtreeHistory, random);
    }

    private DungeonData getNextDungeon(ArrayList<DungeonData> history, ArrayList<DungeonData> subtreeHistory, Random random) {
        int index;
        int[] typeHistory = new int[history.size()];
        HashSet<DungeonData> excludedDungeons = null;
        boolean doExclude = !this.config.allowDuplicatesInChain() || !subtreeHistory.isEmpty();
        for (index = 0; index < typeHistory.length; ++index) {
            typeHistory[index] = history.get((int)index).dungeonType().ID;
        }
        for (DungeonChainRule rule : this.rules) {
            DungeonType nextType;
            if (!rule.evaluate(typeHistory)) continue;
            ArrayList<WeightedContainer<DungeonType>> products = rule.products();
            block2: do {
                ArrayList<DungeonData> candidates;
                if ((nextType = DungeonPack.getRandomDungeonType(random, products, this.groupedDungeons)) == null) continue;
                if (excludedDungeons == null && doExclude) {
                    if (this.config.allowDuplicatesInChain()) {
                        excludedDungeons = new HashSet<DungeonData>(subtreeHistory);
                        excludedDungeons.addAll(subtreeHistory);
                    } else {
                        excludedDungeons = new HashSet(2 * (history.size() + subtreeHistory.size()));
                        excludedDungeons.addAll(history);
                        excludedDungeons.addAll(subtreeHistory);
                    }
                }
                ArrayList<DungeonData> group = this.groupedDungeons.get(nextType.ID);
                if (excludedDungeons != null && !excludedDungeons.isEmpty()) {
                    candidates = new ArrayList(group.size());
                    for (DungeonData dungeon : group) {
                        if (excludedDungeons.contains(dungeon)) continue;
                        candidates.add(dungeon);
                    }
                } else {
                    candidates = group;
                }
                if (!candidates.isEmpty()) {
                    return DungeonPack.getRandomDungeon(random, candidates);
                }
                for (index = 0; index < products.size(); ++index) {
                    if (!products.get(index).getData().equals(nextType)) continue;
                    products.remove(index);
                    continue block2;
                }
            } while (nextType != null);
        }
        return this.getRandomDungeon(random);
    }

    public DungeonData getRandomDungeon(Random random) {
        if (!this.allDungeons.isEmpty()) {
            return DungeonPack.getRandomDungeon(random, this.allDungeons);
        }
        return null;
    }

    private static DungeonType getRandomDungeonType(Random random, Collection<WeightedContainer<DungeonType>> types, ArrayList<ArrayList<DungeonData>> groupedDungeons) {
        while (!types.isEmpty()) {
            WeightedContainer resultContainer = (WeightedContainer)WeightedRandom.func_76271_a((Random)random, types);
            DungeonType selectedType = (DungeonType)resultContainer.getData();
            if (!groupedDungeons.get(selectedType.ID).isEmpty()) {
                return selectedType;
            }
            types.remove((Object)resultContainer);
        }
        return null;
    }

    private static DungeonData getRandomDungeon(Random random, Collection<DungeonData> dungeons) {
        ArrayList<WeightedContainer<DungeonData>> weights = new ArrayList<WeightedContainer<DungeonData>>(dungeons.size());
        for (DungeonData dungeon : dungeons) {
            weights.add(new WeightedContainer<DungeonData>(dungeon, dungeon.weight()));
        }
        WeightedContainer resultContainer = (WeightedContainer)WeightedRandom.func_76271_a((Random)random, weights);
        return resultContainer != null ? (DungeonData)resultContainer.getData() : null;
    }

    public String toString() {
        return this.name;
    }
}

