/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.dungeon.pack;

import StevenDimDoors.mod_pocketDim.dungeon.pack.DungeonChainRuleDefinition;
import StevenDimDoors.mod_pocketDim.dungeon.pack.DungeonType;
import StevenDimDoors.mod_pocketDim.util.WeightedContainer;
import java.util.ArrayList;
import java.util.HashMap;

public class DungeonChainRule {
    private final int[] condition;
    private final ArrayList<WeightedContainer<DungeonType>> products;

    public DungeonChainRule(DungeonChainRuleDefinition source, HashMap<String, DungeonType> nameToTypeMapping) {
        ArrayList<String> conditionNames = source.getCondition();
        ArrayList<WeightedContainer<String>> productNames = source.getProducts();
        if (conditionNames == null) {
            throw new NullPointerException("source cannot have null conditions");
        }
        if (productNames == null) {
            throw new NullPointerException("source cannot have null products");
        }
        if (productNames.isEmpty()) {
            throw new IllegalArgumentException("products cannot be an empty list");
        }
        for (WeightedContainer<String> product : productNames) {
            if (product.field_76292_a >= 1) continue;
            throw new IllegalArgumentException("products cannot contain items with weights less than 1");
        }
        this.condition = new int[conditionNames.size()];
        int src = 0;
        int dst = this.condition.length - 1;
        while (src < this.condition.length) {
            this.condition[dst] = nameToTypeMapping.get((Object)conditionNames.get((int)src)).ID;
            ++src;
            --dst;
        }
        this.products = new ArrayList(productNames.size());
        for (WeightedContainer<String> product : productNames) {
            this.products.add(new WeightedContainer<DungeonType>(nameToTypeMapping.get(product.getData()), product.field_76292_a));
        }
    }

    public int length() {
        return this.condition.length;
    }

    public boolean evaluate(int[] typeHistory) {
        if (typeHistory.length >= this.condition.length) {
            for (int k = 0; k < this.condition.length; ++k) {
                if (this.condition[k] == 0 || typeHistory[k] == this.condition[k]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ArrayList<WeightedContainer<DungeonType>> products() {
        ArrayList<WeightedContainer<DungeonType>> copy = new ArrayList<WeightedContainer<DungeonType>>(this.products.size());
        for (WeightedContainer<DungeonType> container : this.products) {
            copy.add(container.clone());
        }
        return copy;
    }
}

