/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.dungeon;

import StevenDimDoors.mod_pocketDim.Point3D;
import StevenDimDoors.mod_pocketDim.schematic.Schematic;
import StevenDimDoors.mod_pocketDim.schematic.SchematicFilter;
import java.util.ArrayList;
import net.minecraft.block.Block;

public class SpecialBlockFinder
extends SchematicFilter {
    private Block warpDoor;
    private Block dimensionalDoor;
    private Block monolithSpawnMarker;
    private Block exitMarker;
    private int entranceOrientation;
    private Schematic schematic;
    private Point3D entranceDoorLocation;
    private ArrayList<Point3D> exitDoorLocations;
    private ArrayList<Point3D> dimensionalDoorLocations;
    private ArrayList<Point3D> monolithSpawnLocations;

    public SpecialBlockFinder(Block warpDoor, Block dimensionalDoor, Block monolithSpawn, Block exitDoor) {
        super("SpecialBlockFinder");
        this.warpDoor = warpDoor;
        this.dimensionalDoor = dimensionalDoor;
        this.monolithSpawnMarker = monolithSpawn;
        this.exitMarker = exitDoor;
        this.entranceDoorLocation = null;
        this.entranceOrientation = 0;
        this.exitDoorLocations = new ArrayList();
        this.dimensionalDoorLocations = new ArrayList();
        this.monolithSpawnLocations = new ArrayList();
        this.schematic = null;
    }

    public int getEntranceOrientation() {
        return this.entranceOrientation;
    }

    public Point3D getEntranceDoorLocation() {
        return this.entranceDoorLocation;
    }

    public ArrayList<Point3D> getExitDoorLocations() {
        return this.exitDoorLocations;
    }

    public ArrayList<Point3D> getDimensionalDoorLocations() {
        return this.dimensionalDoorLocations;
    }

    public ArrayList<Point3D> getMonolithSpawnLocations() {
        return this.monolithSpawnLocations;
    }

    @Override
    protected boolean initialize(Schematic schematic, Block[] blocks, byte[] metadata) {
        this.schematic = schematic;
        return true;
    }

    @Override
    protected boolean applyToBlock(int index, Block[] blocks, byte[] metadata) {
        int indexBelow;
        if (blocks[index] == this.monolithSpawnMarker) {
            this.monolithSpawnLocations.add(this.schematic.calculatePoint(index));
            return true;
        }
        if (blocks[index] == this.dimensionalDoor) {
            int indexBelow2 = this.schematic.calculateIndexBelow(index);
            if (indexBelow2 >= 0 && blocks[indexBelow2] == this.dimensionalDoor) {
                this.dimensionalDoorLocations.add(this.schematic.calculatePoint(index));
                return true;
            }
            return false;
        }
        if (blocks[index] == this.warpDoor && (indexBelow = this.schematic.calculateIndexBelow(index)) >= 0 && blocks[indexBelow] == this.warpDoor) {
            int indexDoubleBelow = this.schematic.calculateIndexBelow(indexBelow);
            if (indexDoubleBelow >= 0 && blocks[indexDoubleBelow] == this.exitMarker) {
                this.exitDoorLocations.add(this.schematic.calculatePoint(index));
                return true;
            }
            if (this.entranceDoorLocation == null) {
                this.entranceDoorLocation = this.schematic.calculatePoint(index);
                this.entranceOrientation = metadata[indexBelow] & 3;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean terminates() {
        return false;
    }
}

