/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.dungeon;

import StevenDimDoors.mod_pocketDim.Point3D;
import StevenDimDoors.mod_pocketDim.blocks.IDimDoor;
import StevenDimDoors.mod_pocketDim.config.DDProperties;
import StevenDimDoors.mod_pocketDim.core.DimLink;
import StevenDimDoors.mod_pocketDim.core.LinkType;
import StevenDimDoors.mod_pocketDim.core.NewDimData;
import StevenDimDoors.mod_pocketDim.core.PocketManager;
import StevenDimDoors.mod_pocketDim.dungeon.FillContainersOperation;
import StevenDimDoors.mod_pocketDim.dungeon.ModBlockFilter;
import StevenDimDoors.mod_pocketDim.dungeon.SpecialBlockFinder;
import StevenDimDoors.mod_pocketDim.mod_pocketDim;
import StevenDimDoors.mod_pocketDim.schematic.BlockRotator;
import StevenDimDoors.mod_pocketDim.schematic.ChunkBlockSetter;
import StevenDimDoors.mod_pocketDim.schematic.CompoundFilter;
import StevenDimDoors.mod_pocketDim.schematic.IBlockSetter;
import StevenDimDoors.mod_pocketDim.schematic.InvalidSchematicException;
import StevenDimDoors.mod_pocketDim.schematic.Schematic;
import StevenDimDoors.mod_pocketDim.schematic.WorldBlockSetter;
import StevenDimDoors.mod_pocketDim.ticking.CustomLimboPopulator;
import StevenDimDoors.mod_pocketDim.ticking.MobMonolith;
import StevenDimDoors.mod_pocketDim.util.Point4D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.world.World;

public class DungeonSchematic
extends Schematic {
    private static final int NETHER_DIMENSION_ID = -1;
    private int orientation;
    private Point3D entranceDoorLocation;
    private ArrayList<Point3D> exitDoorLocations;
    private ArrayList<Point3D> dimensionalDoorLocations;
    private ArrayList<Point3D> monolithSpawnLocations;
    private ArrayList<Block> modBlockFilterExceptions;

    private DungeonSchematic(Schematic source) {
        super(source);
        this.modBlockFilterExceptions = new ArrayList(5);
        this.modBlockFilterExceptions.add(mod_pocketDim.blockDimWall);
        this.modBlockFilterExceptions.add(mod_pocketDim.blockDimWallPerm);
        this.modBlockFilterExceptions.add(mod_pocketDim.warpDoor);
        this.modBlockFilterExceptions.add((Block)mod_pocketDim.dimensionalDoor);
        this.modBlockFilterExceptions.add(mod_pocketDim.transientDoor);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public Point3D getEntranceDoorLocation() {
        return this.entranceDoorLocation != null ? this.entranceDoorLocation.clone() : null;
    }

    private DungeonSchematic() {
        super((short)0, (short)0, (short)0, null, null, null);
    }

    public static DungeonSchematic readFromFile(String schematicPath) throws FileNotFoundException, InvalidSchematicException {
        return DungeonSchematic.readFromFile(new File(schematicPath));
    }

    public static DungeonSchematic readFromFile(File schematicFile) throws FileNotFoundException, InvalidSchematicException {
        return DungeonSchematic.readFromStream(new FileInputStream(schematicFile));
    }

    public static DungeonSchematic readFromResource(String resourcePath) throws InvalidSchematicException {
        DungeonSchematic empty = new DungeonSchematic();
        InputStream schematicStream = empty.getClass().getResourceAsStream(resourcePath);
        return DungeonSchematic.readFromStream(schematicStream);
    }

    public static DungeonSchematic readFromStream(InputStream schematicStream) throws InvalidSchematicException {
        return new DungeonSchematic(Schematic.readFromStream(schematicStream));
    }

    public void applyImportFilters(DDProperties properties) {
        SpecialBlockFinder finder = new SpecialBlockFinder(mod_pocketDim.warpDoor, (Block)mod_pocketDim.dimensionalDoor, Blocks.field_150378_br, Blocks.field_150322_A);
        this.applyFilter(finder);
        this.orientation = BlockRotator.transformMetadata(finder.getEntranceOrientation(), 2, Blocks.field_150466_ao);
        this.entranceDoorLocation = finder.getEntranceDoorLocation();
        this.exitDoorLocations = finder.getExitDoorLocations();
        this.dimensionalDoorLocations = finder.getDimensionalDoorLocations();
        this.monolithSpawnLocations = finder.getMonolithSpawnLocations();
        CompoundFilter standardizer = new CompoundFilter();
        standardizer.addFilter(new ModBlockFilter(this.modBlockFilterExceptions, mod_pocketDim.blockDimWall, 0));
        this.applyFilter(standardizer);
    }

    public void applyExportFilters(DDProperties properties) {
        CompoundFilter standardizer = new CompoundFilter();
        standardizer.addFilter(new ModBlockFilter(this.modBlockFilterExceptions, mod_pocketDim.blockDimWall, 0));
        this.applyFilter(standardizer);
    }

    public static DungeonSchematic copyFromWorld(World world, int x, int y, int z, short width, short height, short length, boolean doCompactBounds) {
        return new DungeonSchematic(Schematic.copyFromWorld(world, x, y, z, width, height, length, doCompactBounds));
    }

    public void copyToWorld(World world, Point3D pocketCenter, int targetOrientation, DimLink entryLink, Random random, DDProperties properties, boolean notifyClients) {
        if (notifyClients) {
            this.copyToWorld(world, pocketCenter, targetOrientation, entryLink, random, properties, new WorldBlockSetter(false, true, false));
        } else {
            this.copyToWorld(world, pocketCenter, targetOrientation, entryLink, random, properties, new ChunkBlockSetter(false));
        }
    }

    public void copyToWorld(World world, Point3D pocketCenter, int targetOrientation, DimLink entryLink, Random random, DDProperties properties, IBlockSetter blockSetter) {
        int turnAngle = targetOrientation - this.orientation;
        Point3D pocketPoint = new Point3D(0, 0, 0);
        int index = 0;
        for (int dy = 0; dy < this.height; ++dy) {
            for (int dz = 0; dz < this.length; ++dz) {
                for (int dx = 0; dx < this.width; ++dx) {
                    pocketPoint.setX(dx);
                    pocketPoint.setY(dy);
                    pocketPoint.setZ(dz);
                    Block block = this.blocks[index];
                    BlockRotator.transformPoint(pocketPoint, this.entranceDoorLocation, turnAngle, pocketCenter);
                    int blockMeta = BlockRotator.transformMetadata(this.metadata[index], turnAngle, block);
                    blockSetter.setBlock(world, pocketPoint.getX(), pocketPoint.getY(), pocketPoint.getZ(), block, blockMeta);
                    ++index;
                }
            }
        }
        int count = this.tileEntities.func_74745_c();
        for (index = 0; index < count; ++index) {
            NBTTagCompound tileTag = this.tileEntities.func_150305_b(index);
            pocketPoint.setX(tileTag.func_74762_e("x"));
            pocketPoint.setY(tileTag.func_74762_e("y"));
            pocketPoint.setZ(tileTag.func_74762_e("z"));
            BlockRotator.transformPoint(pocketPoint, this.entranceDoorLocation, turnAngle, pocketCenter);
            tileTag.func_74768_a("x", pocketPoint.getX());
            tileTag.func_74768_a("y", pocketPoint.getY());
            tileTag.func_74768_a("z", pocketPoint.getZ());
            world.func_147455_a(pocketPoint.getX(), pocketPoint.getY(), pocketPoint.getZ(), TileEntity.func_145827_c((NBTTagCompound)tileTag));
        }
        this.setUpDungeon(PocketManager.createDimensionData(world), world, pocketCenter, turnAngle, entryLink, random, properties, blockSetter);
    }

    private void setUpDungeon(NewDimData dimension, World world, Point3D pocketCenter, int turnAngle, DimLink entryLink, Random random, DDProperties properties, IBlockSetter blockSetter) {
        Point3D minCorner = new Point3D(0, 0, 0);
        Point3D maxCorner = new Point3D(this.width - 1, this.height - 1, this.length - 1);
        DungeonSchematic.transformCorners(this.entranceDoorLocation, pocketCenter, turnAngle, minCorner, maxCorner);
        FillContainersOperation filler = new FillContainersOperation(random, properties);
        filler.apply(world, minCorner, maxCorner);
        DungeonSchematic.createEntranceReverseLink(world, dimension, pocketCenter, entryLink);
        for (Point3D location : this.dimensionalDoorLocations) {
            DungeonSchematic.createDimensionalDoorLink(world, dimension, location, this.entranceDoorLocation, turnAngle, pocketCenter);
        }
        for (Point3D location : this.exitDoorLocations) {
            DungeonSchematic.createExitDoorLink(world, dimension, location, this.entranceDoorLocation, turnAngle, pocketCenter, blockSetter);
        }
        boolean canSpawn = CustomLimboPopulator.isMobSpawningAllowed();
        for (Point3D location : this.monolithSpawnLocations) {
            DungeonSchematic.spawnMonolith(world, location, this.entranceDoorLocation, turnAngle, pocketCenter, canSpawn, blockSetter);
        }
        if (dimension.root().id() == -1) {
            DungeonSchematic.writeDepthSign(world, pocketCenter, dimension.depth());
        }
    }

    private static void transformCorners(Point3D schematicEntrance, Point3D pocketCenter, int turnAngle, Point3D minCorner, Point3D maxCorner) {
        int temp;
        BlockRotator.transformPoint(minCorner, schematicEntrance, turnAngle, pocketCenter);
        BlockRotator.transformPoint(maxCorner, schematicEntrance, turnAngle, pocketCenter);
        if (minCorner.getX() > maxCorner.getX()) {
            temp = minCorner.getX();
            minCorner.setX(maxCorner.getX());
            maxCorner.setX(temp);
        }
        if (minCorner.getY() > maxCorner.getY()) {
            temp = minCorner.getY();
            minCorner.setY(maxCorner.getY());
            maxCorner.setY(temp);
        }
        if (minCorner.getZ() > maxCorner.getZ()) {
            temp = minCorner.getZ();
            minCorner.setZ(maxCorner.getZ());
            maxCorner.setZ(temp);
        }
    }

    private static void createEntranceReverseLink(World world, NewDimData dimension, Point3D pocketCenter, DimLink entryLink) {
        int orientation = world.func_72805_g(pocketCenter.getX(), pocketCenter.getY() - 1, pocketCenter.getZ());
        DimLink reverseLink = dimension.createLink(pocketCenter.getX(), pocketCenter.getY(), pocketCenter.getZ(), LinkType.REVERSE, orientation);
        Point4D destination = entryLink.source();
        NewDimData prevDim = PocketManager.getDimensionData(destination.getDimension());
        prevDim.setLinkDestination(reverseLink, destination.getX(), destination.getY(), destination.getZ());
        DungeonSchematic.initDoorTileEntity(world, pocketCenter);
    }

    private static void createExitDoorLink(World world, NewDimData dimension, Point3D point, Point3D entrance, int rotation, Point3D pocketCenter, IBlockSetter blockSetter) {
        Point3D location = point.clone();
        BlockRotator.transformPoint(location, entrance, rotation, pocketCenter);
        int orientation = world.func_72805_g(location.getX(), location.getY() - 1, location.getZ());
        dimension.createLink(location.getX(), location.getY(), location.getZ(), LinkType.DUNGEON_EXIT, orientation);
        int x = location.getX();
        int y = location.getY() - 3;
        int z = location.getZ();
        if (y >= 0) {
            Block block = world.func_147439_a(x, y, z);
            int metadata = world.func_72805_g(x, y, z);
            blockSetter.setBlock(world, x, y + 1, z, block, metadata);
        }
        DungeonSchematic.initDoorTileEntity(world, location);
    }

    private static void createDimensionalDoorLink(World world, NewDimData dimension, Point3D point, Point3D entrance, int rotation, Point3D pocketCenter) {
        Point3D location = point.clone();
        BlockRotator.transformPoint(location, entrance, rotation, pocketCenter);
        int orientation = world.func_72805_g(location.getX(), location.getY() - 1, location.getZ());
        dimension.createLink(location.getX(), location.getY(), location.getZ(), LinkType.DUNGEON, orientation);
        DungeonSchematic.initDoorTileEntity(world, location);
    }

    private static void spawnMonolith(World world, Point3D point, Point3D entrance, int rotation, Point3D pocketCenter, boolean canSpawn, IBlockSetter blockSetter) {
        Point3D location = point.clone();
        BlockRotator.transformPoint(location, entrance, rotation, pocketCenter);
        blockSetter.setBlock(world, location.getX(), location.getY(), location.getZ(), Blocks.field_150350_a, 0);
        if (canSpawn) {
            MobMonolith mob = new MobMonolith(world);
            mob.func_70012_b(location.getX(), location.getY(), location.getZ(), 1.0f, 1.0f);
            world.func_72838_d((Entity)mob);
        }
    }

    private static void initDoorTileEntity(World world, Point3D point) {
        Block door = world.func_147439_a(point.getX(), point.getY(), point.getZ());
        Block door2 = world.func_147439_a(point.getX(), point.getY() - 1, point.getZ());
        if (!(door instanceof IDimDoor) || !(door2 instanceof IDimDoor)) {
            throw new IllegalArgumentException("Tried to init a dim door TE on a block that isnt a Dim Door!!");
        }
        ((IDimDoor)door).initDoorTE(world, point.getX(), point.getY(), point.getZ());
        ((IDimDoor)door).initDoorTE(world, point.getX(), point.getY() - 1, point.getZ());
    }

    private static void writeDepthSign(World world, Point3D pocketCenter, int depth) {
        int SEARCH_RANGE = 6;
        for (int dy = 6; dy >= -6; --dy) {
            for (int dz = -6; dz <= 6; ++dz) {
                for (int dx = -6; dx <= 6; ++dx) {
                    int z;
                    int y;
                    int x = pocketCenter.getX() + dx;
                    Block block = world.func_147439_a(x, y = pocketCenter.getY() + dy, z = pocketCenter.getZ() + dz);
                    if (block != Blocks.field_150444_as && block != Blocks.field_150472_an) continue;
                    TileEntitySign signEntity = new TileEntitySign();
                    signEntity.field_145915_a[1] = "Level " + depth;
                    world.func_147455_a(x, y, z, (TileEntity)signEntity);
                    return;
                }
            }
        }
    }
}

