/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.dungeon;

import StevenDimDoors.mod_pocketDim.dungeon.DungeonSchematic;
import StevenDimDoors.mod_pocketDim.dungeon.pack.DungeonType;
import StevenDimDoors.mod_pocketDim.schematic.InvalidSchematicException;
import java.io.FileNotFoundException;

public class DungeonData {
    private final int weight;
    private final boolean isOpen;
    private final boolean isInternal;
    private final String schematicPath;
    private final String schematicName;
    private final DungeonType dungeonType;

    public DungeonData(String schematicPath, boolean isInternal, DungeonType dungeonType, boolean isOpen, int weight) {
        this.schematicPath = schematicPath;
        this.schematicName = DungeonData.getSchematicName(schematicPath);
        this.dungeonType = dungeonType;
        this.isInternal = isInternal;
        this.isOpen = isOpen;
        this.weight = weight;
    }

    private static String getSchematicName(String schematicPath) {
        int indexA = schematicPath.lastIndexOf(92);
        int indexB = schematicPath.lastIndexOf(47);
        indexA = Math.max(indexA, indexB) + 1;
        return schematicPath.substring(indexA, schematicPath.length() - ".schematic".length());
    }

    public int weight() {
        return this.weight;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public String schematicPath() {
        return this.schematicPath;
    }

    public DungeonType dungeonType() {
        return this.dungeonType;
    }

    public String schematicName() {
        return this.schematicName;
    }

    public DungeonSchematic loadSchematic() throws InvalidSchematicException, FileNotFoundException {
        if (this.isInternal) {
            return DungeonSchematic.readFromResource(this.schematicPath);
        }
        return DungeonSchematic.readFromFile(this.schematicPath);
    }
}

