/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.core;

import StevenDimDoors.mod_pocketDim.config.DDProperties;
import StevenDimDoors.mod_pocketDim.core.DimLink;
import StevenDimDoors.mod_pocketDim.core.DimensionType;
import StevenDimDoors.mod_pocketDim.core.IDimRegistrationCallback;
import StevenDimDoors.mod_pocketDim.core.LinkType;
import StevenDimDoors.mod_pocketDim.core.NewDimData;
import StevenDimDoors.mod_pocketDim.helpers.Compactor;
import StevenDimDoors.mod_pocketDim.helpers.DeleteFolder;
import StevenDimDoors.mod_pocketDim.mod_pocketDim;
import StevenDimDoors.mod_pocketDim.saving.DDSaveHandler;
import StevenDimDoors.mod_pocketDim.saving.OldSaveImporter;
import StevenDimDoors.mod_pocketDim.saving.PackedDimData;
import StevenDimDoors.mod_pocketDim.util.Point4D;
import StevenDimDoors.mod_pocketDim.watcher.ClientDimData;
import StevenDimDoors.mod_pocketDim.watcher.ClientLinkData;
import StevenDimDoors.mod_pocketDim.watcher.IUpdateWatcher;
import StevenDimDoors.mod_pocketDim.watcher.UpdateWatcherProxy;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class PocketManager {
    private static int OVERWORLD_DIMENSION_ID = 0;
    private static volatile boolean isLoading = false;
    private static volatile boolean isLoaded = false;
    private static volatile boolean isSaving = false;
    public static volatile boolean isConnected = false;
    private static final UpdateWatcherProxy<ClientLinkData> linkWatcher = new UpdateWatcherProxy();
    private static final UpdateWatcherProxy<ClientDimData> dimWatcher = new UpdateWatcherProxy();
    private static ArrayList<NewDimData> rootDimensions = null;
    private static HashMap<Integer, InnerDimData> dimensionData = null;
    private static ArrayList<Integer> dimensionIDBlackList = null;
    private static HashMap<String, NewDimData> personalPocketsMapping = null;

    public static boolean isLoaded() {
        return isLoaded;
    }

    public static void load() {
        if (isLoaded) {
            throw new IllegalStateException("Pocket dimensions have already been loaded!");
        }
        if (isLoading) {
            return;
        }
        isLoading = true;
        dimensionData = new HashMap();
        rootDimensions = new ArrayList();
        dimensionIDBlackList = new ArrayList();
        personalPocketsMapping = new HashMap();
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            isLoading = false;
            isLoaded = true;
            return;
        }
        DDProperties properties = DDProperties.instance();
        PocketManager.registerDimension(properties.LimboDimensionID, null, DimensionType.ROOT);
        PocketManager.loadInternal();
        PocketManager.registerPockets(properties);
        isLoaded = true;
        isLoading = false;
    }

    public static boolean registerPackedDimData(PackedDimData packedData) {
        InnerDimData dimData;
        DimensionType type = DimensionType.getTypeFromIndex(packedData.DimensionType);
        if (type == null) {
            throw new IllegalArgumentException("Invalid dimension type");
        }
        if (packedData.ID == packedData.ParentID) {
            dimData = new InnerDimData(packedData.ID, null, type, linkWatcher);
            dimData.root = dimData;
            dimData.parent = dimData;
            dimData.depth = packedData.Depth;
            dimData.isFilled = packedData.IsFilled;
            dimData.origin = new Point4D(packedData.Origin.getX(), packedData.Origin.getY(), packedData.Origin.getZ(), packedData.ID);
            rootDimensions.add(dimData);
        } else {
            InnerDimData test = dimensionData.get(packedData.ParentID);
            dimData = new InnerDimData(packedData.ID, test, type, linkWatcher);
            dimData.isFilled = packedData.IsFilled;
            dimData.origin = new Point4D(packedData.Origin.getX(), packedData.Origin.getY(), packedData.Origin.getZ(), packedData.ID);
            dimData.root = PocketManager.createDimensionData(packedData.RootID);
            if (packedData.DungeonData != null) {
                dimData.dungeon = DDSaveHandler.unpackDungeonData(packedData.DungeonData);
            }
        }
        dimensionData.put(dimData.id, dimData);
        PocketManager.getDimwatcher().onCreated(new ClientDimData(dimData));
        return true;
    }

    public static boolean deletePocket(NewDimData target, boolean deleteFolder) {
        InnerDimData dimension = (InnerDimData)target;
        if (dimension.isPocketDimension() && DimensionManager.getWorld((int)dimension.id()) == null) {
            if (deleteFolder) {
                PocketManager.deleteDimensionFiles(dimension);
            }
            dimensionIDBlackList.add(dimension.id);
            PocketManager.deleteDimensionData(dimension);
            return true;
        }
        return false;
    }

    private static void deleteDimensionFiles(InnerDimData dimension) {
        String saveRootPath = DimensionManager.getCurrentSaveRootDirectory().getAbsolutePath();
        File saveDirectory = new File(saveRootPath + "/DimensionalDoors/pocketDimID" + dimension.id());
        DeleteFolder.deleteFolder(saveDirectory);
        File dataFile = new File(saveRootPath + "/DimensionalDoors/data/dim_" + dimension.id() + ".txt");
        dataFile.delete();
    }

    private static void deleteDimensionData(InnerDimData dimension) {
        if (dimensionData.remove(dimension.id()) == null) {
            throw new IllegalArgumentException("The specified dimension is not listed with PocketManager.");
        }
        PocketManager.getDimwatcher().onDeleted(new ClientDimData(dimension));
        dimension.clear();
    }

    private static void registerPockets(DDProperties properties) {
        for (InnerDimData dimension : dimensionData.values()) {
            if (!dimension.isPocketDimension()) continue;
            try {
                if (dimension.type() == DimensionType.PERSONAL) {
                    if (DimensionManager.isDimensionRegistered((int)dimension.id())) continue;
                    DimensionManager.registerDimension((int)dimension.id(), (int)properties.PersonalPocketProviderID);
                    continue;
                }
                DimensionManager.registerDimension((int)dimension.id(), (int)properties.PocketProviderID);
            }
            catch (Exception e) {
                System.err.println("Could not register pocket dimension #" + dimension.id() + ". Probably caused by a version update/save data corruption/other mods.");
                e.printStackTrace();
            }
        }
    }

    private static void unregisterPockets() {
        for (InnerDimData dimension : dimensionData.values()) {
            if (!dimension.isPocketDimension()) continue;
            try {
                DimensionManager.unregisterDimension((int)dimension.id());
            }
            catch (Exception e) {
                System.err.println("An unexpected error occurred while unregistering pocket dimension #" + dimension.id() + ":");
                e.printStackTrace();
            }
        }
        for (Integer dimID : dimensionIDBlackList) {
            try {
                DimensionManager.unregisterDimension((int)dimID);
            }
            catch (Exception e) {
                System.err.println("An unexpected error occurred while unregistering blacklisted dim #" + dimID + ":");
                e.printStackTrace();
            }
        }
    }

    private static void loadInternal() {
        File saveDir = DimensionManager.getCurrentSaveRootDirectory();
        if (saveDir != null) {
            File oldSaveData = new File(saveDir + "/DimensionalDoorsData");
            if (oldSaveData.exists()) {
                try {
                    System.out.println("Importing old DD save data...");
                    OldSaveImporter.importOldSave(oldSaveData);
                    oldSaveData.renameTo(new File(oldSaveData.getAbsolutePath() + "_IMPORTED"));
                    System.out.println("Import Succesful!");
                }
                catch (Exception e) {
                    System.out.println("Import failed!");
                    e.printStackTrace();
                }
                return;
            }
            System.out.println("Loading Dimensional Doors save data...");
            if (DDSaveHandler.loadAll()) {
                System.out.println("Loaded successfully!");
            }
        }
    }

    public static void save(boolean checkModified) {
        if (!isLoaded) {
            return;
        }
        if (isSaving) {
            return;
        }
        isSaving = true;
        try {
            DDSaveHandler.saveAll(dimensionData.values(), dimensionIDBlackList, checkModified);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            isSaving = false;
        }
    }

    public static WorldServer loadDimension(int id) {
        if (!DimensionManager.isDimensionRegistered((int)id)) {
            return null;
        }
        WorldServer world = DimensionManager.getWorld((int)id);
        if (world == null) {
            DimensionManager.initDimension((int)id);
            world = DimensionManager.getWorld((int)id);
        } else if (world.field_73011_w == null) {
            DimensionManager.initDimension((int)id);
            world = DimensionManager.getWorld((int)id);
        }
        return world;
    }

    public static NewDimData registerDimension(World world) {
        return PocketManager.registerDimension(world.field_73011_w.field_76574_g, null, DimensionType.ROOT);
    }

    public static NewDimData registerPocket(NewDimData parent, DimensionType type, String playername) {
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null. A pocket dimension must always have a parent dimension.");
        }
        DDProperties properties = DDProperties.instance();
        int dimensionID = DimensionManager.getNextFreeDimId();
        if (type == DimensionType.PERSONAL) {
            if (playername == null) {
                throw new IllegalArgumentException("A personal pocket must be attached to a playername");
            }
            DimensionManager.registerDimension((int)dimensionID, (int)properties.PersonalPocketProviderID);
            NewDimData data = PocketManager.registerDimension(dimensionID, (InnerDimData)parent, type);
            personalPocketsMapping.put(playername, data);
            return data;
        }
        if (parent.type == DimensionType.PERSONAL) {
            DimensionManager.registerDimension((int)dimensionID, (int)properties.PersonalPocketProviderID);
            NewDimData data = PocketManager.registerDimension(dimensionID, (InnerDimData)parent, DimensionType.PERSONAL);
            return data;
        }
        DimensionManager.registerDimension((int)dimensionID, (int)properties.PocketProviderID);
        return PocketManager.registerDimension(dimensionID, (InnerDimData)parent, type);
    }

    public static NewDimData registerPocket(NewDimData parent, DimensionType type) {
        return PocketManager.registerPocket(parent, type, null);
    }

    private static NewDimData registerDimension(int dimensionID, InnerDimData parent, DimensionType type) {
        if (dimensionData.containsKey(dimensionID)) {
            if (dimensionIDBlackList.contains(dimensionID)) {
                throw new IllegalArgumentException("Cannot register a dimension with ID = " + dimensionID + " because it has been blacklisted.");
            }
            throw new IllegalArgumentException("Cannot register a dimension with ID = " + dimensionID + " because it has already been registered.");
        }
        InnerDimData dimension = new InnerDimData(dimensionID, parent, type, linkWatcher);
        dimensionData.put(dimensionID, dimension);
        if (!dimension.isPocketDimension()) {
            rootDimensions.add(dimension);
        }
        PocketManager.getDimwatcher().onCreated(new ClientDimData(dimension));
        return dimension;
    }

    @SideOnly(value=Side.CLIENT)
    private static NewDimData registerClientDimension(int dimensionID, int rootID, DimensionType type) {
        InnerDimData dimension;
        InnerDimData root = (InnerDimData)PocketManager.createDimensionData(rootID);
        if (rootID != dimensionID) {
            dimension = dimensionData.get(dimensionID);
            if (dimension == null) {
                dimension = new InnerDimData(dimensionID, root, type);
                dimensionData.put(dimension.id(), dimension);
            }
        } else {
            dimension = root;
        }
        if (dimension.isPocketDimension() && !DimensionManager.isDimensionRegistered((int)dimension.id())) {
            int providerID = mod_pocketDim.properties.PocketProviderID;
            if (type == DimensionType.PERSONAL) {
                providerID = mod_pocketDim.properties.PersonalPocketProviderID;
            }
            DimensionManager.registerDimension((int)dimensionID, (int)providerID);
        }
        return dimension;
    }

    public static NewDimData getDimensionData(int dimensionID) {
        return dimensionData.get(dimensionID);
    }

    public static NewDimData getDimensionData(World dimension) {
        return dimensionData.get(dimension.field_73011_w.field_76574_g);
    }

    public static NewDimData createDimensionData(World world) {
        return PocketManager.createDimensionData(world.field_73011_w.field_76574_g);
    }

    public static NewDimData createDimensionDataDangerously(int dimensionID) {
        return PocketManager.createDimensionData(dimensionID);
    }

    protected static NewDimData createDimensionData(int dimensionID) {
        NewDimData dimension = dimensionData.get(dimensionID);
        if (dimension == null) {
            dimension = PocketManager.registerDimension(dimensionID, null, DimensionType.ROOT);
        }
        return dimension;
    }

    public static Iterable<? extends NewDimData> getDimensions() {
        return dimensionData.values();
    }

    public static ArrayList<NewDimData> getRootDimensions() {
        return (ArrayList)rootDimensions.clone();
    }

    public static void tryUnload() {
        if (isConnected) {
            PocketManager.unload();
        }
        isLoading = false;
        isLoaded = false;
    }

    public static void unload() {
        System.out.println("Unloading Pocket Dimensions...");
        if (!isLoaded) {
            throw new IllegalStateException("Pocket dimensions have already been unloaded!");
        }
        PocketManager.unregisterPockets();
        dimensionData = null;
        personalPocketsMapping = null;
        rootDimensions = null;
        isLoaded = false;
        isConnected = false;
    }

    public static DimLink getLink(int x, int y, int z, World world) {
        return PocketManager.getLink(x, y, z, world.field_73011_w.field_76574_g);
    }

    public static DimLink getLink(Point4D point) {
        return PocketManager.getLink(point.getX(), point.getY(), point.getZ(), point.getDimension());
    }

    public static DimLink getLink(int x, int y, int z, int dimensionID) {
        if (!PocketManager.isLoaded()) {
            return null;
        }
        NewDimData dimension = dimensionData.get(dimensionID);
        if (dimension != null) {
            return dimension.getLink(x, y, z);
        }
        return null;
    }

    public static boolean isBlackListed(int dimensionID) {
        return dimensionIDBlackList.contains(dimensionID);
    }

    public static void registerDimWatcher(IUpdateWatcher<ClientDimData> watcher) {
        PocketManager.getDimwatcher().registerReceiver(watcher);
    }

    public static boolean unregisterDimWatcher(IUpdateWatcher<ClientDimData> watcher) {
        return PocketManager.getDimwatcher().unregisterReceiver(watcher);
    }

    public static void registerLinkWatcher(IUpdateWatcher<ClientLinkData> watcher) {
        linkWatcher.registerReceiver(watcher);
    }

    public static boolean unregisterLinkWatcher(IUpdateWatcher<ClientLinkData> watcher) {
        return linkWatcher.unregisterReceiver(watcher);
    }

    public static void writePacket(ByteBuf output) throws IOException {
        Compactor.write(dimensionData.values(), output);
    }

    public static boolean isRegisteredInternally(int dimensionID) {
        return dimensionData.containsKey(dimensionID);
    }

    public static void createAndRegisterBlacklist(List<Integer> blacklist) {
        for (Integer dimID : blacklist) {
            dimensionIDBlackList.add(dimID);
            DimensionManager.registerDimension((int)dimID, (int)DDProperties.instance().PocketProviderID);
        }
    }

    public static void readPacket(ByteBuf input) throws IOException {
        if (isLoaded) {
            return;
        }
        if (isLoading) {
            throw new IllegalStateException("Pocket dimensions are already loading!");
        }
        PocketManager.load();
        Compactor.readDimensions(input, new DimRegistrationCallback());
        isLoaded = true;
        isLoading = false;
        isConnected = true;
    }

    public static UpdateWatcherProxy<ClientDimData> getDimwatcher() {
        return dimWatcher;
    }

    public static UpdateWatcherProxy<ClientLinkData> getLinkWatcher() {
        return linkWatcher;
    }

    public static NewDimData getPersonalDimensionForPlayer(String name) {
        if (personalPocketsMapping.containsKey(name)) {
            return personalPocketsMapping.get(name);
        }
        return null;
    }

    public static void setPersonalPocketsMapping(HashMap<String, NewDimData> ppMap) {
        personalPocketsMapping = ppMap;
    }

    public static HashMap<String, NewDimData> getPersonalPocketMapping() {
        return personalPocketsMapping;
    }

    private static class DimRegistrationCallback
    implements IDimRegistrationCallback {
        private DimRegistrationCallback() {
        }

        @Override
        public NewDimData registerDimension(int dimensionID, int rootID, DimensionType type) {
            return PocketManager.registerClientDimension(dimensionID, rootID, type);
        }
    }

    public static class ClientDimWatcher
    implements IUpdateWatcher<ClientDimData> {
        @Override
        public void onCreated(ClientDimData data) {
            PocketManager.registerClientDimension(data.ID, data.rootID, data.type);
        }

        @Override
        public void onDeleted(ClientDimData data) {
            PocketManager.deletePocket(PocketManager.getDimensionData(data.ID), false);
        }

        @Override
        public void update(ClientDimData message) {
        }
    }

    public static class ClientLinkWatcher
    implements IUpdateWatcher<ClientLinkData> {
        @Override
        public void onCreated(ClientLinkData link) {
            Point4D source = link.point;
            NewDimData dimension = PocketManager.getDimensionData(source.getDimension());
            if (dimension != null && dimension.getLink(source.getX(), source.getY(), source.getZ()) == null) {
                dimension.createLink(source, LinkType.CLIENT, 0, link.lock);
            }
        }

        @Override
        public void onDeleted(ClientLinkData link) {
            Point4D source = link.point;
            NewDimData dimension = PocketManager.getDimensionData(source.getDimension());
            if (dimension != null && dimension.getLink(source.getX(), source.getY(), source.getZ()) != null) {
                dimension.deleteLink(source.getX(), source.getY(), source.getZ());
            }
        }

        @Override
        public void update(ClientLinkData link) {
            Point4D source = link.point;
            NewDimData dimension = PocketManager.getDimensionData(source.getDimension());
            if (dimension != null) {
                DimLink dLink = dimension.getLink(source);
                dLink.lock = link.lock;
            }
        }
    }

    private static class InnerDimData
    extends NewDimData {
        public InnerDimData(int id, InnerDimData parent, DimensionType type, IUpdateWatcher<ClientLinkData> linkWatcher) {
            super(id, parent, type, linkWatcher);
        }

        public InnerDimData(int id, NewDimData root, DimensionType type) {
            super(id, root, type);
        }
    }
}

