/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.core;

import StevenDimDoors.mod_pocketDim.Point3D;
import StevenDimDoors.mod_pocketDim.config.DDProperties;
import StevenDimDoors.mod_pocketDim.core.DDLock;
import StevenDimDoors.mod_pocketDim.core.DimLink;
import StevenDimDoors.mod_pocketDim.core.DimensionType;
import StevenDimDoors.mod_pocketDim.core.LinkTail;
import StevenDimDoors.mod_pocketDim.core.LinkType;
import StevenDimDoors.mod_pocketDim.dungeon.DungeonData;
import StevenDimDoors.mod_pocketDim.dungeon.pack.DungeonPack;
import StevenDimDoors.mod_pocketDim.mod_pocketDim;
import StevenDimDoors.mod_pocketDim.saving.IPackable;
import StevenDimDoors.mod_pocketDim.saving.PackedDimData;
import StevenDimDoors.mod_pocketDim.saving.PackedDungeonData;
import StevenDimDoors.mod_pocketDim.saving.PackedLinkData;
import StevenDimDoors.mod_pocketDim.saving.PackedLinkTail;
import StevenDimDoors.mod_pocketDim.util.Point4D;
import StevenDimDoors.mod_pocketDim.watcher.ClientLinkData;
import StevenDimDoors.mod_pocketDim.watcher.IUpdateWatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import java.util.TreeMap;
import net.minecraft.item.ItemStack;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;

public abstract class NewDimData
implements IPackable<PackedDimData> {
    private static int EXPECTED_LINKS_PER_CHUNK = 2;
    protected static Random random = new Random();
    protected int id;
    protected Map<Point4D, InnerDimLink> linkMapping;
    protected List<InnerDimLink> linkList;
    protected boolean isFilled;
    protected int depth;
    protected int packDepth;
    protected DimensionType type;
    protected NewDimData parent;
    protected NewDimData root;
    protected List<NewDimData> children;
    protected Point4D origin;
    protected int orientation;
    protected DungeonData dungeon;
    protected boolean modified;
    public IUpdateWatcher<ClientLinkData> linkWatcher;
    private Map<ChunkCoordIntPair, List<InnerDimLink>> chunkMapping;

    protected NewDimData(int id, NewDimData parent, DimensionType type, IUpdateWatcher<ClientLinkData> linkWatcher) {
        if (type != DimensionType.ROOT && parent == null) {
            throw new NullPointerException("Dimensions can be pocket dimensions if and only if they have a parent dimension.");
        }
        this.id = id;
        this.linkMapping = new TreeMap<Point4D, InnerDimLink>();
        this.linkList = new ArrayList<InnerDimLink>();
        this.children = new ArrayList<NewDimData>();
        this.parent = parent;
        this.packDepth = 0;
        this.type = type;
        this.isFilled = false;
        this.orientation = 0;
        this.origin = null;
        this.dungeon = null;
        this.linkWatcher = linkWatcher;
        this.chunkMapping = new HashMap<ChunkCoordIntPair, List<InnerDimLink>>();
        this.modified = true;
        if (parent != null) {
            this.root = parent.root;
            this.depth = parent.depth + 1;
            parent.children.add(this);
            parent.modified = true;
        } else {
            this.root = this;
            this.depth = 0;
        }
    }

    protected NewDimData(int id, NewDimData root, DimensionType type) {
        if (root == null) {
            throw new IllegalArgumentException("root cannot be null.");
        }
        this.id = id;
        this.linkMapping = new TreeMap<Point4D, InnerDimLink>();
        this.linkList = new ArrayList<InnerDimLink>();
        this.children = new ArrayList<NewDimData>();
        this.parent = null;
        this.packDepth = 0;
        this.type = type;
        this.isFilled = false;
        this.orientation = 0;
        this.origin = null;
        this.dungeon = null;
        this.linkWatcher = null;
        this.depth = 0;
        this.root = root;
        this.chunkMapping = null;
    }

    public DimLink findNearestRift(World world, int range, int x, int y, int z) {
        if (world.field_73011_w.field_76574_g != this.id) {
            throw new IllegalArgumentException("Attempted to search for links in a World instance for a different dimension!");
        }
        DimLink nearest = null;
        int minDistance = Integer.MAX_VALUE;
        DDProperties properties = DDProperties.instance();
        for (int i = -range; i <= range; ++i) {
            for (int j = -range; j <= range; ++j) {
                for (int k = -range; k <= range; ++k) {
                    DimLink link;
                    int distance = NewDimData.getAbsoluteSum(i, j, k);
                    if (distance <= 0 || distance >= minDistance || world.func_147439_a(x + i, y + j, z + k) != mod_pocketDim.blockRift || (link = this.getLink(x + i, y + j, z + k)) == null) continue;
                    nearest = link;
                    minDistance = distance;
                }
            }
        }
        return nearest;
    }

    public ArrayList<DimLink> findRiftsInRange(World world, int range, int x, int y, int z) {
        if (world.field_73011_w.field_76574_g != this.id) {
            throw new IllegalArgumentException("Attempted to search for links in a World instance for a different dimension!");
        }
        DDProperties properties = DDProperties.instance();
        ArrayList<DimLink> links = new ArrayList<DimLink>();
        for (int i = -range; i <= range; ++i) {
            for (int j = -range; j <= range; ++j) {
                for (int k = -range; k <= range; ++k) {
                    DimLink link;
                    int distance = NewDimData.getAbsoluteSum(i, j, k);
                    if (distance <= 0 || world.func_147439_a(x + i, y + j, z + k) != mod_pocketDim.blockRift || (link = this.getLink(x + i, y + j, z + k)) == null) continue;
                    links.add(link);
                }
            }
        }
        return links;
    }

    private static int getAbsoluteSum(int i, int j, int k) {
        return Math.abs(i) + Math.abs(j) + Math.abs(k);
    }

    public DimLink createLink(int x, int y, int z, LinkType linkType, int orientation) {
        return this.createLink(new Point4D(x, y, z, this.id), linkType, orientation, null);
    }

    public DimLink createLink(Point4D source, LinkType linkType, int orientation, DDLock locked) {
        InnerDimLink link = this.linkMapping.get(source);
        if (link == null) {
            link = new InnerDimLink(source, linkType, orientation, locked);
            this.linkMapping.put(source, link);
            this.linkList.add(link);
            if (linkType != LinkType.CLIENT) {
                ChunkCoordIntPair chunk = link.getChunkCoordinates();
                List<InnerDimLink> chunkLinks = this.chunkMapping.get(chunk);
                if (chunkLinks == null) {
                    chunkLinks = new ArrayList<InnerDimLink>(EXPECTED_LINKS_PER_CHUNK);
                    this.chunkMapping.put(chunk, chunkLinks);
                }
                chunkLinks.add(link);
            }
        } else {
            link.overwrite(linkType, orientation);
        }
        this.modified = true;
        if (linkType != LinkType.CLIENT) {
            this.linkWatcher.onCreated(new ClientLinkData(link));
        }
        return link;
    }

    public DimLink createChildLink(int x, int y, int z, DimLink parent) {
        return this.createChildLink(new Point4D(x, y, z, this.id), (InnerDimLink)parent, null);
    }

    public DimLink createChildLink(Point4D source, DimLink parent, DDLock locked) {
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null.");
        }
        InnerDimLink link = this.linkMapping.get(source);
        if (link == null) {
            link = new InnerDimLink(source, parent, parent.orientation, locked);
            this.linkMapping.put(source, link);
            this.linkList.add(link);
            if (link.linkType() != LinkType.CLIENT) {
                ChunkCoordIntPair chunk = link.getChunkCoordinates();
                List<InnerDimLink> chunkLinks = this.chunkMapping.get(chunk);
                if (chunkLinks == null) {
                    chunkLinks = new ArrayList<InnerDimLink>(EXPECTED_LINKS_PER_CHUNK);
                    this.chunkMapping.put(chunk, chunkLinks);
                }
                chunkLinks.add(link);
            }
            this.linkWatcher.onCreated(new ClientLinkData(link));
        } else if (link.overwrite((InnerDimLink)parent, parent.orientation)) {
            this.linkWatcher.onCreated(new ClientLinkData(link));
        }
        this.modified = true;
        return link;
    }

    public boolean deleteLink(DimLink link) {
        if (link.source().getDimension() != this.id) {
            throw new IllegalArgumentException("Attempted to delete a link from another dimension.");
        }
        InnerDimLink target = this.linkMapping.remove(link.source());
        if (target != null) {
            ChunkCoordIntPair chunk;
            List<InnerDimLink> chunkLinks;
            this.linkList.remove(target);
            if (link.linkType() != LinkType.CLIENT && (chunkLinks = this.chunkMapping.get(chunk = target.getChunkCoordinates())) != null) {
                chunkLinks.remove(target);
            }
            if (this.linkWatcher != null) {
                this.linkWatcher.onDeleted(new ClientLinkData(link));
            }
            target.clear();
            this.modified = true;
        }
        return target != null;
    }

    public boolean deleteLink(int x, int y, int z) {
        return this.deleteLink(this.getLink(x, y, z));
    }

    public boolean deleteLink(Point4D location) {
        return this.deleteLink(this.getLink(location));
    }

    public DimLink getLink(int x, int y, int z) {
        Point4D location = new Point4D(x, y, z, this.id);
        return this.linkMapping.get(location);
    }

    public DimLink getLink(Point3D location) {
        return this.linkMapping.get(new Point4D(location.getX(), location.getY(), location.getZ(), this.id));
    }

    public DimLink getLink(Point4D location) {
        if (location.getDimension() != this.id) {
            return null;
        }
        return this.linkMapping.get(location);
    }

    public ArrayList<DimLink> getAllLinks() {
        ArrayList<DimLink> results = new ArrayList<DimLink>(this.linkMapping.size());
        results.addAll(this.linkMapping.values());
        return results;
    }

    public boolean isPocketDimension() {
        return this.root != this;
    }

    public DimensionType type() {
        return this.type;
    }

    public boolean isFilled() {
        return this.isFilled;
    }

    public void setFilled(boolean isFilled) {
        this.isFilled = isFilled;
        this.modified = true;
    }

    public int id() {
        return this.id;
    }

    public int depth() {
        return this.depth;
    }

    public int packDepth() {
        return this.packDepth;
    }

    public Point4D origin() {
        return this.origin;
    }

    public NewDimData parent() {
        return this.parent;
    }

    public NewDimData root() {
        return this.root;
    }

    public int orientation() {
        return this.orientation;
    }

    public DungeonData dungeon() {
        return this.dungeon;
    }

    public boolean isInitialized() {
        return this.origin != null;
    }

    public int linkCount() {
        return this.linkList.size();
    }

    public Iterable<NewDimData> children() {
        return this.children;
    }

    public Iterable<? extends DimLink> links() {
        return this.linkList;
    }

    public void initializeDungeon(int originX, int originY, int originZ, int orientation, DimLink incoming, DungeonData dungeon) {
        if (this.type != DimensionType.DUNGEON) {
            throw new IllegalStateException("Cannot invoke initializeDungeon() on a non-dungeon dimension.");
        }
        if (this.isInitialized()) {
            throw new IllegalStateException("The dimension has already been initialized.");
        }
        if (orientation < 0 || orientation > 3) {
            throw new IllegalArgumentException("orientation must be between 0 and 3, inclusive.");
        }
        this.setLinkDestination(incoming, originX, originY, originZ);
        this.origin = incoming.destination();
        this.orientation = orientation;
        this.dungeon = dungeon;
        this.packDepth = NewDimData.calculatePackDepth(this.parent, dungeon);
        this.modified = true;
    }

    public void setParentToRoot() {
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
        this.depth = 1;
        this.parent = this.root;
        this.root.children.add(this);
        this.root.modified = true;
        this.modified = true;
        if (this.type == DimensionType.DUNGEON) {
            this.packDepth = NewDimData.calculatePackDepth(this.parent, this.dungeon);
        }
        Stack<NewDimData> ordering = new Stack<NewDimData>();
        ordering.addAll(this.children);
        while (!ordering.isEmpty()) {
            NewDimData current = (NewDimData)ordering.pop();
            current.resetDepth();
            ordering.addAll(current.children);
        }
    }

    private void resetDepth() {
        this.depth = this.parent.depth + 1;
        if (this.type == DimensionType.DUNGEON) {
            this.packDepth = NewDimData.calculatePackDepth(this.parent, this.dungeon);
        }
        this.modified = true;
    }

    public static int calculatePackDepth(NewDimData parent, DungeonData current) {
        DungeonData predecessor = parent.dungeon();
        if (current == null) {
            throw new IllegalArgumentException("current cannot be null.");
        }
        if (predecessor == null) {
            return 1;
        }
        DungeonPack predOwner = predecessor.dungeonType().Owner;
        DungeonPack currentOwner = current.dungeonType().Owner;
        if (currentOwner == null) {
            return 1;
        }
        if (predOwner == null) {
            return 1;
        }
        if (predOwner == currentOwner) {
            return parent.packDepth + 1;
        }
        return 1;
    }

    public void initializePocket(int originX, int originY, int originZ, int orientation, DimLink incoming) {
        if (!this.isPocketDimension()) {
            throw new IllegalStateException("Cannot invoke initializePocket() on a non-pocket dimension.");
        }
        if (this.isInitialized()) {
            throw new IllegalStateException("The dimension has already been initialized.");
        }
        this.setLinkDestination(incoming, originX, originY, originZ);
        this.origin = incoming.destination();
        this.orientation = orientation;
        this.modified = true;
    }

    public void setLinkDestination(DimLink incoming, int x, int y, int z) {
        InnerDimLink link = (InnerDimLink)incoming;
        link.setDestination(x, y, z, this);
        this.modified = true;
    }

    public void lock(DimLink link, boolean locked) {
        InnerDimLink innerLink = (InnerDimLink)link;
        innerLink.lock.setLockState(locked);
        this.modified = true;
    }

    public void setLock(DimLink link, DDLock lock) {
        InnerDimLink innerLink = (InnerDimLink)link;
        innerLink.setLock(lock);
        this.modified = true;
    }

    public void createLock(DimLink link, ItemStack item, int lockKey) {
        InnerDimLink innerLink = (InnerDimLink)link;
        innerLink.createLock(item, lockKey);
        this.modified = true;
    }

    public void removeLock(DimLink link, ItemStack item) {
        InnerDimLink innerLink = (InnerDimLink)link;
        innerLink.removeLock(item, innerLink);
        this.modified = true;
    }

    public DimLink getRandomLink() {
        if (this.linkMapping.isEmpty()) {
            throw new IllegalStateException("There are no links to select from in this dimension.");
        }
        if (this.linkList.size() > 1) {
            return this.linkList.get(random.nextInt(this.linkList.size()));
        }
        return this.linkList.get(0);
    }

    public Iterable<? extends DimLink> getChunkLinks(int chunkX, int chunkZ) {
        List<InnerDimLink> chunkLinks = this.chunkMapping.get(new ChunkCoordIntPair(chunkX, chunkZ));
        if (chunkLinks != null) {
            return chunkLinks;
        }
        return new ArrayList(0);
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void clearModified() {
        this.modified = false;
    }

    public void clear() {
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
        for (NewDimData child : this.children) {
            child.parent = null;
        }
        this.id = Integer.MIN_VALUE;
        this.linkMapping.clear();
        this.linkMapping = null;
        this.linkList.clear();
        this.linkList = null;
        this.children.clear();
        this.children = null;
        this.type = null;
        this.isFilled = false;
        this.depth = Integer.MIN_VALUE;
        this.packDepth = Integer.MIN_VALUE;
        this.origin = null;
        this.orientation = Integer.MIN_VALUE;
        this.dungeon = null;
        this.linkWatcher = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PackedDimData pack() {
        void var6_12;
        ArrayList<Integer> ChildIDs = new ArrayList<Integer>();
        ArrayList<PackedLinkData> Links = new ArrayList<PackedLinkData>();
        ArrayList<PackedLinkTail> Tails = new ArrayList<PackedLinkTail>();
        PackedDungeonData packedDungeon = null;
        if (this.dungeon != null) {
            packedDungeon = new PackedDungeonData(this.dungeon.weight(), this.dungeon.isOpen(), this.dungeon.isInternal(), this.dungeon.schematicPath(), this.dungeon.schematicName(), this.dungeon.dungeonType().Name, this.dungeon.dungeonType().Owner.getName());
        }
        for (NewDimData newDimData : this.children) {
            ChildIDs.add(newDimData.id);
        }
        for (DimLink dimLink : this.links()) {
            ArrayList<Point3D> children = new ArrayList<Point3D>();
            Point3D parentPoint = new Point3D(-1, -1, -1);
            if (dimLink.parent != null) {
                parentPoint = dimLink.parent.point.toPoint3D();
            }
            for (DimLink childLink : dimLink.children) {
                children.add(childLink.source().toPoint3D());
            }
            PackedLinkTail tail = new PackedLinkTail(dimLink.tail.getDestination(), dimLink.tail.getLinkType());
            Links.add(new PackedLinkData(dimLink.point, parentPoint, tail, dimLink.orientation, children, dimLink.lock));
            PackedLinkTail tempTail = new PackedLinkTail(dimLink.tail.getDestination(), dimLink.tail.getLinkType());
            if (!Tails.contains(tempTail)) continue;
            Tails.add(tempTail);
        }
        int parentID = this.id;
        Point3D point3D = new Point3D(0, 0, 0);
        if (this.parent != null) {
            parentID = this.parent.id;
        }
        if (this.origin != null) {
            Point3D point3D2 = this.origin.toPoint3D();
        }
        return new PackedDimData(this.id, this.depth, this.packDepth, parentID, this.root().id(), this.orientation, this.type, this.isFilled, packedDungeon, (Point3D)var6_12, ChildIDs, Links, Tails);
    }

    @Override
    public String name() {
        return String.valueOf(this.id);
    }

    public String toString() {
        return "DimID= " + this.id;
    }

    private static class InnerDimLink
    extends DimLink {
        public InnerDimLink(Point4D source, DimLink parent, int orientation, DDLock lock) {
            super(source, orientation, lock, parent);
        }

        public InnerDimLink(Point4D source, LinkType linkType, int orientation, DDLock lock) {
            super(source, orientation, lock, linkType);
        }

        public void setDestination(int x, int y, int z, NewDimData dimension) {
            this.tail.setDestination(new Point4D(x, y, z, dimension.id()));
        }

        public boolean overwrite(InnerDimLink nextParent, int orientation) {
            if (nextParent == null) {
                throw new IllegalArgumentException("nextParent cannot be null.");
            }
            if (this == nextParent) {
                return false;
            }
            if (nextParent.point.getDimension() != this.point.getDimension()) {
                throw new IllegalArgumentException("source and parent.source must have the same dimension.");
            }
            for (DimLink child : this.children) {
                ((InnerDimLink)child).parent = null;
            }
            this.children.clear();
            if (this.parent != null) {
                this.parent.children.remove(this);
            }
            this.parent = nextParent;
            this.tail = nextParent.tail;
            nextParent.children.add(this);
            this.orientation = orientation;
            return true;
        }

        public void overwrite(LinkType linkType, int orientation) {
            for (DimLink child : this.children) {
                ((InnerDimLink)child).parent = null;
            }
            this.children.clear();
            if (this.parent != null) {
                this.parent.children.remove(this);
            }
            this.parent = null;
            this.tail = new LinkTail(linkType, null);
            this.orientation = orientation;
        }

        public void setLock(DDLock lock) {
            this.lock = lock;
        }

        public boolean createLock(ItemStack itemStack, int lockKey) {
            if (this.hasLock() || DDLock.hasCreatedLock(itemStack)) {
                return false;
            }
            this.lock = DDLock.generateLockKeyPair(itemStack, lockKey);
            return true;
        }

        public void removeLock(ItemStack itemStack, InnerDimLink link) {
            if (link.doesKeyUnlock(itemStack)) {
                link.lock = null;
            }
        }
    }
}

