/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.core;

import StevenDimDoors.mod_pocketDim.core.DDLock;
import StevenDimDoors.mod_pocketDim.core.LinkTail;
import StevenDimDoors.mod_pocketDim.core.LinkType;
import StevenDimDoors.mod_pocketDim.core.PocketManager;
import StevenDimDoors.mod_pocketDim.util.Point4D;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.world.ChunkCoordIntPair;

public abstract class DimLink {
    protected Point4D point;
    protected int orientation;
    protected DDLock lock;
    protected DimLink parent;
    protected LinkTail tail;
    protected List<DimLink> children;

    protected DimLink(Point4D point, int orientation, DDLock lock, DimLink parent) {
        if (parent.point.getDimension() != point.getDimension()) {
            throw new IllegalArgumentException("source and parent.source must have the same dimension.");
        }
        this.lock = lock;
        this.parent = parent;
        this.point = point;
        this.tail = parent.tail;
        this.orientation = orientation;
        this.children = new LinkedList<DimLink>();
        parent.children.add(this);
    }

    protected DimLink(Point4D point, int orientation, DDLock lock, LinkType linkType) {
        this.lock = lock;
        this.parent = null;
        this.point = point;
        this.orientation = orientation;
        this.tail = new LinkTail(linkType, null);
        this.children = new LinkedList<DimLink>();
    }

    public Point4D source() {
        return this.point;
    }

    public void clear() {
        for (DimLink child : this.children) {
            child.parent = null;
        }
        this.children.clear();
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
        this.parent = null;
        this.point = null;
        this.tail = new LinkTail(LinkType.NORMAL, null);
    }

    public int orientation() {
        return this.orientation;
    }

    public Point4D destination() {
        return this.tail.getDestination();
    }

    public int getDestinationOrientation() {
        DimLink destinationLink = PocketManager.getLink(this.tail.getDestination());
        if (destinationLink != null) {
            return destinationLink.orientation();
        }
        return (this.orientation + 2) % 4;
    }

    public boolean hasDestination() {
        return this.tail.getDestination() != null;
    }

    public Iterable<DimLink> children() {
        return this.children;
    }

    public int childCount() {
        return this.children.size();
    }

    public DimLink parent() {
        return this.parent;
    }

    public LinkType linkType() {
        return this.tail.getLinkType();
    }

    public boolean tryToOpen(ItemStack item) {
        return this.lock.tryToOpen(item);
    }

    public boolean doesKeyUnlock(ItemStack item) {
        return this.lock.doesKeyUnlock(item);
    }

    public boolean hasLock() {
        return this.lock != null;
    }

    public boolean getLockState() {
        return this.hasLock() && this.lock.getLockState();
    }

    public DDLock getLock() {
        return this.lock;
    }

    public ChunkCoordIntPair getChunkCoordinates() {
        return new ChunkCoordIntPair(this.point.getX() >> 4, this.point.getZ() >> 4);
    }

    public String toString() {
        return this.point + " -> " + (this.hasDestination() ? this.destination() : "()");
    }
}

