/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.core;

import StevenDimDoors.mod_pocketDim.Point3D;
import StevenDimDoors.mod_pocketDim.blocks.BaseDimDoor;
import StevenDimDoors.mod_pocketDim.blocks.IDimDoor;
import StevenDimDoors.mod_pocketDim.config.DDProperties;
import StevenDimDoors.mod_pocketDim.core.DimLink;
import StevenDimDoors.mod_pocketDim.core.DimensionType;
import StevenDimDoors.mod_pocketDim.core.LinkType;
import StevenDimDoors.mod_pocketDim.core.NewDimData;
import StevenDimDoors.mod_pocketDim.core.PocketManager;
import StevenDimDoors.mod_pocketDim.helpers.yCoordHelper;
import StevenDimDoors.mod_pocketDim.mod_pocketDim;
import StevenDimDoors.mod_pocketDim.schematic.BlockRotator;
import StevenDimDoors.mod_pocketDim.tileentities.TileEntityDimDoor;
import StevenDimDoors.mod_pocketDim.util.Point4D;
import StevenDimDoors.mod_pocketDim.watcher.ClientDimData;
import StevenDimDoors.mod_pocketDim.world.LimboProvider;
import StevenDimDoors.mod_pocketDim.world.PocketBuilder;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemDoor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.network.play.server.S1FPacketSetExperience;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class DDTeleporter {
    private static final Random random = new Random();
    private static final int NETHER_DIMENSION_ID = -1;
    private static final int OVERWORLD_DIMENSION_ID = 0;
    private static final int END_DIMENSION_ID = 1;
    private static final int MAX_NETHER_EXIT_CHANCE = 100;
    private static final int NETHER_EXIT_CHANCE = 20;
    private static final int MAX_OVERWORLD_EXIT_CHANCE = 100;
    private static final int OVERWORLD_EXIT_CHANCE = 15;
    private static final int MAX_ROOT_SHIFT_CHANCE = 100;
    private static final int START_ROOT_SHIFT_CHANCE = 0;
    private static final int ROOT_SHIFT_CHANCE_PER_LEVEL = 5;
    private static final String SPIRIT_WORLD_NAME = "Spirit World";
    public static int cooldown = 0;

    private DDTeleporter() {
    }

    private static boolean checkDestination(WorldServer world, Point4D destination, int orientation) {
        Point3D point;
        int x = destination.getX();
        int y = destination.getY();
        int z = destination.getZ();
        switch (orientation) {
            case 0: {
                point = new Point3D(x - 1, y - 1, z);
                break;
            }
            case 1: {
                point = new Point3D(x, y - 1, z - 1);
                break;
            }
            case 2: {
                point = new Point3D(x + 1, y - 1, z);
                break;
            }
            case 3: {
                point = new Point3D(x, y - 1, z + 1);
                break;
            }
            default: {
                point = new Point3D(x, y - 1, z);
            }
        }
        Block blockBottom = world.func_147439_a(point.getX(), point.getY(), point.getZ());
        Block blockTop = world.func_147439_a(point.getX(), point.getY() + 1, point.getZ());
        if (blockBottom != null && !blockBottom.isReplaceable((IBlockAccess)world, point.getX(), point.getY(), point.getZ()) && world.func_147445_c(point.getX(), point.getY(), point.getZ(), false)) {
            return false;
        }
        return blockTop == null || blockTop.isReplaceable((IBlockAccess)world, point.getX(), point.getY() + 1, point.getZ());
    }

    private static void placeInPortal(Entity entity, WorldServer world, Point4D destination, DDProperties properties, boolean checkOrientation) {
        int orientation;
        int x = destination.getX();
        int y = destination.getY();
        int z = destination.getZ();
        if (checkOrientation) {
            orientation = DDTeleporter.getDestinationOrientation(destination, properties);
            entity.field_70177_z = orientation * 90 + 90;
        } else {
            orientation = -1;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (DDTeleporter.checkDestination(world, destination, orientation)) {
                switch (orientation) {
                    case 0: {
                        player.func_70634_a((double)x - 0.5, (double)(y - 1), (double)z + 0.5);
                        break;
                    }
                    case 1: {
                        player.func_70634_a((double)x + 0.5, (double)(y - 1), (double)z - 0.5);
                        break;
                    }
                    case 2: {
                        player.func_70634_a((double)x + 1.5, (double)(y - 1), (double)z + 0.5);
                        break;
                    }
                    case 3: {
                        player.func_70634_a((double)x + 0.5, (double)(y - 1), (double)z + 1.5);
                        break;
                    }
                    default: {
                        player.func_70634_a((double)x + 0.5, (double)(y - 1), (double)z + 0.5);
                        break;
                    }
                }
            } else {
                player.func_70634_a((double)x + 0.5, (double)(y - 1), (double)z + 0.5);
            }
        } else if (entity instanceof EntityMinecart) {
            entity.field_70159_w = 0.0;
            entity.field_70179_y = 0.0;
            entity.field_70181_x = 0.0;
            switch (orientation) {
                case 0: {
                    DDTeleporter.setEntityPosition(entity, (double)x - 0.5, y, (double)z + 0.5);
                    entity.field_70159_w = -0.39;
                    entity.field_70170_p.func_72866_a(entity, false);
                    break;
                }
                case 1: {
                    DDTeleporter.setEntityPosition(entity, (double)x + 0.5, y, (double)z - 0.5);
                    entity.field_70179_y = -0.39;
                    entity.field_70170_p.func_72866_a(entity, false);
                    break;
                }
                case 2: {
                    DDTeleporter.setEntityPosition(entity, (double)x + 1.5, y, (double)z + 0.5);
                    entity.field_70159_w = 0.39;
                    entity.field_70170_p.func_72866_a(entity, false);
                    break;
                }
                case 3: {
                    DDTeleporter.setEntityPosition(entity, (double)x + 0.5, y, (double)z + 1.5);
                    entity.field_70179_y = 0.39;
                    entity.field_70170_p.func_72866_a(entity, false);
                    break;
                }
                default: {
                    DDTeleporter.setEntityPosition(entity, (double)x + 0.5, y, (double)z + 0.5);
                    entity.field_70170_p.func_72866_a(entity, false);
                    break;
                }
            }
        } else {
            switch (orientation) {
                case 0: {
                    DDTeleporter.setEntityPosition(entity, (double)x - 0.5, y, (double)z + 0.5);
                    break;
                }
                case 1: {
                    DDTeleporter.setEntityPosition(entity, (double)x + 0.5, y, (double)z - 0.5);
                    break;
                }
                case 2: {
                    DDTeleporter.setEntityPosition(entity, (double)x + 1.5, y, (double)z + 0.5);
                    break;
                }
                case 3: {
                    DDTeleporter.setEntityPosition(entity, (double)x + 0.5, y, (double)z + 1.5);
                    break;
                }
                default: {
                    DDTeleporter.setEntityPosition(entity, (double)x + 0.5, y, (double)z + 0.5);
                }
            }
        }
    }

    private static void setEntityPosition(Entity entity, double x, double y, double z) {
        entity.field_70169_q = entity.field_70165_t = x;
        entity.field_70142_S = entity.field_70165_t;
        entity.field_70167_r = entity.field_70163_u = y + (double)entity.field_70129_M;
        entity.field_70137_T = entity.field_70163_u;
        entity.field_70166_s = entity.field_70161_v = z;
        entity.field_70136_U = entity.field_70161_v;
        entity.func_70107_b(x, y, z);
    }

    private static int getDestinationOrientation(Point4D door, DDProperties properties) {
        WorldServer world = DimensionManager.getWorld((int)door.getDimension());
        if (world == null) {
            throw new IllegalStateException("The destination world should be loaded!");
        }
        Block block = world.func_147439_a(door.getX(), door.getY() - 1, door.getZ());
        if (block == null || !(block instanceof IDimDoor)) {
            return PocketManager.createDimensionData((World)world).orientation();
        }
        return world.func_72805_g(door.getX(), door.getY() - 1, door.getZ()) & 3;
    }

    public static Entity teleportEntity(Entity entity, Point4D destination, boolean checkOrientation) {
        if (entity == null) {
            throw new IllegalArgumentException("entity cannot be null.");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination cannot be null.");
        }
        WorldServer oldWorld = (WorldServer)entity.field_70170_p;
        EntityPlayerMP player = entity instanceof EntityPlayerMP ? (EntityPlayerMP)entity : null;
        DDProperties properties = DDProperties.instance();
        if (entity.field_70153_n != null) {
            return DDTeleporter.teleportEntity(entity.field_70153_n, destination, checkOrientation);
        }
        Entity cart = entity.field_70154_o;
        if (cart != null) {
            entity.func_70078_a(null);
            cart = DDTeleporter.teleportEntity(cart, destination, checkOrientation);
        }
        boolean difDest = entity.field_71093_bK != destination.getDimension();
        WorldServer newWorld = difDest ? PocketManager.loadDimension(destination.getDimension()) : oldWorld;
        DDTeleporter.placeInPortal(entity, newWorld, destination, properties, checkOrientation);
        if (difDest) {
            if (player != null) {
                PocketManager.getDimwatcher().onCreated(new ClientDimData(PocketManager.createDimensionData((World)newWorld)));
                player.field_71093_bK = destination.getDimension();
                player.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(player.field_71093_bK, player.field_70170_p.field_73013_u, newWorld.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
                ((WorldServer)entity.field_70170_p).func_73040_p().func_72695_c(player);
                oldWorld.func_72973_f((Entity)player);
                player.field_70128_L = false;
                oldWorld.func_73040_p().func_72695_c(player);
                newWorld.func_73040_p().func_72683_a(player);
                player.field_71134_c.func_73080_a(newWorld);
                player.field_71133_b.func_71203_ab().func_72354_b(player, newWorld);
                player.field_71133_b.func_71203_ab().func_72385_f(player);
                for (Object potionEffect : player.func_70651_bq()) {
                    PotionEffect effect = (PotionEffect)potionEffect;
                    player.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(player.func_145782_y(), effect));
                }
                player.field_71135_a.func_147359_a((Packet)new S1FPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
            }
            int entX = entity.field_70176_ah;
            int entZ = entity.field_70164_aj;
            if (entity.field_70175_ag && oldWorld.func_72863_F().func_73149_a(entX, entZ)) {
                oldWorld.func_72964_e(entX, entZ).func_76622_b(entity);
                oldWorld.func_72964_e((int)entX, (int)entZ).field_76643_l = true;
            }
            oldWorld.func_72847_b(entity);
            if (player == null) {
                NBTTagCompound entityNBT = new NBTTagCompound();
                entity.field_70128_L = false;
                entity.func_98035_c(entityNBT);
                if (entityNBT.func_82582_d()) {
                    return entity;
                }
                entity.field_70128_L = true;
                entity = EntityList.func_75615_a((NBTTagCompound)entityNBT, (World)newWorld);
                if (entity == null) {
                    // empty if block
                }
            }
            newWorld.func_72838_d(entity);
            entity.func_70029_a((World)newWorld);
        }
        entity.field_70170_p.func_72866_a(entity, false);
        if (cart != null) {
            if (player != null) {
                entity.field_70170_p.func_72866_a(entity, true);
            }
            entity.func_70078_a(cart);
        }
        if (player != null) {
            newWorld.func_72863_F().func_73158_c(MathHelper.func_76128_c((double)entity.field_70165_t) >> 4, MathHelper.func_76128_c((double)entity.field_70161_v) >> 4);
            FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)entity, oldWorld.field_73011_w.field_76574_g, newWorld.field_73011_w.field_76574_g);
        }
        DDTeleporter.placeInPortal(entity, newWorld, destination, properties, checkOrientation);
        return entity;
    }

    public static void traverseDimDoor(World world, DimLink link, Entity entity, Block door) {
        if (world == null) {
            throw new IllegalArgumentException("world cannot be null.");
        }
        if (link == null) {
            throw new IllegalArgumentException("link cannot be null.");
        }
        if (entity == null) {
            throw new IllegalArgumentException("entity cannot be null.");
        }
        if (world.field_72995_K) {
            return;
        }
        if (cooldown != 0 && !(entity instanceof EntityPlayer)) {
            return;
        }
        cooldown = 2 + random.nextInt(2);
        if (!DDTeleporter.initializeDestination(link, DDProperties.instance(), entity, door)) {
            return;
        }
        if (link.linkType() == LinkType.RANDOM) {
            Point4D randomDestination = DDTeleporter.getRandomDestination();
            if (randomDestination != null) {
                entity = DDTeleporter.teleportEntity(entity, randomDestination, true);
                entity.field_70170_p.func_72908_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, "mob.endermen.portal", 1.0f, 1.0f);
            }
        } else {
            DDTeleporter.buildExitDoor(door, link, DDProperties.instance());
            entity = DDTeleporter.teleportEntity(entity, link.destination(), link.linkType() != LinkType.UNSAFE_EXIT);
            entity.field_70170_p.func_72908_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, "mob.endermen.portal", 1.0f, 1.0f);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean initializeDestination(DimLink link, DDProperties properties, Entity entity, Block door) {
        if (link.hasDestination() && link.linkType() != LinkType.PERSONAL) {
            if (!PocketManager.isBlackListed(link.destination().getDimension())) return true;
            NewDimData start = PocketManager.getDimensionData(link.source().getDimension());
            if (link.linkType() == LinkType.DUNGEON) {
                start.createLink(link.source(), LinkType.DUNGEON, link.orientation(), null);
            } else {
                if (!start.isPocketDimension()) return false;
                start.createLink(link.source(), LinkType.SAFE_EXIT, link.orientation(), null);
            }
        }
        switch (link.linkType()) {
            case DUNGEON: {
                return PocketBuilder.generateNewDungeonPocket(link, properties);
            }
            case POCKET: {
                return PocketBuilder.generateNewPocket(link, properties, door, DimensionType.POCKET);
            }
            case PERSONAL: {
                return DDTeleporter.setupPersonalLink(link, properties, entity, door);
            }
            case SAFE_EXIT: {
                return DDTeleporter.generateSafeExit(link, properties);
            }
            case DUNGEON_EXIT: {
                return DDTeleporter.generateDungeonExit(link, properties);
            }
            case UNSAFE_EXIT: {
                return DDTeleporter.generateUnsafeExit(link);
            }
            case LIMBO: {
                if (!(entity instanceof EntityPlayer)) {
                    return false;
                }
                Point4D dest = LimboProvider.getLimboSkySpawn((EntityPlayer)entity, DDProperties.instance());
                link.tail.setDestination(dest);
                return true;
            }
            case NORMAL: 
            case REVERSE: 
            case RANDOM: {
                return true;
            }
        }
        throw new IllegalArgumentException("link has an unrecognized link type.");
    }

    private static boolean setupPersonalLink(DimLink link, DDProperties properties, Entity entity, Block door) {
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)entity;
        NewDimData dim = PocketManager.getPersonalDimensionForPlayer(player.func_146103_bH().getId().toString());
        if (dim == null) {
            return PocketBuilder.generateNewPersonalPocket(link, properties, player, door);
        }
        DimLink personalHomeLink = dim.getLink(dim.origin());
        if (personalHomeLink != null) {
            link.tail.setDestination(personalHomeLink.source());
            PocketManager.getDimensionData(link.source().getDimension()).setLinkDestination(personalHomeLink, link.source().getX(), link.source().getY(), link.source().getZ());
        }
        return true;
    }

    private static Point4D getRandomDestination() {
        ArrayList<Point4D> matches = new ArrayList<Point4D>();
        for (NewDimData dimension : PocketManager.getRootDimensions()) {
            for (DimLink link : dimension.getAllLinks()) {
                if (link.linkType() == LinkType.RANDOM) continue;
                matches.add(link.source());
            }
        }
        if (!matches.isEmpty()) {
            return (Point4D)matches.get(random.nextInt(matches.size()));
        }
        return null;
    }

    private static boolean generateUnsafeExit(DimLink link) {
        NewDimData current = PocketManager.getDimensionData(link.point.getDimension());
        if (current.isPocketDimension()) {
            Point4D source = link.source();
            WorldServer world = PocketManager.loadDimension(current.root().id());
            if (world == null) {
                return false;
            }
            Point3D destination = yCoordHelper.findDropPoint((World)world, source.getX(), source.getY() + 1, source.getZ());
            if (destination != null) {
                current.root().setLinkDestination(link, destination.getX(), destination.getY(), destination.getZ());
                return true;
            }
        }
        return false;
    }

    private static void buildExitDoor(Block door, DimLink link, DDProperties prop) {
        WorldServer startWorld = PocketManager.loadDimension(link.source().getDimension());
        WorldServer destWorld = PocketManager.loadDimension(link.destination().getDimension());
        TileEntity doorTE = startWorld.func_147438_o(link.source().getX(), link.source().getY(), link.point.getZ());
        if (doorTE instanceof TileEntityDimDoor) {
            if (((TileEntityDimDoor)((Object)TileEntityDimDoor.class.cast((Object)doorTE))).hasGennedPair) {
                return;
            }
            ((TileEntityDimDoor)((Object)TileEntityDimDoor.class.cast((Object)doorTE))).hasGennedPair = true;
            Block blockToReplace = destWorld.func_147439_a(link.destination().getX(), link.destination().getY(), link.destination().getZ());
            if (!destWorld.func_147437_c(link.destination().getX(), link.destination().getY(), link.destination().getZ()) && !blockToReplace.isReplaceable((IBlockAccess)destWorld, link.destination().getX(), link.destination().getY(), link.destination().getZ())) {
                return;
            }
            ItemDoor.func_150924_a((World)destWorld, (int)link.destination().getX(), (int)(link.destination().getY() - 1), (int)link.destination().getZ(), (int)link.getDestinationOrientation(), (Block)door);
            TileEntity doorDestTE = ((BaseDimDoor)door).initDoorTE((World)destWorld, link.destination().getX(), link.destination().getY(), link.destination().getZ());
            if (doorDestTE instanceof TileEntityDimDoor) {
                ((TileEntityDimDoor)((Object)TileEntityDimDoor.class.cast((Object)doorDestTE))).hasGennedPair = true;
            }
        }
    }

    private static boolean generateSafeExit(DimLink link, DDProperties properties) {
        NewDimData current = PocketManager.getDimensionData(link.point.getDimension());
        return DDTeleporter.generateSafeExit(current.root(), link, properties);
    }

    private static boolean generateDungeonExit(DimLink link, DDProperties properties) {
        NewDimData current = PocketManager.getDimensionData(link.point.getDimension());
        ArrayList<NewDimData> roots = PocketManager.getRootDimensions();
        int shiftChance = 0 + 5 * (current.packDepth() - 1);
        if (random.nextInt(100) < shiftChance) {
            if (current.root().id() != 0 && random.nextInt(100) < 15) {
                return DDTeleporter.generateSafeExit(PocketManager.createDimensionDataDangerously(0), link, properties);
            }
            if (current.root().id() != -1 && random.nextInt(100) < 20) {
                return DDTeleporter.generateSafeExit(PocketManager.createDimensionDataDangerously(-1), link, properties);
            }
            for (int attempts = 0; attempts < 10; ++attempts) {
                NewDimData selection = roots.get(random.nextInt(roots.size()));
                if (selection == current.root() || !DDTeleporter.isValidForDungeonExit(selection, properties)) continue;
                return DDTeleporter.generateSafeExit(selection, link, properties);
            }
        }
        return DDTeleporter.generateSafeExit(current.root(), link, properties);
    }

    private static boolean isValidForDungeonExit(NewDimData destination, DDProperties properties) {
        if (destination.id() == 1 || destination.id() == properties.LimboDimensionID) {
            return false;
        }
        WorldServer world = PocketManager.loadDimension(destination.id());
        return world != null && !SPIRIT_WORLD_NAME.equals(world.field_73011_w.func_80007_l());
    }

    private static boolean generateSafeExit(NewDimData destinationDim, DimLink link, DDProperties properties) {
        Point4D source = link.source();
        WorldServer world = PocketManager.loadDimension(destinationDim.id());
        if (world == null) {
            return false;
        }
        int startY = source.getY() - 2;
        Point3D locationUp = yCoordHelper.findSafeCubeUp((World)world, source.getX(), startY, source.getZ());
        Point3D locationDown = yCoordHelper.findSafeCubeDown((World)world, source.getX(), startY, source.getZ());
        Point3D destination = locationUp == null ? locationDown : (locationDown == null ? locationUp : (locationUp.getY() - startY <= startY - locationDown.getY() ? locationUp : locationDown));
        if (destination != null) {
            int x = destination.getX();
            int y = destination.getY();
            int z = destination.getZ();
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    if (world.func_147445_c(x + dx, y, z + dz, false)) continue;
                    world.func_147465_d(x + dx, y, z + dz, mod_pocketDim.blockDimWall, 0, 2);
                }
            }
            for (int dy = 1; dy <= 2; ++dy) {
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        world.func_147465_d(x + dx, y + dy, z + dz, Blocks.field_150350_a, 0, 2);
                    }
                }
            }
            int orientation = DDTeleporter.getDestinationOrientation(source, properties);
            NewDimData sourceDim = PocketManager.getDimensionData(link.source().getDimension());
            DimLink reverse = destinationDim.createLink(x, y + 2, z, LinkType.REVERSE, orientation);
            sourceDim.setLinkDestination(reverse, source.getX(), source.getY(), source.getZ());
            orientation = BlockRotator.transformMetadata(orientation, 2, mod_pocketDim.warpDoor);
            ItemDoor.func_150924_a((World)world, (int)x, (int)(y + 1), (int)z, (int)orientation, (Block)mod_pocketDim.warpDoor);
            destinationDim.setLinkDestination(link, x, y + 2, z);
        }
        return destination != null;
    }
}

