/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.core;

import StevenDimDoors.mod_pocketDim.items.ItemDDKey;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class DDLock {
    private boolean lockState;
    private final int lockKey;

    public DDLock(boolean isLocked, int lockKey) {
        this.lockState = isLocked;
        this.lockKey = lockKey;
    }

    public int getLockKey() {
        return this.lockKey;
    }

    public boolean getLockState() {
        return this.lockState;
    }

    protected void setLockState(boolean flag) {
        this.lockState = flag;
    }

    public boolean doesKeyUnlock(ItemStack itemStack) {
        for (int key : DDLock.getKeys(itemStack)) {
            if (this.lockKey != key) continue;
            return true;
        }
        return false;
    }

    public boolean tryToOpen(ItemStack itemStack) {
        return !this.lockState || this.doesKeyUnlock(itemStack);
    }

    public static int[] getKeys(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            DDLock.initNBTTags(itemStack);
        }
        return itemStack.func_77978_p().func_74759_k("DDKeys");
    }

    public static void addKeys(ItemStack itemStack, int[] keysToAdd) {
        int[] oldKeys = DDLock.getKeys(itemStack);
        int[] newKeys = new int[keysToAdd.length + oldKeys.length];
        System.arraycopy(oldKeys, 0, newKeys, 0, oldKeys.length);
        System.arraycopy(keysToAdd, 0, newKeys, oldKeys.length, keysToAdd.length);
        DDLock.setKeys(itemStack, newKeys);
    }

    public static void setKeys(ItemStack itemStack, int[] keys) {
        if (!itemStack.func_77942_o()) {
            DDLock.initNBTTags(itemStack);
        }
        NBTTagCompound tag = itemStack.func_77978_p();
        tag.func_74783_a("DDKeys", keys);
        itemStack.func_77982_d(tag);
    }

    public static void initNBTTags(ItemStack itemStack) {
        itemStack.func_77982_d(new NBTTagCompound());
        NBTTagCompound tag = itemStack.func_77978_p();
        tag.func_74783_a("DDKeys", new int[0]);
        tag.func_74757_a("HasCreatedLock", false);
        itemStack.func_77982_d(tag);
    }

    public static boolean hasCreatedLock(ItemStack key) {
        if (DDLock.isItemKey(key)) {
            if (key.func_77942_o()) {
                return key.func_77978_p().func_74767_n("HasCreatedLock");
            }
            DDLock.initNBTTags(key);
        }
        return false;
    }

    public static boolean isItemKey(ItemStack key) {
        return key.func_77973_b() instanceof ItemDDKey;
    }

    protected static DDLock generateLockKeyPair(ItemStack itemStack, int lockKey2) {
        itemStack.func_77978_p().func_74757_a("HasCreatedLock", true);
        DDLock.setKeys(itemStack, new int[]{lockKey2});
        return new DDLock(true, lockKey2);
    }
}

