/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.config;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;

public class DimensionFilter {
    private RangeSet<Integer> blacklist;

    private DimensionFilter(RangeSet<Integer> blacklist) {
        this.blacklist = blacklist;
    }

    public boolean isAccepted(int dimensionID) {
        return !this.blacklist.contains((Comparable)Integer.valueOf(dimensionID));
    }

    public boolean isRejected(int dimensionID) {
        return this.blacklist.contains((Comparable)Integer.valueOf(dimensionID));
    }

    private static RangeSet<Integer> parseRangeSet(String list) {
        String[] intervals;
        TreeRangeSet ranges = TreeRangeSet.create();
        if ((list = list.replaceAll("\\s", "")).isEmpty()) {
            return ranges;
        }
        for (String interval : intervals = list.split(",")) {
            int index = interval.length() > 1 ? interval.indexOf("-", 1) : -1;
            try {
                int end;
                int start;
                if (index >= 0) {
                    String startPart = interval.substring(0, index);
                    String endPart = interval.substring(index + 1);
                    start = Integer.parseInt(startPart);
                    end = Integer.parseInt(endPart);
                } else {
                    end = start = Integer.parseInt(interval);
                }
                ranges.add(Range.closed((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end)));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\"" + interval + "\" is not a valid value or range for dimension IDs");
            }
        }
        return ranges;
    }

    public static DimensionFilter parseWhitelist(String list) {
        return new DimensionFilter((RangeSet<Integer>)DimensionFilter.parseRangeSet(list).complement());
    }

    public static DimensionFilter parseBlacklist(String list) {
        return new DimensionFilter(DimensionFilter.parseRangeSet(list));
    }
}

