/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.config;

import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class DDProperties {
    public final int LimboBiomeID;
    public final int PocketBiomeID;
    public final int LimboDimensionID;
    public final int LimboProviderID;
    public final int PocketProviderID;
    public final int PersonalPocketProviderID;
    public final int DoorRenderEntityID;
    public final int MonolithEntityID;
    public final boolean CraftingDimensionalDoorAllowed;
    public final boolean CraftingWarpDoorAllowed;
    public final boolean CraftingRiftSignatureAllowed;
    public final boolean CraftingRiftRemoverAllowed;
    public final boolean CraftingUnstableDoorAllowed;
    public final boolean CraftingRiftBladeAllowed;
    public final boolean CraftingTransTrapdoorAllowed;
    public final boolean CraftingStabilizedRiftSignatureAllowed;
    public final boolean CraftingStableFabricAllowed;
    public final boolean CraftingGoldenDimensionalDoorAllowed;
    public final boolean CraftingGoldenDoorAllowed;
    public final boolean CraftingDDKeysAllowed;
    public final boolean CraftingQuartzDoorAllowed;
    public final boolean CraftingPersonalDimDoorAllowed;
    public final boolean RiftBladeLootEnabled;
    public final boolean FabricOfRealityLootEnabled;
    public final boolean WorldThreadLootEnabled;
    public final boolean RiftSpreadEnabled;
    public final boolean RiftGriefingEnabled;
    public final boolean RiftsSpawnEndermenEnabled;
    public final boolean LimboEnabled;
    public final boolean HardcoreLimboEnabled;
    public final boolean LimboReturnsInventoryEnabled;
    public final boolean DoorRenderingEnabled;
    public final boolean TNFREAKINGT_Enabled;
    public final boolean MonolithTeleportationEnabled;
    public final boolean DangerousLimboMonolithsDisabled;
    public final int NonTntWeight;
    public final int ClusterGenerationChance;
    public final int GatewayGenerationChance;
    public final int FortressGatewayGenerationChance;
    public final int MonolithSpawningChance;
    public final int WorldThreadDropChance;
    public final int LimboEntryRange;
    public final int LimboReturnRange;
    public final int WorldThreadRequirementLevel;
    public final String CustomSchematicDirectory;
    private static DDProperties instance = null;
    private final String CUSTOM_SCHEMATIC_SUBDIRECTORY = "/DimDoors_Custom_schematics";
    private final String CATEGORY_CRAFTING = "crafting";
    private final String CATEGORY_ENTITY = "entity";
    private final String CATEGORY_DIMENSION = "dimension";
    private final String CATEGORY_PROVIDER = "provider";
    private final String CATEGORY_BIOME = "biome";
    private final String CATEGORY_LOOT = "loot";

    private DDProperties(File configFile) {
        this.CustomSchematicDirectory = configFile.getParent() + "/DimDoors_Custom_schematics";
        Configuration config = new Configuration(configFile);
        config.load();
        this.CraftingDimensionalDoorAllowed = config.get("crafting", "Allow Crafting Dimensional Door", true).getBoolean(true);
        this.CraftingWarpDoorAllowed = config.get("crafting", "Allow Crafting Warp Door", true).getBoolean(true);
        this.CraftingUnstableDoorAllowed = config.get("crafting", "Allow Crafting Unstable Door", true).getBoolean(true);
        this.CraftingTransTrapdoorAllowed = config.get("crafting", "Allow Crafting Transdimensional Trapdoor", true).getBoolean(true);
        this.CraftingRiftSignatureAllowed = config.get("crafting", "Allow Crafting Rift Signature", true).getBoolean(true);
        this.CraftingRiftRemoverAllowed = config.get("crafting", "Allow Crafting Rift Remover", true).getBoolean(true);
        this.CraftingStabilizedRiftSignatureAllowed = config.get("crafting", "Allow Crafting Stabilized Rift Signature", true).getBoolean(true);
        this.CraftingRiftBladeAllowed = config.get("crafting", "Allow Crafting Rift Blade", true).getBoolean(true);
        this.CraftingStableFabricAllowed = config.get("crafting", "Allow Crafting Stable Fabric", true).getBoolean(true);
        this.CraftingGoldenDoorAllowed = config.get("crafting", "Allow Crafting Golden Door", true).getBoolean(true);
        this.CraftingGoldenDimensionalDoorAllowed = config.get("crafting", "Allow Crafting Golden Dimensional Door", true).getBoolean(true);
        this.CraftingDDKeysAllowed = config.get("crafting", "Allow Crafting Rift Keys", true).getBoolean(true);
        this.CraftingQuartzDoorAllowed = config.get("crafting", "Allow Crafting Quartz Doors", true).getBoolean(true);
        this.CraftingPersonalDimDoorAllowed = config.get("crafting", "Allow Crafting Personal Dim Doors", true).getBoolean(true);
        this.WorldThreadRequirementLevel = config.get("crafting", "World Thread Requirement Level", 4, "Controls the amount of World Thread needed to craft Stable Fabric. The number must be an integer from 1 to 4. The levels change the recipe to use 1, 2, 4, or 8 threads, respectively. The default level is 4.").getInt();
        this.RiftBladeLootEnabled = config.get("loot", "Enable Rift Blade Loot", true).getBoolean(true);
        this.FabricOfRealityLootEnabled = config.get("loot", "Enable Fabric of Reality Loot", true).getBoolean(true);
        this.WorldThreadLootEnabled = config.get("loot", "Enable World Thread Loot", true).getBoolean(true);
        this.RiftGriefingEnabled = config.get("general", "Enable Rift Griefing", true, "Sets whether rifts destroy blocks around them or not").getBoolean(true);
        this.RiftSpreadEnabled = config.get("general", "Enable Rift Spread", true, "Sets whether rifts create more rifts when they are near other rifts").getBoolean(true);
        this.RiftsSpawnEndermenEnabled = config.get("general", "Enable Endermen Spawning from Rifts", true, "Sets whether groups of connected rifts will spawn Endermen").getBoolean(true);
        this.LimboEnabled = config.get("general", "Enable Limbo", true, "Sets whether players are teleported to Limbo when they die in any pocket dimension").getBoolean(true);
        this.LimboReturnsInventoryEnabled = config.get("general", "Enable Limbo Returns Inventory", true, "Sets whether players keep their inventories upon dying and respawning in Limbo").getBoolean(true);
        this.HardcoreLimboEnabled = config.get("general", "Enable Hardcore Limbo", false, "Sets whether players that die in Limbo will respawn there").getBoolean(false);
        this.LimboEntryRange = config.get("general", "Limbo Entry Range", 500, "Sets the farthest distance that players may be moved at random when sent to Limbo. Must be greater than or equal to 0.").getInt();
        this.LimboReturnRange = config.get("general", "Limbo Return Range", 500, "Sets the farthest distance that players may be moved at random when sent from Limbo to the Overworld. Must be greater than or equal to 0.").getInt();
        this.DoorRenderingEnabled = config.get("general", "Enable Door Rendering", true).getBoolean(true);
        this.TNFREAKINGT_Enabled = config.get("general", "EXPLOSIONS!!???!!!?!?!!", false).getBoolean(false);
        this.NonTntWeight = config.get("general", "HOWMUCHTNT", 25, "Weighs the chance that a block will not be TNT. Must be greater than or equal to 0. EXPLOSIONS must be set to true for this to have any effect.").getInt();
        this.DoorRenderEntityID = config.get("entity", "Door Render Entity ID", 89).getInt();
        this.MonolithEntityID = config.get("entity", "Monolith Entity ID", 125).getInt();
        this.LimboDimensionID = config.get("dimension", "Limbo Dimension ID", -23).getInt();
        this.PocketProviderID = config.get("provider", "Pocket Provider ID", 124).getInt();
        this.LimboProviderID = config.get("provider", "Limbo Provider ID", 113).getInt();
        this.PersonalPocketProviderID = config.get("provider", "Personal Pocket Provider ID", 125).getInt();
        this.MonolithTeleportationEnabled = config.get("general", "Enable Monolith Teleportation", true, "Sets whether Monoliths can teleport players").getBoolean(true);
        this.DangerousLimboMonolithsDisabled = config.get("general", "Docile Monoliths in Limbo", true, "Sets whether monoliths in Limbo stare at the player rather than attack").getBoolean(true);
        this.MonolithSpawningChance = config.get("general", "Monolith Spawning Chance", 28, "Sets the chance (out of 100) that Monoliths will spawn in a given Limbo chunk. The default chance is 28.").getInt();
        this.ClusterGenerationChance = config.get("general", "Cluster Generation Chance", 2, "Sets the chance (out of 10000) that a cluster of rifts will generate in a given chunk. The default chance is 2.").getInt();
        this.GatewayGenerationChance = config.get("general", "Gateway Generation Chance", 15, "Sets the chance (out of 10000) that a Rift Gateway will generate in a given chunk. The default chance is 15.").getInt();
        this.FortressGatewayGenerationChance = config.get("general", "Fortress Gateway Generation Chance", 33, "Sets the chance (out of 100) that a Rift Gateway will generate as part of a Nether Fortress. The default chance is 33.").getInt();
        this.WorldThreadDropChance = config.get("general", "World Thread Drop Chance", 50, "Sets the chance (out of 1000) that a rift will drop World Thread when it destroys a block. The default chance is 50.").getInt();
        this.LimboBiomeID = config.get("biome", "Limbo Biome ID", 148).getInt();
        this.PocketBiomeID = config.get("biome", "Pocket Biome ID", 147).getInt();
        config.save();
    }

    public static DDProperties initialize(File configFile) {
        if (instance != null) {
            throw new IllegalStateException("Cannot initialize DDProperties twice");
        }
        instance = new DDProperties(configFile);
        return instance;
    }

    public static DDProperties instance() {
        if (instance == null) {
            throw new IllegalStateException("Instance of DDProperties requested before initialization");
        }
        return instance;
    }
}

