/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.commands;

import StevenDimDoors.mod_pocketDim.commands.DDCommandBase;
import StevenDimDoors.mod_pocketDim.commands.DDCommandResult;
import StevenDimDoors.mod_pocketDim.core.DDTeleporter;
import StevenDimDoors.mod_pocketDim.core.NewDimData;
import StevenDimDoors.mod_pocketDim.core.PocketManager;
import StevenDimDoors.mod_pocketDim.util.Point4D;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class CommandTeleportPlayer
extends DDCommandBase {
    private static CommandTeleportPlayer instance = null;

    private CommandTeleportPlayer() {
        super("dd-tp", new String[]{"<player name> <dimension number>", "<player name> <x> <y> <z>", "<player name> <dimension number> <x> <y> <z>"});
    }

    public static CommandTeleportPlayer instance() {
        if (instance == null) {
            instance = new CommandTeleportPlayer();
        }
        return instance;
    }

    @Override
    protected DDCommandResult processCommand(EntityPlayer sender, String[] command) {
        Point4D destination;
        WorldServer world;
        int dimensionID;
        if (command.length < 2) {
            return DDCommandResult.TOO_FEW_ARGUMENTS;
        }
        if (command.length > 5) {
            return DDCommandResult.TOO_MANY_ARGUMENTS;
        }
        if (command.length == 3) {
            return DDCommandResult.INVALID_ARGUMENTS;
        }
        for (int k = 1; k < command.length; ++k) {
            if (CommandTeleportPlayer.isInteger(command[k])) continue;
            return DDCommandResult.INVALID_ARGUMENTS;
        }
        EntityPlayerMP targetPlayer = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(command[0]);
        if (targetPlayer == null) {
            return DDCommandResult.PLAYER_OFFLINE;
        }
        if (command.length != 4) {
            dimensionID = Integer.parseInt(command[1]);
            world = PocketManager.loadDimension(dimensionID);
            if (world == null) {
                return DDCommandResult.UNREGISTERED_DIMENSION;
            }
        } else {
            dimensionID = targetPlayer.field_70170_p.field_73011_w.field_76574_g;
            world = targetPlayer.field_70170_p;
        }
        boolean checkOrientation = false;
        if (command.length == 2) {
            NewDimData dimension = PocketManager.createDimensionData((World)world);
            if (dimension.isPocketDimension()) {
                destination = dimension.origin();
                checkOrientation = true;
            } else {
                int y = world.func_72825_h(0, 0) + 2;
                destination = new Point4D(0, y, 0, dimensionID);
            }
        } else if (command.length == 4) {
            int x = Integer.parseInt(command[1]);
            int y = Integer.parseInt(command[2]) + 1;
            int z = Integer.parseInt(command[3]);
            destination = new Point4D(x, y, z, dimensionID);
        } else {
            int x = Integer.parseInt(command[2]);
            int y = Integer.parseInt(command[3]) + 1;
            int z = Integer.parseInt(command[4]);
            destination = new Point4D(x, y, z, dimensionID);
        }
        DDTeleporter.teleportEntity((Entity)targetPlayer, destination, checkOrientation);
        return DDCommandResult.SUCCESS;
    }

    private static boolean isInteger(String input) {
        try {
            Integer.parseInt(input);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

