/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.commands;

import StevenDimDoors.mod_pocketDim.commands.DDCommandBase;
import StevenDimDoors.mod_pocketDim.commands.DDCommandResult;
import StevenDimDoors.mod_pocketDim.core.DimLink;
import StevenDimDoors.mod_pocketDim.core.DimensionType;
import StevenDimDoors.mod_pocketDim.core.LinkType;
import StevenDimDoors.mod_pocketDim.core.NewDimData;
import StevenDimDoors.mod_pocketDim.core.PocketManager;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;

public class CommandResetDungeons
extends DDCommandBase {
    private static CommandResetDungeons instance = null;

    private CommandResetDungeons() {
        super("dd-resetdungeons", "");
    }

    public static CommandResetDungeons instance() {
        if (instance == null) {
            instance = new CommandResetDungeons();
        }
        return instance;
    }

    @Override
    protected DDCommandResult processCommand(EntityPlayer sender, String[] command) {
        if (command.length > 0) {
            return DDCommandResult.TOO_MANY_ARGUMENTS;
        }
        int resetCount = 0;
        int dungeonCount = 0;
        HashSet<Integer> deletedDimensions = new HashSet<Integer>();
        ArrayList<NewDimData> loadedDungeons = new ArrayList<NewDimData>();
        ArrayList<NewDimData> dimensions = new ArrayList<NewDimData>();
        for (NewDimData newDimData : PocketManager.getDimensions()) {
            dimensions.add(newDimData);
        }
        for (NewDimData newDimData : dimensions) {
            if (newDimData.type() != DimensionType.DUNGEON) continue;
            ++dungeonCount;
            int id = newDimData.id();
            if (PocketManager.deletePocket(newDimData, true)) {
                ++resetCount;
                deletedDimensions.add(id);
                continue;
            }
            loadedDungeons.add(newDimData);
        }
        for (NewDimData newDimData : loadedDungeons) {
            if (newDimData.parent() == null) {
                newDimData.setParentToRoot();
            }
            for (DimLink dimLink : newDimData.links()) {
                if (!dimLink.hasDestination() || !deletedDimensions.contains(dimLink.destination().getDimension())) continue;
                if (dimLink.linkType() == LinkType.DUNGEON) {
                    newDimData.createLink(dimLink.source(), LinkType.DUNGEON, dimLink.orientation(), null);
                    continue;
                }
                if (dimLink.linkType() != LinkType.REVERSE) continue;
                newDimData.createLink(dimLink.source(), LinkType.DUNGEON_EXIT, dimLink.orientation(), null);
            }
        }
        CommandResetDungeons.sendChat(sender, "Reset complete. " + resetCount + " out of " + dungeonCount + " dungeons were reset.");
        return DDCommandResult.SUCCESS;
    }
}

