/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.commands;

import StevenDimDoors.mod_pocketDim.commands.DDCommandBase;
import StevenDimDoors.mod_pocketDim.commands.DDCommandResult;
import StevenDimDoors.mod_pocketDim.helpers.DungeonHelper;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;

public class CommandListDungeons
extends DDCommandBase {
    private static CommandListDungeons instance = null;

    private CommandListDungeons() {
        super("dd-list", "<page>");
    }

    public static CommandListDungeons instance() {
        if (instance == null) {
            instance = new CommandListDungeons();
        }
        return instance;
    }

    @Override
    protected DDCommandResult processCommand(EntityPlayer sender, String[] command) {
        int index;
        int page;
        if (command.length > 1) {
            return DDCommandResult.TOO_MANY_ARGUMENTS;
        }
        if (command.length == 0) {
            page = 1;
        } else {
            try {
                page = Integer.parseInt(command[0]);
            }
            catch (NumberFormatException e) {
                return DDCommandResult.INVALID_ARGUMENTS;
            }
        }
        ArrayList<String> dungeonNames = DungeonHelper.instance().getDungeonNames();
        int pageCount = (dungeonNames.size() - 1) / 10 + 1;
        if (page < 1 || page > pageCount) {
            return DDCommandResult.INVALID_ARGUMENTS;
        }
        CommandListDungeons.sendChat(sender, "List of dungeons (page " + page + " of " + pageCount + "):");
        int limit = Math.min(index + 10, dungeonNames.size());
        for (index = (page - 1) * 10; index < limit; ++index) {
            CommandListDungeons.sendChat(sender, dungeonNames.get(index));
        }
        CommandListDungeons.sendChat(sender, "");
        return DDCommandResult.SUCCESS;
    }
}

