/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.commands;

import StevenDimDoors.mod_pocketDim.commands.DDCommandBase;
import StevenDimDoors.mod_pocketDim.commands.DDCommandResult;
import StevenDimDoors.mod_pocketDim.config.DDProperties;
import StevenDimDoors.mod_pocketDim.helpers.DungeonHelper;
import java.io.File;
import net.minecraft.entity.player.EntityPlayer;

public class CommandExportDungeon
extends DDCommandBase {
    private static CommandExportDungeon instance = null;

    private CommandExportDungeon() {
        super("dd-export", new String[]{"<dungeon type> <dungeon name> <'open' | 'closed'> [weight]", "<schematic name> override"});
    }

    public static CommandExportDungeon instance() {
        if (instance == null) {
            instance = new CommandExportDungeon();
        }
        return instance;
    }

    @Override
    protected DDCommandResult processCommand(EntityPlayer sender, String[] command) {
        DungeonHelper dungeonHelper = DungeonHelper.instance();
        if (command.length < 2) {
            return DDCommandResult.TOO_FEW_ARGUMENTS;
        }
        if (command.length > 4) {
            return DDCommandResult.TOO_MANY_ARGUMENTS;
        }
        if (command.length == 2) {
            if (command[1].equalsIgnoreCase("override")) {
                if (DungeonHelper.SCHEMATIC_NAME_PATTERN.matcher(command[0]).matches()) {
                    return CommandExportDungeon.exportDungeon(sender, command[0]);
                }
                return new DDCommandResult("Error: Invalid schematic name. Please use only letters, numbers, dashes, and underscores.");
            }
            return DDCommandResult.TOO_FEW_ARGUMENTS;
        }
        if (!dungeonHelper.validateDungeonType(command[0], dungeonHelper.getDungeonPack("ruins"))) {
            return new DDCommandResult("Error: Invalid dungeon type. Please use one of the existing types.");
        }
        if (!DungeonHelper.DUNGEON_NAME_PATTERN.matcher(command[1]).matches()) {
            return new DDCommandResult("Error: Invalid dungeon name. Please use only letters, numbers, and dashes.");
        }
        if (!command[2].equalsIgnoreCase("open") && !command[2].equalsIgnoreCase("closed")) {
            return new DDCommandResult("Error: Please specify whether the dungeon is 'open' or 'closed'.");
        }
        if (command.length == 3) {
            return CommandExportDungeon.exportDungeon(sender, CommandExportDungeon.join(command, "_", 0, 3));
        }
        try {
            int weight = Integer.parseInt(command[3]);
            if (weight >= 1 && weight <= 10000) {
                return CommandExportDungeon.exportDungeon(sender, CommandExportDungeon.join(command, "_", 0, 4));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return new DDCommandResult("Invalid dungeon weight. Please specify a weight between 1 and 10000, inclusive.");
    }

    private static DDCommandResult exportDungeon(EntityPlayer player, String name) {
        String exportPath;
        int z;
        int y;
        int x;
        DDProperties properties = DDProperties.instance();
        DungeonHelper dungeonHelper = DungeonHelper.instance();
        if (dungeonHelper.exportDungeon(player.field_70170_p, x = (int)player.field_70165_t, y = (int)player.field_70163_u, z = (int)player.field_70161_v, exportPath = properties.CustomSchematicDirectory + File.separator + name + ".schematic")) {
            CommandExportDungeon.sendChat(player, "Saved dungeon schematic in " + exportPath);
            dungeonHelper.registerDungeon(exportPath, dungeonHelper.getDungeonPack("ruins"), false, true);
            return DDCommandResult.SUCCESS;
        }
        return new DDCommandResult("Error: Failed to save dungeon schematic!");
    }

    private static String join(String[] source, String delimiter, int start, int end) {
        int index;
        int length = 0;
        for (index = start; index < end; ++index) {
            length += source[index].length();
        }
        StringBuilder buffer = new StringBuilder(length += (end - start - 1) * delimiter.length());
        buffer.append(source[start]);
        for (index = start + 1; index < end; ++index) {
            buffer.append(delimiter);
            buffer.append(source[index]);
        }
        return buffer.toString();
    }
}

