/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.commands;

import StevenDimDoors.mod_pocketDim.commands.DDCommandBase;
import StevenDimDoors.mod_pocketDim.commands.DDCommandResult;
import StevenDimDoors.mod_pocketDim.core.DimLink;
import StevenDimDoors.mod_pocketDim.core.NewDimData;
import StevenDimDoors.mod_pocketDim.core.PocketManager;
import StevenDimDoors.mod_pocketDim.mod_pocketDim;
import StevenDimDoors.mod_pocketDim.util.Point4D;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class CommandDeleteRifts
extends DDCommandBase {
    private static CommandDeleteRifts instance = null;

    private CommandDeleteRifts() {
        super("dd-deleterifts", "[dimension number]");
    }

    public static CommandDeleteRifts instance() {
        if (instance == null) {
            instance = new CommandDeleteRifts();
        }
        return instance;
    }

    @Override
    protected DDCommandResult processCommand(EntityPlayer sender, String[] command) {
        int targetDimension;
        int linksRemoved = 0;
        if (command.length > 1) {
            return DDCommandResult.TOO_MANY_ARGUMENTS;
        }
        if (command.length == 0) {
            targetDimension = sender.field_70170_p.field_73011_w.field_76574_g;
        } else {
            try {
                targetDimension = Integer.parseInt(command[0]);
            }
            catch (NumberFormatException e) {
                return DDCommandResult.INVALID_DIMENSION_ID;
            }
        }
        WorldServer world = PocketManager.loadDimension(targetDimension);
        if (world == null) {
            return DDCommandResult.UNREGISTERED_DIMENSION;
        }
        NewDimData dimension = PocketManager.createDimensionData((World)world);
        ArrayList<DimLink> links = dimension.getAllLinks();
        for (DimLink link : links) {
            int z;
            int y;
            Point4D location = link.source();
            int x = location.getX();
            if (world.func_147439_a(x, y = location.getY(), z = location.getZ()) == mod_pocketDim.blockRift) {
                world.func_147468_f(x, y, z);
                dimension.deleteLink(link);
                ++linksRemoved;
                continue;
            }
            if (mod_pocketDim.blockRift.isBlockImmune((World)world, x, y, z)) continue;
            dimension.deleteLink(link);
            ++linksRemoved;
        }
        CommandDeleteRifts.sendChat(sender, "Removed " + linksRemoved + " links.");
        return DDCommandResult.SUCCESS;
    }
}

