/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.commands;

import StevenDimDoors.mod_pocketDim.commands.DDCommandBase;
import StevenDimDoors.mod_pocketDim.commands.DDCommandResult;
import StevenDimDoors.mod_pocketDim.core.DimLink;
import StevenDimDoors.mod_pocketDim.core.LinkType;
import StevenDimDoors.mod_pocketDim.core.NewDimData;
import StevenDimDoors.mod_pocketDim.core.PocketManager;
import StevenDimDoors.mod_pocketDim.dungeon.DungeonData;
import StevenDimDoors.mod_pocketDim.helpers.DungeonHelper;
import StevenDimDoors.mod_pocketDim.mod_pocketDim;
import StevenDimDoors.mod_pocketDim.world.PocketBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;

public class CommandCreateRandomRift
extends DDCommandBase {
    private static CommandCreateRandomRift instance = null;
    private static Random random = new Random();

    private CommandCreateRandomRift() {
        super("dd-random", "<dungeon name>");
    }

    public static CommandCreateRandomRift instance() {
        if (instance == null) {
            instance = new CommandCreateRandomRift();
        }
        return instance;
    }

    @Override
    protected DDCommandResult processCommand(EntityPlayer sender, String[] command) {
        DungeonHelper dungeonHelper = DungeonHelper.instance();
        if (command.length > 1) {
            return DDCommandResult.TOO_MANY_ARGUMENTS;
        }
        int x = MathHelper.func_76128_c((double)sender.field_70165_t);
        int y = MathHelper.func_76128_c((double)sender.field_70163_u);
        int z = MathHelper.func_76128_c((double)sender.field_70161_v);
        int orientation = MathHelper.func_76128_c((double)((double)((sender.field_70177_z + 180.0f) * 4.0f / 360.0f) - 0.5)) & 3;
        if (command.length == 0) {
            NewDimData dimension = PocketManager.getDimensionData(sender.field_70170_p);
            DimLink link = dimension.createLink(x, y + 1, z, LinkType.DUNGEON, orientation);
            sender.field_70170_p.func_147465_d(x, y + 1, z, (Block)mod_pocketDim.blockRift, 0, 3);
            CommandCreateRandomRift.sendChat(sender, "Created a rift to a random dungeon.");
        } else {
            DungeonData result = CommandCreateRandomRift.getRandomDungeonByPartialName(command[0], dungeonHelper.getRegisteredDungeons());
            if (result == null) {
                result = CommandCreateRandomRift.getRandomDungeonByPartialName(command[0], dungeonHelper.getUntaggedDungeons());
            }
            if (result != null) {
                NewDimData dimension = PocketManager.getDimensionData(sender.field_70170_p);
                DimLink link = dimension.createLink(x, y + 1, z, LinkType.DUNGEON, orientation);
                if (PocketBuilder.generateSelectedDungeonPocket(link, mod_pocketDim.properties, result)) {
                    sender.field_70170_p.func_147465_d(x, y + 1, z, (Block)mod_pocketDim.blockRift, 0, 3);
                    CommandCreateRandomRift.sendChat(sender, "Created a rift to \"" + result.schematicName() + "\" dungeon (Dimension ID = " + link.destination().getDimension() + ").");
                } else {
                    dimension.deleteLink(link);
                    CommandCreateRandomRift.sendChat(sender, "Dungeon generation failed unexpectedly!");
                }
            } else {
                return new DDCommandResult("Error: The specified dungeon was not found. Use 'list' to see a list of the available dungeons.");
            }
        }
        return DDCommandResult.SUCCESS;
    }

    private static DungeonData getRandomDungeonByPartialName(String query, Collection<DungeonData> dungeons) {
        String normalQuery = query.toLowerCase();
        ArrayList<DungeonData> matches = new ArrayList<DungeonData>();
        for (DungeonData dungeon : dungeons) {
            String dungeonName = dungeon.schematicName().toLowerCase();
            if (!dungeonName.contains(normalQuery)) continue;
            matches.add(dungeon);
        }
        if (matches.isEmpty()) {
            return null;
        }
        return (DungeonData)matches.get(random.nextInt(matches.size()));
    }
}

