/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.blocks;

import StevenDimDoors.mod_pocketDim.blocks.IDimDoor;
import StevenDimDoors.mod_pocketDim.core.DDTeleporter;
import StevenDimDoors.mod_pocketDim.core.DimLink;
import StevenDimDoors.mod_pocketDim.core.LinkType;
import StevenDimDoors.mod_pocketDim.core.NewDimData;
import StevenDimDoors.mod_pocketDim.core.PocketManager;
import StevenDimDoors.mod_pocketDim.items.ItemDDKey;
import StevenDimDoors.mod_pocketDim.mod_pocketDim;
import StevenDimDoors.mod_pocketDim.tileentities.TileEntityTransTrapdoor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class TransTrapdoor
extends BlockTrapDoor
implements IDimDoor,
ITileEntityProvider {
    public TransTrapdoor(Material material) {
        super(material);
        this.func_149647_a(mod_pocketDim.dimDoorsCreativeTab);
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("dimdoors:" + this.func_149739_a());
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        this.enterDimDoor(world, x, y, z, entity);
    }

    public boolean checkCanOpen(World world, int x, int y, int z) {
        return this.checkCanOpen(world, x, y, z, null);
    }

    public boolean checkCanOpen(World world, int x, int y, int z, EntityPlayer player) {
        DimLink link = PocketManager.getLink(x, y, z, world);
        if (link == null || player == null) {
            return link == null;
        }
        if (!link.getLockState()) {
            return true;
        }
        for (ItemStack item : player.field_71071_by.field_70462_a) {
            if (item == null || !(item.func_77973_b() instanceof ItemDDKey) || !link.tryToOpen(item)) continue;
            return true;
        }
        return false;
    }

    public boolean func_149727_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        if (this.checkCanOpen(par1World, par2, par3, par4, par5EntityPlayer)) {
            return super.func_149727_a(par1World, par2, par3, par4, par5EntityPlayer, par6, par7, par8, par9);
        }
        return false;
    }

    public void onPoweredBlockChange(World par1World, int par2, int par3, int par4, boolean par5) {
        if (this.checkCanOpen(par1World, par2, par3, par4)) {
            super.func_150120_a(par1World, par2, par3, par4, par5);
        }
    }

    @Override
    public void enterDimDoor(World world, int x, int y, int z, Entity entity) {
        if (!world.field_72995_K && TransTrapdoor.func_150118_d((int)world.func_72805_g(x, y, z))) {
            DimLink link = PocketManager.getLink(x, y, z, world);
            if (link != null && (link.linkType() != LinkType.PERSONAL || entity instanceof EntityPlayer)) {
                DDTeleporter.traverseDimDoor(world, link, entity, (Block)this);
            }
            super.func_150120_a(world, x, y, z, false);
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        this.placeLink(world, x, y, z);
        world.func_147455_a(x, y, z, this.func_149915_a(world, world.func_72805_g(x, y, z)));
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityTransTrapdoor();
    }

    @Override
    public void placeLink(World world, int x, int y, int z) {
        NewDimData dimension;
        DimLink link;
        if (!world.field_72995_K && (link = (dimension = PocketManager.createDimensionData(world)).getLink(x, y, z)) == null && dimension.isPocketDimension()) {
            dimension.createLink(x, y, z, LinkType.UNSAFE_EXIT, 0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        return new ItemStack(this.getDoorItem(), 1, 0);
    }

    public Item func_149650_a(int metadata, Random random, int fortuneLevel) {
        return Item.func_150898_a((Block)Blocks.field_150415_aT);
    }

    @Override
    public Item getDoorItem() {
        return Item.func_150898_a((Block)mod_pocketDim.transTrapdoor);
    }

    public static boolean isTrapdoorSetLow(int metadata) {
        return (metadata & 8) == 0;
    }

    @Override
    public TileEntity initDoorTE(World world, int x, int y, int z) {
        TileEntity te = this.func_149915_a(world, world.func_72805_g(x, y, z));
        world.func_147455_a(x, y, z, te);
        return te;
    }

    @Override
    public boolean isDoorOnRift(World world, int x, int y, int z) {
        return PocketManager.getLink(x, y, z, world) != null;
    }

    public void func_149749_a(World world, int x, int y, int z, Block oldBlock, int oldMeta) {
        super.func_149749_a(world, x, y, z, oldBlock, oldMeta);
        if (world.func_147439_a(x, y, z) != oldBlock) {
            mod_pocketDim.riftRegenerator.scheduleFastRegeneration(x, y, z, world);
        }
    }
}

