/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.blocks;

import StevenDimDoors.mod_pocketDim.Point3D;
import StevenDimDoors.mod_pocketDim.config.DDProperties;
import StevenDimDoors.mod_pocketDim.core.DimLink;
import StevenDimDoors.mod_pocketDim.core.NewDimData;
import StevenDimDoors.mod_pocketDim.core.PocketManager;
import StevenDimDoors.mod_pocketDim.mod_pocketDim;
import StevenDimDoors.mod_pocketDim.tileentities.TileEntityRift;
import StevenDimDoors.mod_pocketDim.util.Point4D;
import StevenDimDoors.mod_pocketDimClient.ClosingRiftFX;
import StevenDimDoors.mod_pocketDimClient.GoggleRiftFX;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;

public class BlockRift
extends Block
implements ITileEntityProvider {
    private static final float MIN_IMMUNE_RESISTANCE = 5000.0f;
    private static final int BLOCK_DESTRUCTION_RANGE = 4;
    private static final int RIFT_SPREAD_RANGE = 5;
    private static final int MAX_BLOCK_SEARCH_CHANCE = 100;
    private static final int BLOCK_SEARCH_CHANCE = 50;
    private static final int MAX_BLOCK_DESTRUCTION_CHANCE = 100;
    private static final int BLOCK_DESTRUCTION_CHANCE = 50;
    public static final int MAX_WORLD_THREAD_DROP_CHANCE = 1000;
    private final DDProperties properties;
    private final ArrayList<Block> blocksImmuneToRift;
    private final ArrayList<Block> modBlocksImmuneToRift;

    public BlockRift(Material par2Material, DDProperties properties) {
        super(par2Material);
        this.func_149675_a(true);
        this.properties = properties;
        this.modBlocksImmuneToRift = new ArrayList();
        this.modBlocksImmuneToRift.add(mod_pocketDim.blockDimWall);
        this.modBlocksImmuneToRift.add(mod_pocketDim.blockDimWallPerm);
        this.modBlocksImmuneToRift.add((Block)mod_pocketDim.dimensionalDoor);
        this.modBlocksImmuneToRift.add(mod_pocketDim.warpDoor);
        this.modBlocksImmuneToRift.add((Block)mod_pocketDim.transTrapdoor);
        this.modBlocksImmuneToRift.add(mod_pocketDim.unstableDoor);
        this.modBlocksImmuneToRift.add(mod_pocketDim.blockRift);
        this.modBlocksImmuneToRift.add(mod_pocketDim.transientDoor);
        this.modBlocksImmuneToRift.add(mod_pocketDim.goldenDimensionalDoor);
        this.modBlocksImmuneToRift.add(mod_pocketDim.goldenDoor);
        this.blocksImmuneToRift = new ArrayList();
        this.blocksImmuneToRift.add(mod_pocketDim.blockDimWall);
        this.blocksImmuneToRift.add(mod_pocketDim.blockDimWallPerm);
        this.blocksImmuneToRift.add((Block)mod_pocketDim.dimensionalDoor);
        this.blocksImmuneToRift.add(mod_pocketDim.warpDoor);
        this.blocksImmuneToRift.add((Block)mod_pocketDim.transTrapdoor);
        this.blocksImmuneToRift.add(mod_pocketDim.unstableDoor);
        this.blocksImmuneToRift.add(mod_pocketDim.blockRift);
        this.blocksImmuneToRift.add(mod_pocketDim.transientDoor);
        this.blocksImmuneToRift.add(mod_pocketDim.goldenDimensionalDoor);
        this.blocksImmuneToRift.add(mod_pocketDim.goldenDoor);
        this.blocksImmuneToRift.add(mod_pocketDim.personalDimDoor);
        this.blocksImmuneToRift.add(Blocks.field_150368_y);
        this.blocksImmuneToRift.add(Blocks.field_150339_S);
        this.blocksImmuneToRift.add(Blocks.field_150340_R);
        this.blocksImmuneToRift.add(Blocks.field_150484_ah);
        this.blocksImmuneToRift.add(Blocks.field_150475_bE);
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("dimdoors:" + this.func_149739_a());
    }

    public boolean func_149703_v() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149678_a(int par1, boolean par2) {
        return par2;
    }

    public boolean func_149747_d(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return true;
    }

    public int func_149645_b() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return true;
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        return null;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (this.properties.RiftGriefingEnabled && !world.field_72995_K && PocketManager.getLink(x, y, z, world.field_73011_w.field_76574_g) != null && random.nextInt(100) < 50 && ((TileEntityRift)world.func_147438_o(x, y, z)).updateNearestRift()) {
            this.destroyNearbyBlocks(world, x, y, z, random);
        }
    }

    private void destroyNearbyBlocks(World world, int x, int y, int z, Random random) {
        ArrayList<Point3D> targets = this.findReachableBlocks(world, x, y, z, 4, false);
        for (Point3D target : targets) {
            if (random.nextInt(100) >= 50) continue;
            this.dropWorldThread(world.func_147439_a(target.getX(), target.getY(), target.getZ()), world, x, y, z, random);
            world.func_147480_a(target.getX(), target.getY(), target.getZ(), false);
        }
    }

    private ArrayList<Point3D> findReachableBlocks(World world, int x, int y, int z, int range, boolean includeAir) {
        int searchVolume = (int)Math.pow(2 * range + 1, 3.0);
        HashMap<Point3D, Integer> pointDistances = new HashMap<Point3D, Integer>(searchVolume);
        LinkedList<Point3D> points = new LinkedList<Point3D>();
        ArrayList<Point3D> targets = new ArrayList<Point3D>();
        pointDistances.put(new Point3D(x, y, z), 0);
        BlockRift.addAdjacentBlocks(x, y, z, 0, pointDistances, points);
        while (!points.isEmpty()) {
            Point3D current = (Point3D)points.remove();
            int distance = pointDistances.get(current);
            if (world.func_147437_c(current.getX(), current.getY(), current.getZ())) {
                if (includeAir) {
                    targets.add(current);
                }
                if (distance >= 4) continue;
                BlockRift.addAdjacentBlocks(current.getX(), current.getY(), current.getZ(), distance, pointDistances, points);
                continue;
            }
            if (this.isBlockImmune(world, current.getX(), current.getY(), current.getZ())) continue;
            targets.add(current);
        }
        return targets;
    }

    public void dropWorldThread(Block block, World world, int x, int y, int z, Random random) {
        if (!(block.isAir((IBlockAccess)world, x, y, z) || random.nextInt(1000) >= this.properties.WorldThreadDropChance || block instanceof BlockLiquid || block instanceof IFluidBlock)) {
            ItemStack thread = new ItemStack(mod_pocketDim.itemWorldThread, 1);
            world.func_72838_d((Entity)new EntityItem(world, (double)x, (double)y, (double)z, thread));
        }
    }

    private static void addAdjacentBlocks(int x, int y, int z, int distance, HashMap<Point3D, Integer> pointDistances, Queue<Point3D> points) {
        Point3D[] neighbors = new Point3D[]{new Point3D(x - 1, y, z), new Point3D(x + 1, y, z), new Point3D(x, y - 1, z), new Point3D(x, y + 1, z), new Point3D(x, y, z - 1), new Point3D(x, y, z + 1)};
        for (int index = 0; index < neighbors.length; ++index) {
            if (pointDistances.containsKey(neighbors[index])) continue;
            pointDistances.put(neighbors[index], distance + 1);
            points.add(neighbors[index]);
        }
    }

    public boolean spreadRift(NewDimData dimension, DimLink parent, World world, Random random) {
        Block block = null;
        Point4D source = parent.source();
        ArrayList<Point3D> targets = this.findReachableBlocks(world, source.getX(), source.getY(), source.getZ(), 5, true);
        if (!targets.isEmpty()) {
            Point3D target = targets.get(random.nextInt(targets.size()));
            int x = target.getX();
            int y = target.getY();
            int z = target.getZ();
            block = world.func_147439_a(x, y, z);
            if (world.func_147449_b(x, y, z, (Block)mod_pocketDim.blockRift)) {
                dimension.createChildLink(x, y, z, parent);
                this.dropWorldThread(block, world, x, y, z, random);
                return true;
            }
        }
        return false;
    }

    public int func_149656_h() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        ArrayList<Point3D> targets = this.findReachableBlocks(world, x, y, z, 2, false);
        TileEntityRift tile = (TileEntityRift)world.func_147438_o(x, y, z);
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new GoggleRiftFX(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, rand.nextGaussian() * 0.01, rand.nextGaussian() * 0.01, rand.nextGaussian() * 0.01, FMLClientHandler.instance().getClient().field_71452_i));
        if (tile.shouldClose) {
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new ClosingRiftFX(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, rand.nextGaussian() * 0.01, rand.nextGaussian() * 0.01, rand.nextGaussian() * 0.01, FMLClientHandler.instance().getClient().field_71452_i));
        }
    }

    public boolean tryPlacingRift(World world, int x, int y, int z) {
        if (world != null && !this.isBlockImmune(world, x, y, z)) {
            return world.func_147449_b(x, y, z, (Block)mod_pocketDim.blockRift);
        }
        return false;
    }

    public boolean isBlockImmune(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block != null) {
            return block.field_149781_w >= 5000.0f || this.modBlocksImmuneToRift.contains(block) || this.blocksImmuneToRift.contains(block);
        }
        return false;
    }

    public boolean isModBlockImmune(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block != null) {
            return this.modBlocksImmuneToRift.contains(block);
        }
        return false;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        return null;
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return null;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityRift();
    }

    public void func_149749_a(World world, int x, int y, int z, Block oldBlock, int oldMeta) {
        super.func_149749_a(world, x, y, z, oldBlock, oldMeta);
        if (world.func_147439_a(x, y, z) != oldBlock) {
            mod_pocketDim.riftRegenerator.scheduleSlowRegeneration(x, y, z, world);
        }
    }
}

