/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.blocks;

import StevenDimDoors.mod_pocketDim.blocks.IDimDoor;
import StevenDimDoors.mod_pocketDim.config.DDProperties;
import StevenDimDoors.mod_pocketDim.core.DDTeleporter;
import StevenDimDoors.mod_pocketDim.core.DimLink;
import StevenDimDoors.mod_pocketDim.core.LinkType;
import StevenDimDoors.mod_pocketDim.core.PocketManager;
import StevenDimDoors.mod_pocketDim.items.ItemDDKey;
import StevenDimDoors.mod_pocketDim.mod_pocketDim;
import StevenDimDoors.mod_pocketDim.tileentities.TileEntityDimDoor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.IconFlipped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BaseDimDoor
extends BlockDoor
implements IDimDoor,
ITileEntityProvider {
    protected final DDProperties properties;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] upperTextures;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] lowerTextures;

    public BaseDimDoor(Material material, DDProperties properties) {
        super(material);
        this.properties = properties;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.upperTextures = new IIcon[2];
        this.lowerTextures = new IIcon[2];
        this.upperTextures[0] = iconRegister.func_94245_a("dimdoors:" + this.func_149739_a() + "_upper");
        this.lowerTextures[0] = iconRegister.func_94245_a("dimdoors:" + this.func_149739_a() + "_lower");
        this.upperTextures[1] = new IconFlipped(this.upperTextures[0], true, false);
        this.lowerTextures[1] = new IconFlipped(this.lowerTextures[0], true, false);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return this.upperTextures[0];
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        this.enterDimDoor(world, x, y, z, entity);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (stack != null && stack.func_77973_b() instanceof ItemDDKey) {
            return false;
        }
        if (!this.checkCanOpen(world, x, y, z, player)) {
            return false;
        }
        int metadata = this.func_150012_g((IBlockAccess)world, x, y, z);
        int newMetadata = metadata & 7;
        newMetadata ^= 4;
        if ((metadata & 8) == 0) {
            world.func_72921_c(x, y, z, newMetadata, 2);
            world.func_147458_c(x, y, z, x, y, z);
        } else {
            world.func_72921_c(x, y - 1, z, newMetadata, 2);
            world.func_147458_c(x, y - 1, z, x, y, z);
        }
        world.func_72889_a(player, 1003, x, y, z, 0);
        return true;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        this.placeLink(world, x, y, z);
        world.func_147455_a(x, y, z, this.func_149915_a(world, world.func_72805_g(x, y, z)));
        this.updateAttachedTile(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        if (side != 1 && side != 0) {
            int fullMetadata = this.func_150012_g(blockAccess, x, y, z);
            int orientation = fullMetadata & 3;
            boolean reversed = false;
            if (this.isDoorOpen(fullMetadata)) {
                if (orientation == 0 && side == 2) {
                    reversed = !reversed;
                } else if (orientation == 1 && side == 5) {
                    reversed = !reversed;
                } else if (orientation == 2 && side == 3) {
                    reversed = !reversed;
                } else if (orientation == 3 && side == 4) {
                    reversed = !reversed;
                }
            } else {
                if (orientation == 0 && side == 5) {
                    reversed = !reversed;
                } else if (orientation == 1 && side == 3) {
                    reversed = !reversed;
                } else if (orientation == 2 && side == 4) {
                    reversed = !reversed;
                } else if (orientation == 3 && side == 2) {
                    boolean bl = reversed = !reversed;
                }
                if ((fullMetadata & 0x10) != 0) {
                    boolean bl = reversed = !reversed;
                }
            }
            if (this.isUpperDoorBlock(fullMetadata)) {
                return this.upperTextures[reversed ? 1 : 0];
            }
            return this.lowerTextures[reversed ? 1 : 0];
        }
        return this.lowerTextures[0];
    }

    public BaseDimDoor updateAttachedTile(World world, int x, int y, int z) {
        mod_pocketDim.proxy.updateDoorTE(this, world, x, y, z);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityDimDoor) {
            int metadata = world.func_72805_g(x, y, z);
            TileEntityDimDoor dimTile = (TileEntityDimDoor)tile;
            dimTile.openOrClosed = this.isDoorOnRift(world, x, y, z) && this.isUpperDoorBlock(metadata);
            dimTile.orientation = this.func_150012_g((IBlockAccess)world, x, y, z) & 7;
        }
        return this;
    }

    @Override
    public boolean isDoorOnRift(World world, int x, int y, int z) {
        return this.getLink(world, x, y, z) != null;
    }

    public DimLink getLink(World world, int x, int y, int z) {
        DimLink link = PocketManager.getLink(x, y, z, world.field_73011_w.field_76574_g);
        if (link != null) {
            return link;
        }
        if (this.isUpperDoorBlock(world.func_72805_g(x, y, z)) ? (link = PocketManager.getLink(x, y - 1, z, world.field_73011_w.field_76574_g)) != null : (link = PocketManager.getLink(x, y + 1, z, world.field_73011_w.field_76574_g)) != null) {
            return link;
        }
        return null;
    }

    public void func_149674_a(World par1World, int par2, int par3, int par4, Random par5Random) {
        this.updateAttachedTile(par1World, par2, par3, par4);
    }

    public void func_149719_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        this.setDoorRotation(this.func_150012_g(par1IBlockAccess, par2, par3, par4));
    }

    public void setDoorRotation(int par1) {
        boolean var5;
        float var2 = 0.1875f;
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f);
        int var3 = par1 & 3;
        boolean var4 = (par1 & 4) != 0;
        boolean bl = var5 = (par1 & 0x10) != 0;
        if (var3 == 0) {
            if (var4) {
                if (!var5) {
                    this.func_149676_a(0.001f, 0.0f, 0.0f, 1.0f, 1.0f, var2);
                } else {
                    this.func_149676_a(0.001f, 0.0f, 1.0f - var2, 1.0f, 1.0f, 1.0f);
                }
            } else {
                this.func_149676_a(0.0f, 0.0f, 0.0f, var2, 1.0f, 1.0f);
            }
        } else if (var3 == 1) {
            if (var4) {
                if (!var5) {
                    this.func_149676_a(1.0f - var2, 0.0f, 0.001f, 1.0f, 1.0f, 1.0f);
                } else {
                    this.func_149676_a(0.0f, 0.0f, 0.001f, var2, 1.0f, 1.0f);
                }
            } else {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, var2);
            }
        } else if (var3 == 2) {
            if (var4) {
                if (!var5) {
                    this.func_149676_a(0.0f, 0.0f, 1.0f - var2, 0.99f, 1.0f, 1.0f);
                } else {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 0.99f, 1.0f, var2);
                }
            } else {
                this.func_149676_a(1.0f - var2, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        } else if (var3 == 3) {
            if (var4) {
                if (!var5) {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, var2, 1.0f, 0.99f);
                } else {
                    this.func_149676_a(1.0f - var2, 0.0f, 0.0f, 1.0f, 1.0f, 0.99f);
                }
            } else {
                this.func_149676_a(0.0f, 0.0f, 1.0f - var2, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        int metadata = world.func_72805_g(x, y, z);
        if (this.isUpperDoorBlock(metadata)) {
            if (world.func_147439_a(x, y - 1, z) != this) {
                world.func_147468_f(x, y, z);
            }
            if (!neighbor.isAir((IBlockAccess)world, x, y, z) && neighbor != this) {
                this.func_149695_a(world, x, y - 1, z, neighbor);
            }
        } else if (world.func_147439_a(x, y + 1, z) != this) {
            world.func_147468_f(x, y, z);
            if (!world.field_72995_K) {
                this.func_149697_b(world, x, y, z, metadata, 0);
            }
        } else if (this.getLockStatus(world, x, y, z) <= 1) {
            boolean powered;
            boolean bl = powered = world.func_72864_z(x, y, z) || world.func_72864_z(x, y + 1, z);
            if ((powered || !neighbor.isAir((IBlockAccess)world, x, y, z) && neighbor.func_149744_f()) && neighbor != this) {
                this.func_150014_a(world, x, y, z, powered);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        return new ItemStack(this.getDoorItem(), 1, 0);
    }

    public Item func_149650_a(int metadata, Random random, int fortune) {
        return this.isUpperDoorBlock(metadata) ? null : this.getDoorItem();
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return this.getDoorItem();
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityDimDoor();
    }

    @Override
    public void enterDimDoor(World world, int x, int y, int z, Entity entity) {
        if (world.field_72995_K) {
            return;
        }
        if (world.func_147439_a(x, y - 1, z) == this) {
            int metadata = world.func_72805_g(x, y - 1, z);
            boolean canUse = this.isDoorOpen(metadata);
            if (canUse && entity instanceof EntityPlayer) {
                canUse = BaseDimDoor.isEntityFacingDoor(metadata, (EntityLivingBase)entity);
            }
            if (canUse) {
                DimLink link = PocketManager.getLink(x, y, z, world.field_73011_w.field_76574_g);
                if (link != null && (link.linkType() != LinkType.PERSONAL || entity instanceof EntityPlayer)) {
                    try {
                        DDTeleporter.traverseDimDoor(world, link, entity, (Block)this);
                    }
                    catch (Exception e) {
                        System.err.println("Something went wrong teleporting to a dimension:");
                        e.printStackTrace();
                    }
                }
                this.func_150014_a(world, x, y, z, false);
            }
        } else if (world.func_147439_a(x, y + 1, z) == this) {
            this.enterDimDoor(world, x, y + 1, z, entity);
        }
    }

    public boolean isUpperDoorBlock(int metadata) {
        return (metadata & 8) != 0;
    }

    public boolean isDoorOpen(int metadata) {
        return (metadata & 4) != 0;
    }

    public byte getLockStatus(World world, int x, int y, int z) {
        byte status = 0;
        DimLink link = this.getLink(world, x, y, z);
        if (link != null && link.hasLock()) {
            status = (byte)(status + 1);
            if (link.getLockState()) {
                status = (byte)(status + 1);
            }
        }
        return status;
    }

    public boolean checkCanOpen(World world, int x, int y, int z) {
        return this.checkCanOpen(world, x, y, z, null);
    }

    public boolean checkCanOpen(World world, int x, int y, int z, EntityPlayer player) {
        DimLink link = this.getLink(world, x, y, z);
        if (link == null || player == null) {
            return link == null;
        }
        if (!link.getLockState()) {
            return true;
        }
        for (ItemStack item : player.field_71071_by.field_70462_a) {
            if (item == null || !(item.func_77973_b() instanceof ItemDDKey) || !link.tryToOpen(item)) continue;
            return true;
        }
        player.func_85030_a("dimdoors:doorLocked", 1.0f, 1.0f);
        return false;
    }

    protected static boolean isEntityFacingDoor(int metadata, EntityLivingBase entity) {
        int direction = MathHelper.func_76128_c((double)((double)((entity.field_70177_z + 90.0f) * 4.0f / 360.0f) + 0.5)) & 3;
        return (metadata & 3) == direction;
    }

    @Override
    public TileEntity initDoorTE(World world, int x, int y, int z) {
        TileEntity te = this.func_149915_a(world, world.func_72805_g(x, y, z));
        world.func_147455_a(x, y, z, te);
        return te;
    }

    public void func_149749_a(World world, int x, int y, int z, Block oldBlock, int oldMeta) {
        super.func_149749_a(world, x, y, z, oldBlock, oldMeta);
        if (world.func_147439_a(x, y, z) != oldBlock) {
            mod_pocketDim.riftRegenerator.scheduleFastRegeneration(x, y, z, world);
        }
    }
}

