/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim;

import StevenDimDoors.mod_pocketDim.core.PocketManager;
import StevenDimDoors.mod_pocketDim.network.DimDoorsNetwork;
import StevenDimDoors.mod_pocketDim.network.packets.CreateDimensionPacket;
import StevenDimDoors.mod_pocketDim.network.packets.CreateLinkPacket;
import StevenDimDoors.mod_pocketDim.network.packets.DeleteDimensionPacket;
import StevenDimDoors.mod_pocketDim.network.packets.DeleteLinkPacket;
import StevenDimDoors.mod_pocketDim.network.packets.UpdateLinkPacket;
import StevenDimDoors.mod_pocketDim.watcher.ClientDimData;
import StevenDimDoors.mod_pocketDim.watcher.ClientLinkData;
import StevenDimDoors.mod_pocketDim.watcher.IUpdateWatcher;

public class ServerPacketHandler {
    public ServerPacketHandler() {
        PocketManager.registerDimWatcher(new DimWatcher());
        PocketManager.registerLinkWatcher(new LinkWatcher());
    }

    private static class LinkWatcher
    implements IUpdateWatcher<ClientLinkData> {
        private LinkWatcher() {
        }

        @Override
        public void onCreated(ClientLinkData message) {
            DimDoorsNetwork.sendToAllPlayers(new CreateLinkPacket(message));
        }

        @Override
        public void onDeleted(ClientLinkData message) {
            DimDoorsNetwork.sendToAllPlayers(new DeleteLinkPacket(message));
        }

        @Override
        public void update(ClientLinkData message) {
            DimDoorsNetwork.sendToAllPlayers(new UpdateLinkPacket(message));
        }
    }

    private static class DimWatcher
    implements IUpdateWatcher<ClientDimData> {
        private DimWatcher() {
        }

        @Override
        public void onCreated(ClientDimData message) {
            DimDoorsNetwork.sendToAllPlayers(new CreateDimensionPacket(message));
        }

        @Override
        public void onDeleted(ClientDimData message) {
            DimDoorsNetwork.sendToAllPlayers(new DeleteDimensionPacket(message));
        }

        @Override
        public void update(ClientDimData message) {
        }
    }
}

