/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim;

import StevenDimDoors.mod_pocketDim.config.DDProperties;
import StevenDimDoors.mod_pocketDim.config.DDWorldProperties;
import StevenDimDoors.mod_pocketDim.core.DDTeleporter;
import StevenDimDoors.mod_pocketDim.core.DimLink;
import StevenDimDoors.mod_pocketDim.core.DimensionType;
import StevenDimDoors.mod_pocketDim.core.NewDimData;
import StevenDimDoors.mod_pocketDim.core.PocketManager;
import StevenDimDoors.mod_pocketDim.items.BaseItemDoor;
import StevenDimDoors.mod_pocketDim.items.ItemWarpDoor;
import StevenDimDoors.mod_pocketDim.mod_pocketDim;
import StevenDimDoors.mod_pocketDim.ticking.RiftRegenerator;
import StevenDimDoors.mod_pocketDim.util.Point4D;
import StevenDimDoors.mod_pocketDim.world.LimboProvider;
import StevenDimDoors.mod_pocketDim.world.PocketProvider;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public class EventHookContainer {
    private static final int MAX_FOOD_LEVEL = 20;
    private final DDProperties properties;
    private DDWorldProperties worldProperties;
    private RiftRegenerator regenerator;

    public EventHookContainer(DDProperties properties) {
        this.properties = properties;
    }

    public void setSessionFields(DDWorldProperties worldProperties, RiftRegenerator regenerator) {
        this.worldProperties = worldProperties;
        this.regenerator = regenerator;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onInitMapGen(InitMapGenEvent event) {
    }

    @SubscribeEvent
    public void onPlayerEvent(PlayerInteractEvent event) {
        if (event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK) {
            return;
        }
        World world = event.entity.field_70170_p;
        ItemStack stack = event.entityPlayer.field_71071_by.func_70448_g();
        if (stack != null) {
            NewDimData data;
            if (stack.func_77973_b() instanceof ItemWarpDoor && (data = PocketManager.getDimensionData(world)).type() == DimensionType.PERSONAL) {
                mod_pocketDim.sendChat(event.entityPlayer, "Something prevents the Warp Door from tunneling out here");
                event.setCanceled(true);
                return;
            }
            if (BaseItemDoor.tryToPlaceDoor(stack, event.entityPlayer, world, event.x, event.y, event.z, event.face)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K && !PocketManager.isLoaded()) {
            PocketManager.load();
        }
    }

    @SubscribeEvent
    public void onPlayerFall(LivingFallEvent event) {
        event.setCanceled(event.entity.field_70170_p.field_73011_w.field_76574_g == this.properties.LimboDimensionID);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public boolean onDeathWithHighPriority(LivingDeathEvent event) {
        Entity entity = event.entity;
        if (this.properties.LimboEnabled && this.properties.LimboReturnsInventoryEnabled && entity instanceof EntityPlayer && this.isValidSourceForLimbo(entity.field_70170_p.field_73011_w)) {
            if (entity.field_70170_p.field_73011_w instanceof PocketProvider) {
                EntityPlayer player = (EntityPlayer)entity;
                mod_pocketDim.deathTracker.addUsername(player.func_146103_bH().getName());
                this.revivePlayerInLimbo(player);
                event.setCanceled(true);
                return false;
            }
            if (entity.field_70170_p.field_73011_w instanceof LimboProvider && event.source == DamageSource.field_76380_i) {
                EntityPlayer player = (EntityPlayer)entity;
                this.revivePlayerInLimbo(player);
                mod_pocketDim.sendChat(player, "Search for the dark red pools which accumulate in the lower reaches of Limbo");
                event.setCanceled(true);
                return false;
            }
        }
        return true;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public boolean onDeathWithLowPriority(LivingDeathEvent event) {
        Entity entity = event.entity;
        if (entity instanceof EntityPlayer && this.isValidSourceForLimbo(entity.field_70170_p.field_73011_w)) {
            EntityPlayer player = (EntityPlayer)entity;
            mod_pocketDim.deathTracker.addUsername(player.func_146103_bH().getName());
            if (this.properties.LimboEnabled && !this.properties.LimboReturnsInventoryEnabled) {
                player.field_71071_by.func_146027_a(null, -1);
                this.revivePlayerInLimbo(player);
                event.setCanceled(true);
            }
            return false;
        }
        return true;
    }

    private boolean isValidSourceForLimbo(WorldProvider provider) {
        return this.worldProperties.UniversalLimboEnabled && provider.field_76574_g != this.properties.LimboDimensionID || provider instanceof PocketProvider;
    }

    private void revivePlayerInLimbo(EntityPlayer player) {
        player.func_70066_B();
        player.func_70674_bp();
        player.func_70606_j(player.func_110138_aP());
        player.func_71024_bL().func_75122_a(20, 0.0f);
        Point4D destination = LimboProvider.getLimboSkySpawn(player, this.properties);
        DDTeleporter.teleportEntity((Entity)player, destination, false);
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        if (event.world.field_73011_w.field_76574_g == 0) {
            PocketManager.save(true);
            if (mod_pocketDim.deathTracker != null && mod_pocketDim.deathTracker.isModified()) {
                mod_pocketDim.deathTracker.writeToFile();
            }
        }
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load event) {
        Chunk chunk = event.getChunk();
        if (!chunk.field_76637_e.field_72995_K && PocketManager.isLoaded()) {
            NewDimData dimension = PocketManager.createDimensionData(chunk.field_76637_e);
            for (DimLink dimLink : dimension.getChunkLinks(chunk.field_76635_g, chunk.field_76647_h)) {
                this.regenerator.scheduleSlowRegeneration(dimLink);
            }
        }
    }
}

