/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;

public class DeathTracker {
    private ArrayList<String> usernameList = new ArrayList();
    private HashSet<String> usernameSet = new HashSet();
    private String filePath;
    private boolean modified;

    public DeathTracker(String filePath) {
        this.filePath = filePath;
        this.modified = false;
        this.readFromFile();
    }

    private void readFromFile() {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.filePath)));
            String line = reader.readLine();
            while (line != null) {
                if (!(line = line.trim()).isEmpty()) {
                    this.usernameSet.add(line);
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            System.err.println("An unexpected exception occurred while trying to read DeathTracker data:");
            System.err.println(e.toString());
        }
        this.usernameList.addAll(this.usernameSet);
    }

    public void writeToFile() {
        try {
            PrintWriter writer = new PrintWriter(this.filePath);
            for (String username : this.usernameList) {
                writer.println(username);
            }
            writer.close();
            this.modified = false;
        }
        catch (FileNotFoundException e) {
            System.err.println("An unexpected exception occurred while trying to read DeathTracker data:");
            System.err.println(e.toString());
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isEmpty() {
        return this.usernameList.isEmpty();
    }

    public String getRandomUsername(Random random) {
        if (this.usernameList.isEmpty()) {
            throw new IllegalStateException("Cannot retrieve a random username from an empty list.");
        }
        return this.usernameList.get(random.nextInt(this.usernameList.size()));
    }

    public boolean addUsername(String username) {
        if (this.usernameSet.add(username)) {
            this.usernameList.add(username);
            this.modified = true;
            return true;
        }
        return false;
    }
}

