/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim;

import StevenDimDoors.mod_pocketDim.DeathTracker;
import StevenDimDoors.mod_pocketDim.config.DDProperties;
import StevenDimDoors.mod_pocketDim.mod_pocketDim;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;

public class DDLoot {
    private static final String[] SPECIAL_SKULL_OWNERS = new String[]{"stevenrs11", "kamikazekiwi3", "fbt", "Jaitsu", "XCompWiz", "skyboy026", "Wylker"};
    private static final double MIN_ITEM_DAMAGE = 0.3;
    private static final double MAX_ITEM_DAMAGE = 0.9;
    private static final int ITEM_ENCHANTMENT_CHANCE = 50;
    private static final int MAX_ITEM_ENCHANTMENT_CHANCE = 100;
    private static final int SPECIAL_SKULL_CHANCE = 20;
    private static final int MAX_SPECIAL_SKULL_CHANCE = 100;
    public static final String DIMENSIONAL_DUNGEON_CHEST = "dimensionalDungeonChest";
    public static ChestGenHooks DungeonChestInfo = null;
    private static final int CHEST_SIZE = 6;

    private DDLoot() {
    }

    public static void registerInfo(DDProperties properties) {
        DungeonChestInfo = ChestGenHooks.getInfo((String)DIMENSIONAL_DUNGEON_CHEST);
        DungeonChestInfo.setMin(6);
        DungeonChestInfo.setMax(6);
        ArrayList<WeightedRandomChestContent> items = new ArrayList<WeightedRandomChestContent>();
        DDLoot.addContent(true, items, Items.field_151042_j, 160, 1, 3);
        DDLoot.addContent(true, items, Items.field_151044_h, 120, 1, 3);
        DDLoot.addContent(true, items, Items.field_151128_bU, 120, 1, 3);
        DDLoot.addContent(true, items, Items.field_151122_aG, 100);
        DDLoot.addContent(true, items, Items.field_151043_k, 80, 1, 3);
        DDLoot.addContent(true, items, Items.field_151045_i, 40, 1, 2);
        DDLoot.addContent(true, items, Items.field_151166_bC, 20, 1, 2);
        DDLoot.addContent(true, items, Items.field_151153_ao, 10);
        DDLoot.addContent(properties.FabricOfRealityLootEnabled, items, Item.func_150898_a((Block)mod_pocketDim.blockDimWall), 20, 16, 64);
        DDLoot.addContent(properties.WorldThreadLootEnabled, items, mod_pocketDim.itemWorldThread, 80, 2, 12);
        DDLoot.addItemsToContainer(DungeonChestInfo, items);
    }

    private static void addContent(boolean include, ArrayList<WeightedRandomChestContent> items, Item item, int weight) {
        if (include) {
            items.add(new WeightedRandomChestContent(item, 0, 1, 1, weight));
        }
    }

    private static void addContent(boolean include, ArrayList<WeightedRandomChestContent> items, Item item, int weight, int minAmount, int maxAmount) {
        if (include) {
            items.add(new WeightedRandomChestContent(item, 0, minAmount, maxAmount, weight));
        }
    }

    private static void addItemsToContainer(ChestGenHooks container, ArrayList<WeightedRandomChestContent> items) {
        for (WeightedRandomChestContent item : items) {
            container.addItem(item);
        }
    }

    private static void fillChest(ArrayList<ItemStack> stacks, IInventory inventory, Random random) {
        int primeOffset = 239333;
        int size = inventory.func_70302_i_();
        for (ItemStack item : stacks) {
            int index = random.nextInt(size);
            for (int limit = size; limit > 0 && inventory.func_70301_a(index) != null; --limit) {
                index = (index + 239333) % size;
            }
            inventory.func_70299_a(index, item);
        }
    }

    public static void generateChestContents(ChestGenHooks chestInfo, IInventory inventory, Random random) {
        int count = chestInfo.getCount(random);
        WeightedRandomChestContent[] content = chestInfo.getItems(random);
        ArrayList<ItemStack> allStacks = new ArrayList<ItemStack>();
        for (int k = 0; k < count; ++k) {
            WeightedRandomChestContent selection = (WeightedRandomChestContent)WeightedRandom.func_76274_a((Random)random, (WeightedRandom.Item[])content);
            selection = selection.field_76297_b.func_77973_b().getChestGenBase(chestInfo, random, selection);
            ItemStack[] stacks = ChestGenHooks.generateStacks((Random)random, (ItemStack)selection.field_76297_b, (int)selection.field_76295_d, (int)selection.field_76296_e);
            for (int h = 0; h < stacks.length; ++h) {
                allStacks.add(stacks[h]);
            }
        }
        DDLoot.fillChest(allStacks, inventory, random);
    }

    public static void fillGraveChest(IInventory inventory, Random random, DDProperties properties) {
        int k;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ArrayList selection = new ArrayList();
        int count = MathHelper.func_76136_a((Random)random, (int)2, (int)5);
        for (k = 0; k < count; ++k) {
            stacks.add(new ItemStack(Items.field_151103_aS, 1));
        }
        count = MathHelper.func_76136_a((Random)random, (int)2, (int)4);
        for (k = 0; k < count; ++k) {
            stacks.add(new ItemStack(Items.field_151078_bh, 1));
        }
        if (random.nextInt(100) < 30) {
            DDLoot.addModifiedTool(Items.field_151035_b, stacks, random);
        }
        if (random.nextInt(100) < 30) {
            DDLoot.addModifiedBow(stacks, random);
            stacks.add(new ItemStack(Items.field_151032_g, MathHelper.func_76136_a((Random)random, (int)8, (int)32)));
        }
        if (properties.RiftBladeLootEnabled && random.nextInt(100) < 10) {
            stacks.add(new ItemStack(mod_pocketDim.itemRiftBlade, 1));
        } else {
            DDLoot.addModifiedSword(DDLoot.getRandomItem(Items.field_151040_l, Items.field_151052_q, null, 20, 10, random), stacks, random);
        }
        DDLoot.addModifiedEquipment(DDLoot.getRandomItem((Item)Items.field_151028_Y, (Item)Items.field_151020_U, null, 25, 10, random), stacks, random);
        DDLoot.addModifiedEquipment(DDLoot.getRandomItem((Item)Items.field_151030_Z, (Item)Items.field_151023_V, null, 25, 10, random), stacks, random);
        DDLoot.addModifiedEquipment(DDLoot.getRandomItem((Item)Items.field_151165_aa, (Item)Items.field_151022_W, null, 25, 10, random), stacks, random);
        DDLoot.addModifiedEquipment(DDLoot.getRandomItem((Item)Items.field_151167_ab, (Item)Items.field_151167_ab, null, 25, 10, random), stacks, random);
        DDLoot.addItemWithChance(stacks, random, 40, Items.field_151057_cb, 1);
        DDLoot.addItemWithChance(stacks, random, 35, Items.field_151069_bo, 1);
        DDLoot.addItemWithChance(stacks, random, 30, Items.field_151079_bi, 1);
        DDLoot.addItemWithChance(stacks, random, 30, Items.field_151073_bk, 1);
        DDLoot.addItemWithChance(stacks, random, 5, Items.field_151086_cn, 1);
        if (random.nextInt(100) < 5) {
            DDLoot.addGraveSkull(stacks, random);
        }
        DDLoot.fillChest(stacks, inventory, random);
    }

    private static void addModifiedEquipment(Item item, ArrayList<ItemStack> stacks, Random random) {
        if (item == null) {
            return;
        }
        stacks.add(DDLoot.getModifiedItem(item, random, new Enchantment[]{Enchantment.field_77327_f, Enchantment.field_77329_d, Enchantment.field_77332_c, Enchantment.field_77328_g}));
    }

    private static void addModifiedSword(Item item, ArrayList<ItemStack> stacks, Random random) {
        if (item == null) {
            return;
        }
        stacks.add(DDLoot.getModifiedItem(item, random, new Enchantment[]{Enchantment.field_77334_n, Enchantment.field_77337_m, Enchantment.field_77338_j}));
    }

    private static void addModifiedTool(Item tool, ArrayList<ItemStack> stacks, Random random) {
        if (tool == null) {
            return;
        }
        stacks.add(DDLoot.getModifiedItem(tool, random, new Enchantment[]{Enchantment.field_77349_p, Enchantment.field_77347_r}));
    }

    private static void addModifiedBow(ArrayList<ItemStack> stacks, Random random) {
        stacks.add(DDLoot.getModifiedItem((Item)Items.field_151031_f, random, new Enchantment[]{Enchantment.field_77343_v, Enchantment.field_77345_t, Enchantment.field_77344_u}));
    }

    private static ItemStack getModifiedItem(Item item, Random random, Enchantment[] enchantments) {
        ItemStack result = DDLoot.applyRandomDamage(item, random);
        if (enchantments.length > 0 && random.nextInt(100) < 50) {
            result.func_77966_a(enchantments[random.nextInt(enchantments.length)], 1);
        }
        return result;
    }

    private static Item getRandomItem(Item a, Item b, Item c, int weightA, int weightB, Random random) {
        int roll = random.nextInt(100);
        if (roll < weightA) {
            return a;
        }
        if (roll < weightA + weightB) {
            return b;
        }
        return c;
    }

    private static void addItemWithChance(ArrayList<ItemStack> stacks, Random random, int chance, Item item, int count) {
        if (random.nextInt(100) < chance) {
            stacks.add(new ItemStack(item, count));
        }
    }

    private static ItemStack applyRandomDamage(Item item, Random random) {
        int damage = (int)((double)item.func_77612_l() * MathHelper.func_82716_a((Random)random, (double)0.3, (double)0.9));
        return new ItemStack(item, 1, damage);
    }

    private static void addGraveSkull(ArrayList<ItemStack> stacks, Random random) {
        int PLAYER_SKULL_METADATA = 3;
        DeathTracker deathTracker = mod_pocketDim.deathTracker;
        String skullOwner = deathTracker.isEmpty() || random.nextInt(100) < 20 ? SPECIAL_SKULL_OWNERS[random.nextInt(SPECIAL_SKULL_OWNERS.length)] : deathTracker.getRandomUsername(random);
        ItemStack skull = new ItemStack(Items.field_151144_bL, 1, 3);
        skull.field_77990_d = new NBTTagCompound();
        skull.field_77990_d.func_74778_a("SkullOwner", skullOwner);
        stacks.add(skull);
    }
}

