/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.experimental;

import StevenDimDoors.mod_pocketDim.schematic.WorldOperation;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public class SphereDecayOperation
extends WorldOperation {
    private Random random;
    private double scaling;
    private double centerX;
    private double centerY;
    private double centerZ;
    private Block primaryBlock;
    private int primaryMetadata;
    private Block secondaryBlock;
    private int secondaryMetadata;

    public SphereDecayOperation(Random random, Block primaryBlock, int primaryMetadata, Block secondaryBlock, int secondaryMetadata) {
        super("SphereDecayOperation");
        this.random = random;
        this.primaryBlock = primaryBlock;
        this.primaryMetadata = primaryMetadata;
        this.secondaryBlock = secondaryBlock;
        this.secondaryMetadata = secondaryMetadata;
    }

    @Override
    protected boolean initialize(World world, int x, int y, int z, int width, int height, int length) {
        this.scaling = (double)Math.max(width - 1, Math.max(height - 1, length - 1)) / 2.0;
        this.scaling *= this.scaling * 0.2;
        this.centerX = (double)x + (double)width / 2.0;
        this.centerY = (double)y + (double)height / 2.0;
        this.centerZ = (double)z + (double)length / 2.0;
        return true;
    }

    @Override
    protected boolean applyToBlock(World world, int x, int y, int z) {
        if (!world.func_147437_c(x, y, z)) {
            double dx = this.centerX - (double)x - 0.5;
            double dy = this.centerY - (double)y - 0.5;
            double dz = this.centerZ - (double)z - 0.5;
            double squareDistance = dx * dx + dy * dy + dz * dz;
            if (squareDistance < 0.5 || this.random.nextDouble() < this.scaling / squareDistance) {
                world.func_147465_d(x, y, z, this.primaryBlock, this.primaryMetadata, 1);
            } else if (this.random.nextDouble() < this.scaling / squareDistance) {
                world.func_147465_d(x, y, z, this.secondaryBlock, this.secondaryMetadata, 1);
            }
        }
        return true;
    }
}

