/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.experimental;

import StevenDimDoors.experimental.BoundingBox;
import StevenDimDoors.mod_pocketDim.Point3D;

public class PartitionNode
extends BoundingBox {
    private PartitionNode parent;
    private PartitionNode leftChild = null;
    private PartitionNode rightChild = null;

    public PartitionNode(int width, int height, int length) {
        super(new Point3D(0, 0, 0), new Point3D(width - 1, height - 1, length - 1));
        this.parent = null;
    }

    private PartitionNode(PartitionNode parent, Point3D minCorner, Point3D maxCorner) {
        super(minCorner, maxCorner);
        this.parent = parent;
    }

    public boolean isLeaf() {
        return this.leftChild == null && this.rightChild == null;
    }

    public PartitionNode leftChild() {
        return this.leftChild;
    }

    public PartitionNode rightChild() {
        return this.rightChild;
    }

    public PartitionNode parent() {
        return this.parent;
    }

    public void splitByX(int rightStart) {
        if (!this.isLeaf()) {
            throw new IllegalStateException("This node has already been split.");
        }
        if (rightStart <= this.minCorner.getX() || rightStart > this.maxCorner.getX()) {
            throw new IllegalArgumentException("The specified cutting plane is invalid.");
        }
        this.leftChild = new PartitionNode(this, this.minCorner, new Point3D(rightStart - 1, this.maxCorner.getY(), this.maxCorner.getZ()));
        this.rightChild = new PartitionNode(this, new Point3D(rightStart, this.minCorner.getY(), this.minCorner.getZ()), this.maxCorner);
    }

    public void splitByY(int rightStart) {
        if (!this.isLeaf()) {
            throw new IllegalStateException("This node has already been split.");
        }
        if (rightStart <= this.minCorner.getY() || rightStart > this.maxCorner.getY()) {
            throw new IllegalArgumentException("The specified cutting plane is invalid.");
        }
        this.leftChild = new PartitionNode(this, this.minCorner, new Point3D(this.maxCorner.getX(), rightStart - 1, this.maxCorner.getZ()));
        this.rightChild = new PartitionNode(this, new Point3D(this.minCorner.getX(), rightStart, this.minCorner.getZ()), this.maxCorner);
    }

    public void splitByZ(int rightStart) {
        if (!this.isLeaf()) {
            throw new IllegalStateException("This node has already been split.");
        }
        if (rightStart <= this.minCorner.getZ() || rightStart > this.maxCorner.getZ()) {
            throw new IllegalArgumentException("The specified cutting plane is invalid.");
        }
        this.leftChild = new PartitionNode(this, this.minCorner, new Point3D(this.maxCorner.getX(), this.maxCorner.getY(), rightStart - 1));
        this.rightChild = new PartitionNode(this, new Point3D(this.minCorner.getX(), this.minCorner.getY(), rightStart), this.maxCorner);
    }

    public void remove() {
        if (this.parent != null) {
            if (this.parent.leftChild == this) {
                this.parent.leftChild = null;
            } else {
                this.parent.rightChild = null;
            }
            this.parent = null;
        }
    }

    public PartitionNode findPoint(int x, int y, int z) {
        if (this.contains(x, y, z)) {
            return this.findPointInternal(x, y, z);
        }
        return null;
    }

    private PartitionNode findPointInternal(int x, int y, int z) {
        if (this.leftChild != null && this.leftChild.contains(x, y, z)) {
            return this.leftChild.findPointInternal(x, y, z);
        }
        if (this.rightChild != null && this.rightChild.contains(x, y, z)) {
            return this.rightChild.findPointInternal(x, y, z);
        }
        return this;
    }
}

