/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.experimental;

import StevenDimDoors.experimental.DirectedGraph;
import StevenDimDoors.experimental.DisjointSet;
import StevenDimDoors.experimental.DoorwayData;
import StevenDimDoors.experimental.IEdge;
import StevenDimDoors.experimental.IGraphNode;
import StevenDimDoors.experimental.MazeDesign;
import StevenDimDoors.experimental.PartitionNode;
import StevenDimDoors.mod_pocketDim.Point3D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Random;
import java.util.Stack;
import net.minecraft.util.MathHelper;

public class MazeDesigner {
    private static final int MAZE_WIDTH = 34;
    private static final int MAZE_LENGTH = 34;
    private static final int MAZE_HEIGHT = 20;
    private static final int MIN_HEIGHT = 4;
    private static final int MIN_SIDE = 3;
    private static final int SPLIT_COUNT = 9;

    private MazeDesigner() {
    }

    public static MazeDesign generate(Random random) {
        PartitionNode root = MazeDesigner.partitionRooms(34, 20, 34, 9, random);
        ArrayList<PartitionNode> partitions = new ArrayList<PartitionNode>(512);
        MazeDesigner.listRoomPartitions(root, partitions);
        DirectedGraph<PartitionNode, DoorwayData> rooms = MazeDesigner.createRoomGraph(root, partitions, random);
        ArrayList<IGraphNode<PartitionNode, DoorwayData>> cores = MazeDesigner.createMazeSections(rooms, random);
        for (IGraphNode<PartitionNode, DoorwayData> core : cores) {
            MazeDesigner.pruneDoorways(core, rooms, random);
        }
        return new MazeDesign(root, rooms, cores);
    }

    private static void listRoomPartitions(PartitionNode node, ArrayList<PartitionNode> partitions) {
        if (node.isLeaf()) {
            partitions.add(node);
        } else {
            MazeDesigner.listRoomPartitions(node.leftChild(), partitions);
            MazeDesigner.listRoomPartitions(node.rightChild(), partitions);
        }
    }

    private static void removeRoomPartitions(PartitionNode node) {
        PartitionNode current = node;
        while (current != null && current.isLeaf()) {
            PartitionNode parent = current.parent();
            current.remove();
            current = parent;
        }
    }

    private static PartitionNode partitionRooms(int width, int height, int length, int maxLevels, Random random) {
        PartitionNode root = new PartitionNode(width, height, length);
        MazeDesigner.splitByRandomX(root, maxLevels, random);
        return root;
    }

    private static void splitByRandomX(PartitionNode node, int levels, Random random) {
        if (node.width() >= 6) {
            node.splitByX(MathHelper.func_76136_a((Random)random, (int)(node.minCorner().getX() + 3), (int)(node.maxCorner().getX() - 3 + 1)));
            if (levels > 1) {
                MazeDesigner.splitByRandomZ(node.leftChild(), levels - 1, random);
                MazeDesigner.splitByRandomZ(node.rightChild(), levels - 1, random);
            }
        } else if (levels > 1) {
            MazeDesigner.splitByRandomZ(node, levels - 1, random);
        }
    }

    private static void splitByRandomZ(PartitionNode node, int levels, Random random) {
        if (node.length() >= 6) {
            node.splitByZ(MathHelper.func_76136_a((Random)random, (int)(node.minCorner().getZ() + 3), (int)(node.maxCorner().getZ() - 3 + 1)));
            if (levels > 1) {
                MazeDesigner.splitByRandomY(node.leftChild(), levels - 1, random);
                MazeDesigner.splitByRandomY(node.rightChild(), levels - 1, random);
            }
        } else if (levels > 1) {
            MazeDesigner.splitByRandomY(node, levels - 1, random);
        }
    }

    private static void splitByRandomY(PartitionNode node, int levels, Random random) {
        if (node.height() >= 8) {
            node.splitByY(MathHelper.func_76136_a((Random)random, (int)(node.minCorner().getY() + 4), (int)(node.maxCorner().getY() - 4 + 1)));
            if (levels > 1) {
                MazeDesigner.splitByRandomX(node.leftChild(), levels - 1, random);
                MazeDesigner.splitByRandomX(node.rightChild(), levels - 1, random);
            }
        } else if (levels > 1) {
            MazeDesigner.splitByRandomX(node, levels - 1, random);
        }
    }

    private static DirectedGraph<PartitionNode, DoorwayData> createRoomGraph(PartitionNode root, ArrayList<PartitionNode> partitions, Random random) {
        DirectedGraph<PartitionNode, DoorwayData> roomGraph = new DirectedGraph<PartitionNode, DoorwayData>();
        HashMap<PartitionNode, IGraphNode<PartitionNode, DoorwayData>> roomsToGraph = new HashMap<PartitionNode, IGraphNode<PartitionNode, DoorwayData>>(2 * partitions.size());
        Collections.shuffle(partitions, random);
        for (PartitionNode partitionNode : partitions) {
            roomsToGraph.put(partitionNode, roomGraph.addNode(partitionNode));
        }
        for (IGraphNode iGraphNode : roomGraph.nodes()) {
            MazeDesigner.findDoorways(iGraphNode, root, roomsToGraph, roomGraph);
        }
        return roomGraph;
    }

    private static void findDoorways(IGraphNode<PartitionNode, DoorwayData> roomNode, PartitionNode root, HashMap<PartitionNode, IGraphNode<PartitionNode, DoorwayData>> roomsToGraph, DirectedGraph<PartitionNode, DoorwayData> roomGraph) {
        int r;
        int maxZI;
        int minZI;
        int c;
        IGraphNode<PartitionNode, DoorwayData> adjacentNode;
        DoorwayData doorway;
        int q;
        int p;
        int maxYI;
        int minYI;
        int maxXI;
        int minXI;
        Point3D otherMax;
        Point3D otherMin;
        PartitionNode adjacent;
        int b;
        int a;
        boolean[][] detected;
        PartitionNode room = roomNode.data();
        Point3D minCorner = room.minCorner();
        Point3D maxCorner = room.maxCorner();
        int minX = minCorner.getX();
        int minY = minCorner.getY();
        int minZ = minCorner.getZ();
        int maxX = maxCorner.getX();
        int maxY = maxCorner.getY();
        int maxZ = maxCorner.getZ();
        int width = room.width();
        int height = room.height();
        int length = room.length();
        if (maxZ < root.maxCorner().getZ()) {
            detected = new boolean[width][height];
            for (a = 0; a < width; ++a) {
                for (b = 0; b < height; ++b) {
                    if (detected[a][b]) continue;
                    adjacent = root.findPoint(minX + a, minY + b, maxZ + 1);
                    if (adjacent != null) {
                        otherMin = adjacent.minCorner();
                        otherMax = adjacent.maxCorner();
                        minXI = Math.max(minX, otherMin.getX());
                        maxXI = Math.min(maxX, otherMax.getX());
                        minYI = Math.max(minY, otherMin.getY());
                        maxYI = Math.min(maxY, otherMax.getY());
                        for (p = 0; p <= maxXI - minXI; ++p) {
                            for (q = 0; q <= maxYI - minYI; ++q) {
                                detected[p + a][q + b] = true;
                            }
                        }
                        if (maxXI - minXI + 1 < 3 || maxYI - minYI + 1 < 4) continue;
                        otherMin = new Point3D(minXI, minYI, maxZ);
                        otherMax = new Point3D(maxXI, maxYI, maxZ + 1);
                        doorway = new DoorwayData(otherMin, otherMax, 'Z');
                        adjacentNode = roomsToGraph.get(adjacent);
                        roomGraph.addEdge(roomNode, adjacentNode, doorway);
                        continue;
                    }
                    detected[a][b] = true;
                }
            }
        }
        if (maxX < root.maxCorner().getX()) {
            detected = new boolean[height][length];
            for (b = 0; b < height; ++b) {
                for (c = 0; c < length; ++c) {
                    if (detected[b][c]) continue;
                    adjacent = root.findPoint(maxX + 1, minY + b, minZ + c);
                    if (adjacent != null) {
                        otherMin = adjacent.minCorner();
                        otherMax = adjacent.maxCorner();
                        minYI = Math.max(minY, otherMin.getY());
                        maxYI = Math.min(maxY, otherMax.getY());
                        minZI = Math.max(minZ, otherMin.getZ());
                        maxZI = Math.min(maxZ, otherMax.getZ());
                        for (q = 0; q <= maxYI - minYI; ++q) {
                            for (r = 0; r <= maxZI - minZI; ++r) {
                                detected[q + b][r + c] = true;
                            }
                        }
                        if (maxYI - minYI + 1 < 4 || maxZI - minZI + 1 < 3) continue;
                        otherMin = new Point3D(maxX, minYI, minZI);
                        otherMax = new Point3D(maxX + 1, maxYI, maxZI);
                        doorway = new DoorwayData(otherMin, otherMax, 'X');
                        adjacentNode = roomsToGraph.get(adjacent);
                        roomGraph.addEdge(roomNode, adjacentNode, doorway);
                        continue;
                    }
                    detected[b][c] = true;
                }
            }
        }
        if (maxY < root.maxCorner().getY()) {
            detected = new boolean[width][length];
            for (a = 0; a < width; ++a) {
                for (c = 0; c < length; ++c) {
                    if (detected[a][c]) continue;
                    adjacent = root.findPoint(minX + a, maxY + 1, minZ + c);
                    if (adjacent != null) {
                        otherMin = adjacent.minCorner();
                        otherMax = adjacent.maxCorner();
                        minXI = Math.max(minX, otherMin.getX());
                        maxXI = Math.min(maxX, otherMax.getX());
                        minZI = Math.max(minZ, otherMin.getZ());
                        maxZI = Math.min(maxZ, otherMax.getZ());
                        for (p = 0; p <= maxXI - minXI; ++p) {
                            for (r = 0; r <= maxZI - minZI; ++r) {
                                detected[p + a][r + c] = true;
                            }
                        }
                        if (maxXI - minXI + 1 < 3 || maxZI - minZI + 1 < 3) continue;
                        otherMin = new Point3D(minXI, maxY, minZI);
                        otherMax = new Point3D(maxXI, maxY + 1, maxZI);
                        doorway = new DoorwayData(otherMin, otherMax, 'Y');
                        adjacentNode = roomsToGraph.get(adjacent);
                        roomGraph.addEdge(roomNode, adjacentNode, doorway);
                        continue;
                    }
                    detected[a][c] = true;
                }
            }
        }
    }

    private static ArrayList<IGraphNode<PartitionNode, DoorwayData>> createMazeSections(DirectedGraph<PartitionNode, DoorwayData> roomGraph, Random random) {
        int MAX_DISTANCE = 2;
        int MIN_SECTION_ROOMS = 5;
        ArrayList<IGraphNode<PartitionNode, DoorwayData>> cores = new ArrayList<IGraphNode<PartitionNode, DoorwayData>>();
        ArrayList removals = new ArrayList();
        ArrayList<IGraphNode> section = new ArrayList<IGraphNode>();
        LinkedList ordering = new LinkedList();
        HashMap distances = new HashMap();
        for (IGraphNode<PartitionNode, DoorwayData> iGraphNode : roomGraph.nodes()) {
            if (distances.containsKey(iGraphNode)) continue;
            distances.put(iGraphNode, 0);
            ordering.add(iGraphNode);
            section.clear();
            while (!ordering.isEmpty()) {
                IGraphNode current = (IGraphNode)ordering.remove();
                int distance = (Integer)distances.get(current) + 1;
                if (distance <= 3) {
                    IGraphNode neighbor;
                    section.add(current);
                    for (IEdge edge : current.inbound()) {
                        neighbor = edge.head();
                        if (distances.containsKey(neighbor)) continue;
                        distances.put(neighbor, distance);
                        ordering.add(neighbor);
                    }
                    for (IEdge edge : current.outbound()) {
                        neighbor = edge.tail();
                        if (distances.containsKey(neighbor)) continue;
                        distances.put(neighbor, distance);
                        ordering.add(neighbor);
                    }
                    continue;
                }
                removals.add(current);
                break;
            }
            while (!ordering.isEmpty()) {
                removals.add(ordering.remove());
            }
            if (section.size() >= 5) {
                cores.add(iGraphNode);
                continue;
            }
            removals.addAll(section);
        }
        for (IGraphNode<PartitionNode, DoorwayData> iGraphNode : removals) {
            MazeDesigner.removeRoomPartitions(iGraphNode.data());
            roomGraph.removeNode(iGraphNode);
        }
        return cores;
    }

    private static void pruneDoorways(IGraphNode<PartitionNode, DoorwayData> core, DirectedGraph<PartitionNode, DoorwayData> rooms, Random random) {
        Stack ordering = new Stack();
        ArrayList<IGraphNode> subgraph = new ArrayList<IGraphNode>(64);
        DisjointSet components = new DisjointSet(128);
        ordering.add(core);
        components.makeSet(core);
        while (!ordering.isEmpty()) {
            IGraphNode neighbor;
            IGraphNode current = (IGraphNode)ordering.pop();
            subgraph.add(current);
            for (IEdge edge : current.inbound()) {
                neighbor = edge.head();
                if (!components.makeSet(neighbor)) continue;
                ordering.add(neighbor);
            }
            for (IEdge edge : current.outbound()) {
                neighbor = edge.tail();
                if (!components.makeSet(neighbor)) continue;
                ordering.add(neighbor);
            }
        }
        ArrayList targets = new ArrayList();
        for (IGraphNode iGraphNode : subgraph) {
            for (IEdge passage : iGraphNode.outbound()) {
                if (((DoorwayData)passage.data()).axis() != 'Y') {
                    components.mergeSets(passage.head(), passage.tail());
                    continue;
                }
                targets.add(passage);
            }
        }
        Collections.shuffle(targets, random);
        for (IEdge iEdge : targets) {
            if (components.mergeSets(iEdge.head(), iEdge.tail())) continue;
            rooms.removeEdge(iEdge);
        }
        components.clear();
        targets.clear();
        for (IGraphNode iGraphNode : subgraph) {
            components.makeSet(iGraphNode);
        }
        for (IGraphNode iGraphNode : subgraph) {
            for (IEdge passage : iGraphNode.outbound()) {
                if (((DoorwayData)passage.data()).axis() == 'Y') {
                    components.mergeSets(passage.head(), passage.tail());
                    continue;
                }
                targets.add(passage);
            }
        }
        Collections.shuffle(targets, random);
        for (IEdge iEdge : targets) {
            if (components.mergeSets(iEdge.head(), iEdge.tail()) || !random.nextBoolean()) continue;
            rooms.removeEdge(iEdge);
        }
    }
}

