/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.experimental;

import StevenDimDoors.experimental.DirectedGraph;
import StevenDimDoors.experimental.DoorwayData;
import StevenDimDoors.experimental.IEdge;
import StevenDimDoors.experimental.IGraphNode;
import StevenDimDoors.experimental.MazeDesign;
import StevenDimDoors.experimental.MazeDesigner;
import StevenDimDoors.experimental.PartitionNode;
import StevenDimDoors.experimental.SphereDecayOperation;
import StevenDimDoors.mod_pocketDim.Point3D;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class MazeBuilder {
    private MazeBuilder() {
    }

    public static void generate(World world, int x, int y, int z, Random random) {
        MazeDesign design = MazeDesigner.generate(random);
        Point3D offset = new Point3D(x - design.width() / 2, y - design.height() - 1, z - design.length() / 2);
        SphereDecayOperation decay = new SphereDecayOperation(random, Blocks.field_150350_a, 0, Blocks.field_150417_aV, 2);
        MazeBuilder.buildRooms(design.getRoomGraph(), world, offset);
        MazeBuilder.carveDoorways(design.getRoomGraph(), world, offset, decay, random);
        MazeBuilder.applyRandomDestruction(design, world, offset, decay, random);
    }

    private static void applyRandomDestruction(MazeDesign design, World world, Point3D offset, SphereDecayOperation decay, Random random) {
    }

    private static void buildRooms(DirectedGraph<PartitionNode, DoorwayData> roomGraph, World world, Point3D offset) {
        for (IGraphNode<PartitionNode, DoorwayData> node : roomGraph.nodes()) {
            PartitionNode room = node.data();
            MazeBuilder.buildBox(world, offset, room.minCorner(), room.maxCorner(), Blocks.field_150417_aV, 0);
        }
    }

    private static void carveDoorways(DirectedGraph<PartitionNode, DoorwayData> roomGraph, World world, Point3D offset, SphereDecayOperation decay, Random random) {
        for (IGraphNode<PartitionNode, DoorwayData> node : roomGraph.nodes()) {
            for (IEdge<PartitionNode, DoorwayData> passage : node.outbound()) {
                DoorwayData doorway = passage.data();
                char axis = doorway.axis();
                Point3D lower = doorway.minCorner();
                MazeBuilder.carveDoorway(world, axis, offset.getX() + lower.getX(), offset.getY() + lower.getY(), offset.getZ() + lower.getZ(), doorway.width(), doorway.height(), doorway.length(), decay, random);
            }
        }
    }

    private static void carveDoorway(World world, char axis, int x, int y, int z, int width, int height, int length, SphereDecayOperation decay, Random random) {
        int MIN_DOUBLE_DOOR_SPAN = 10;
        switch (axis) {
            case 'X': {
                if (length >= 10) {
                    int gap = (length - 2) / 3;
                    MazeBuilder.carveDoorAlongX(world, x, y + 1, z + gap);
                    MazeBuilder.carveDoorAlongX(world, x, y + 1, z + length - gap - 1);
                    break;
                }
                if (length > 3) {
                    switch (random.nextInt(3)) {
                        case 0: {
                            MazeBuilder.carveDoorAlongX(world, x, y + 1, z + (length - 1) / 2);
                            break;
                        }
                        case 1: {
                            MazeBuilder.carveDoorAlongX(world, x, y + 1, z + 2);
                            break;
                        }
                        case 2: {
                            MazeBuilder.carveDoorAlongX(world, x, y + 1, z + length - 3);
                        }
                    }
                    break;
                }
                MazeBuilder.carveDoorAlongX(world, x, y + 1, z + 1);
                break;
            }
            case 'Z': {
                if (width >= 10) {
                    int gap = (width - 2) / 3;
                    MazeBuilder.carveDoorAlongZ(world, x + gap, y + 1, z);
                    MazeBuilder.carveDoorAlongZ(world, x + width - gap - 1, y + 1, z);
                    break;
                }
                if (length > 3) {
                    switch (random.nextInt(3)) {
                        case 0: {
                            MazeBuilder.carveDoorAlongZ(world, x + (width - 1) / 2, y + 1, z);
                            break;
                        }
                        case 1: {
                            MazeBuilder.carveDoorAlongZ(world, x + 2, y + 1, z);
                            break;
                        }
                        case 2: {
                            MazeBuilder.carveDoorAlongZ(world, x + width - 3, y + 1, z);
                        }
                    }
                    break;
                }
                MazeBuilder.carveDoorAlongZ(world, x + 1, y + 1, z);
                break;
            }
            case 'Y': {
                int gap = Math.min(width, length) - 2;
                if (gap > 1) {
                    if (gap > 6) {
                        gap = 6;
                    }
                    decay.apply(world, x + random.nextInt(width - gap - 1) + 1, y - 1, z + random.nextInt(length - gap - 1) + 1, gap, 4, gap);
                    break;
                }
                MazeBuilder.carveHole(world, x + 1, y, z + 1);
            }
        }
    }

    private static void carveDoorAlongX(World world, int x, int y, int z) {
        MazeBuilder.setBlockDirectly(world, x, y, z, Blocks.field_150350_a, 0);
        MazeBuilder.setBlockDirectly(world, x, y + 1, z, Blocks.field_150350_a, 0);
        MazeBuilder.setBlockDirectly(world, x + 1, y, z, Blocks.field_150350_a, 0);
        MazeBuilder.setBlockDirectly(world, x + 1, y + 1, z, Blocks.field_150350_a, 0);
    }

    private static void carveDoorAlongZ(World world, int x, int y, int z) {
        MazeBuilder.setBlockDirectly(world, x, y, z, Blocks.field_150350_a, 0);
        MazeBuilder.setBlockDirectly(world, x, y + 1, z, Blocks.field_150350_a, 0);
        MazeBuilder.setBlockDirectly(world, x, y, z + 1, Blocks.field_150350_a, 0);
        MazeBuilder.setBlockDirectly(world, x, y + 1, z + 1, Blocks.field_150350_a, 0);
    }

    private static void carveHole(World world, int x, int y, int z) {
        MazeBuilder.setBlockDirectly(world, x, y, z, Blocks.field_150350_a, 0);
        MazeBuilder.setBlockDirectly(world, x, y + 1, z, Blocks.field_150350_a, 0);
    }

    private static void buildBox(World world, Point3D offset, Point3D minCorner, Point3D maxCorner, Block block, int metadata) {
        int y;
        int z;
        int x;
        int minX = minCorner.getX() + offset.getX();
        int minY = minCorner.getY() + offset.getY();
        int minZ = minCorner.getZ() + offset.getZ();
        int maxX = maxCorner.getX() + offset.getX();
        int maxY = maxCorner.getY() + offset.getY();
        int maxZ = maxCorner.getZ() + offset.getZ();
        for (x = minX; x <= maxX; ++x) {
            for (z = minZ; z <= maxZ; ++z) {
                MazeBuilder.setBlockDirectly(world, x, minY, z, block, metadata);
                MazeBuilder.setBlockDirectly(world, x, maxY, z, block, metadata);
            }
        }
        for (x = minX; x <= maxX; ++x) {
            for (y = minY; y <= maxY; ++y) {
                MazeBuilder.setBlockDirectly(world, x, y, minZ, block, metadata);
                MazeBuilder.setBlockDirectly(world, x, y, maxZ, block, metadata);
            }
        }
        for (z = minZ; z <= maxZ; ++z) {
            for (y = minY; y <= maxY; ++y) {
                MazeBuilder.setBlockDirectly(world, minX, y, z, block, metadata);
                MazeBuilder.setBlockDirectly(world, maxX, y, z, block, metadata);
            }
        }
    }

    private static void setBlockDirectly(World world, int x, int y, int z, Block block, int metadata) {
        int cX = x >> 4;
        int cZ = z >> 4;
        int cY = y >> 4;
        int localX = x % 16 < 0 ? x % 16 + 16 : x % 16;
        int localZ = z % 16 < 0 ? z % 16 + 16 : z % 16;
        Chunk chunk = world.func_72964_e(cX, cZ);
        ExtendedBlockStorage extBlockStorage = chunk.func_76587_i()[cY];
        if (extBlockStorage == null) {
            chunk.func_76587_i()[cY] = extBlockStorage = new ExtendedBlockStorage(cY << 4, !world.field_73011_w.field_76576_e);
        }
        extBlockStorage.func_150818_a(localX, y & 0xF, localZ, block);
        extBlockStorage.func_76654_b(localX, y & 0xF, localZ, metadata);
        chunk.func_76630_e();
    }
}

