/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.experimental;

import StevenDimDoors.experimental.ILinkedListNode;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LinkedList<T>
implements Iterable<T> {
    private Node<T> header = new Node<Object>(null, null, null, this);
    private Node<T> trailer = new Node<Object>(null, null, null, this);
    private int size = 0;

    public LinkedList() {
        ((Node)this.header).next = (Node)this.trailer;
        ((Node)this.trailer).prev = (Node)this.header;
    }

    public ILinkedListNode<T> header() {
        return this.header;
    }

    public ILinkedListNode<T> trailer() {
        return this.trailer;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.size = 0;
        Node current = ((Node)this.header).next;
        while (current != this.trailer) {
            Node next = current.next;
            current.clear();
            current = next;
        }
        ((Node)this.header).next = (Node)this.trailer;
        ((Node)this.trailer).prev = (Node)this.header;
    }

    private Node<T> checkNode(ILinkedListNode<T> node) {
        Node innerNode = (Node)node;
        if (innerNode.owner() != this) {
            throw new IllegalArgumentException("The specified node does not belong to this list.");
        }
        return innerNode;
    }

    public ILinkedListNode<T> addFirst(T data) {
        return this.addAfter(this.header, data);
    }

    public ILinkedListNode<T> addLast(T data) {
        return this.addBefore(this.trailer, data);
    }

    public ILinkedListNode<T> addBefore(ILinkedListNode<T> node, T data) {
        if (node == this.header) {
            throw new IllegalArgumentException("Cannot add a node before the header node.");
        }
        return this.addAfter(((Node)this.checkNode(node)).prev, data);
    }

    public ILinkedListNode<T> addAfter(ILinkedListNode<T> node, T data) {
        if (node == this.trailer) {
            throw new IllegalArgumentException("Cannot add a node after the trailer node.");
        }
        return this.addAfter(this.checkNode(node), data);
    }

    private Node<T> addAfter(Node<T> node, T data) {
        Node<T> addition = new Node<T>(node, ((Node)node).next, data, this);
        ((Node)node).next = (Node)addition;
        ((Node)addition).next.prev = (Node)addition;
        ++this.size;
        return addition;
    }

    @Override
    public Iterator<T> iterator() {
        return new LinkedListIterator(this);
    }

    private static class LinkedListIterator<P>
    implements Iterator<P> {
        private Node<P> current;
        private Node<P> trailer;

        public LinkedListIterator(LinkedList<P> list) {
            this.current = ((LinkedList)list).header.next;
            this.trailer = ((LinkedList)list).trailer;
        }

        @Override
        public boolean hasNext() {
            return this.current != this.trailer;
        }

        @Override
        public P next() {
            if (this.current == this.trailer) {
                throw new NoSuchElementException();
            }
            Object result = ((Node)this.current).data;
            this.current = ((Node)this.current).next;
            return (P)result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Node<P>
    implements ILinkedListNode<P> {
        private Node<P> next;
        private Node<P> prev;
        private P data;
        private LinkedList<P> owner;

        public Node(Node<P> prev, Node<P> next, P data, LinkedList<P> owner) {
            this.prev = prev;
            this.next = next;
            this.data = data;
            this.owner = owner;
        }

        @Override
        public ILinkedListNode<P> next() {
            return this.next;
        }

        @Override
        public ILinkedListNode<P> prev() {
            return this.prev;
        }

        @Override
        public P data() {
            return this.data;
        }

        @Override
        public void setData(P data) {
            if (this == ((LinkedList)this.owner).header || this == ((LinkedList)this.owner).trailer) {
                throw new IllegalStateException("Cannot set data for the header and trailer nodes of a list.");
            }
            this.data = data;
        }

        @Override
        public LinkedList<P> owner() {
            return this.owner;
        }

        @Override
        public P remove() {
            if (this == ((LinkedList)this.owner).header || this == ((LinkedList)this.owner).trailer) {
                throw new IllegalStateException("Cannot remove the header and trailer nodes of a list.");
            }
            P data = this.data;
            this.prev.next = this.next;
            this.next.prev = this.prev;
            ((LinkedList)this.owner).size--;
            this.clear();
            return data;
        }

        public void clear() {
            this.data = null;
            this.prev = null;
            this.next = null;
            this.owner = null;
        }
    }
}

