/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.experimental;

import java.util.HashMap;

public class DisjointSet<T> {
    private HashMap<T, SetNode<T>> mapping;

    public DisjointSet(int initialCapacity) {
        this.mapping = new HashMap(initialCapacity);
    }

    public boolean makeSet(T element) {
        if (!this.mapping.containsKey(element)) {
            this.mapping.put(element, new SetNode<T>(element));
            return true;
        }
        return false;
    }

    private SetNode<T> findRootNode(T element) {
        SetNode<T> node = this.mapping.get(element);
        if (node == null) {
            return null;
        }
        if (((SetNode)node).parent != null) {
            ((SetNode)node).parent = (SetNode)this.findRootNode(((SetNode)node).parent);
            return ((SetNode)node).parent;
        }
        return node;
    }

    private SetNode<T> findRootNode(SetNode<T> node) {
        if (((SetNode)node).parent != null) {
            ((SetNode)node).parent = (SetNode)this.findRootNode(((SetNode)node).parent);
            return ((SetNode)node).parent;
        }
        return node;
    }

    public boolean mergeSets(T first, T second) {
        SetNode<T> firstRoot = this.findRootNode(first);
        SetNode<T> secondRoot = this.findRootNode(second);
        if (firstRoot == null || secondRoot == null || firstRoot == secondRoot) {
            return false;
        }
        if (((SetNode)firstRoot).rank < ((SetNode)secondRoot).rank) {
            ((SetNode)firstRoot).parent = (SetNode)secondRoot;
        } else if (((SetNode)firstRoot).rank > ((SetNode)secondRoot).rank) {
            ((SetNode)secondRoot).parent = (SetNode)firstRoot;
        } else {
            ((SetNode)secondRoot).parent = (SetNode)firstRoot;
            ((SetNode)firstRoot).rank++;
        }
        return true;
    }

    public T find(T element) {
        SetNode<T> root = this.findRootNode(element);
        if (root != null) {
            return (T)((SetNode)root).data;
        }
        return null;
    }

    public boolean haveSameSet(T first, T second) {
        SetNode<T> firstRoot = this.findRootNode(first);
        SetNode<T> secondRoot = this.findRootNode(second);
        if (firstRoot == null || secondRoot == null) {
            return false;
        }
        return firstRoot == secondRoot;
    }

    public void clear() {
        this.mapping.clear();
    }

    private static class SetNode<P> {
        private int rank;
        private SetNode<P> parent;
        private P data;

        public SetNode(P data) {
            this.data = data;
            this.rank = 0;
            this.parent = null;
        }
    }
}

