/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.experimental;

import StevenDimDoors.experimental.IEdge;
import StevenDimDoors.experimental.IGraphNode;
import StevenDimDoors.experimental.ILinkedListNode;
import StevenDimDoors.experimental.LinkedList;

public class DirectedGraph<U, V> {
    private LinkedList<GraphNode<U, V>> nodes = new LinkedList();
    private LinkedList<Edge<U, V>> edges = new LinkedList();

    public int nodeCount() {
        return this.nodes.size();
    }

    public int edgeCount() {
        return this.edges.size();
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public Iterable<? extends IGraphNode<U, V>> nodes() {
        return this.nodes;
    }

    public Iterable<? extends IEdge<U, V>> edges() {
        return this.edges;
    }

    private GraphNode<U, V> checkNode(IGraphNode<U, V> node) {
        GraphNode innerNode = (GraphNode)node;
        if (innerNode.graphEntry.owner() != this.nodes) {
            throw new IllegalArgumentException("The specified node does not belong to this graph.");
        }
        return innerNode;
    }

    private Edge<U, V> checkEdge(IEdge<U, V> edge) {
        Edge innerEdge = (Edge)edge;
        if (innerEdge.graphEntry.owner() != this.edges) {
            throw new IllegalArgumentException("The specified edge does not belong to this graph.");
        }
        return innerEdge;
    }

    public IGraphNode<U, V> addNode(U data) {
        return new GraphNode(data, this.nodes);
    }

    public IEdge<U, V> addEdge(IGraphNode<U, V> head, IGraphNode<U, V> tail, V data) {
        GraphNode<U, V> innerHead = this.checkNode(head);
        GraphNode<U, V> innerTail = this.checkNode(tail);
        return new Edge<U, V>(innerHead, innerTail, data, this.edges);
    }

    public U removeNode(IGraphNode<U, V> node) {
        GraphNode<U, V> innerNode = this.checkNode(node);
        U data = innerNode.data();
        innerNode.remove();
        return data;
    }

    public V removeEdge(IEdge<U, V> edge) {
        Edge<U, V> innerEdge = this.checkEdge(edge);
        V data = innerEdge.data();
        innerEdge.remove();
        return data;
    }

    public IEdge<U, V> findEdge(IGraphNode<U, V> head, IGraphNode<U, V> tail) {
        for (IEdge<U, V> edge : head.outbound()) {
            if (edge.tail() != tail) continue;
            return edge;
        }
        return null;
    }

    public void clear() {
        for (GraphNode<U, V> node : this.nodes) {
            node.remove();
        }
    }

    private static class Edge<P, Q>
    implements IEdge<P, Q> {
        private GraphNode<P, Q> head;
        private GraphNode<P, Q> tail;
        private ILinkedListNode<Edge<P, Q>> headEntry;
        private ILinkedListNode<Edge<P, Q>> tailEntry;
        private ILinkedListNode<Edge<P, Q>> graphEntry;
        private Q data;

        public Edge(GraphNode<P, Q> head, GraphNode<P, Q> tail, Q data, LinkedList<Edge<P, Q>> graphList) {
            this.head = head;
            this.tail = tail;
            this.data = data;
            this.graphEntry = graphList.addLast(this);
            this.headEntry = ((GraphNode)head).outbound.addLast(this);
            this.tailEntry = ((GraphNode)tail).inbound.addLast(this);
        }

        @Override
        public IGraphNode<P, Q> head() {
            return this.head;
        }

        @Override
        public IGraphNode<P, Q> tail() {
            return this.tail;
        }

        @Override
        public Q data() {
            return this.data;
        }

        public void remove() {
            this.headEntry.remove();
            this.tailEntry.remove();
            this.graphEntry.remove();
            this.headEntry = null;
            this.tailEntry = null;
            this.graphEntry = null;
            this.head = null;
            this.tail = null;
            this.data = null;
        }
    }

    private static class GraphNode<P, Q>
    implements IGraphNode<P, Q> {
        private LinkedList<Edge<P, Q>> inbound;
        private LinkedList<Edge<P, Q>> outbound;
        private ILinkedListNode<GraphNode<P, Q>> graphEntry;
        private P data;

        public GraphNode(P data, LinkedList<GraphNode<P, Q>> graphList) {
            this.data = data;
            this.inbound = new LinkedList();
            this.outbound = new LinkedList();
            this.graphEntry = graphList.addLast(this);
        }

        @Override
        public int indegree() {
            return this.inbound.size();
        }

        @Override
        public int outdegree() {
            return this.outbound.size();
        }

        @Override
        public Iterable<Edge<P, Q>> inbound() {
            return this.inbound;
        }

        @Override
        public Iterable<Edge<P, Q>> outbound() {
            return this.outbound;
        }

        @Override
        public P data() {
            return this.data;
        }

        public void remove() {
            this.graphEntry.remove();
            this.graphEntry = null;
            for (Edge<P, Q> edge : this.inbound) {
                edge.remove();
            }
            for (Edge<P, Q> edge : this.outbound) {
                edge.remove();
            }
            this.inbound = null;
            this.outbound = null;
            this.data = null;
        }
    }
}

