/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.experimental;

import StevenDimDoors.mod_pocketDim.Point3D;

public class BoundingBox {
    protected Point3D minCorner;
    protected Point3D maxCorner;

    public BoundingBox(int x, int y, int z, int width, int height, int length) {
        this.minCorner = new Point3D(x, y, z);
        this.maxCorner = new Point3D(x + width - 1, y + height - 1, z + length - 1);
    }

    public BoundingBox(Point3D minCorner, Point3D maxCorner) {
        this.minCorner = minCorner;
        this.maxCorner = maxCorner;
    }

    public int width() {
        return this.maxCorner.getX() - this.minCorner.getX() + 1;
    }

    public int height() {
        return this.maxCorner.getY() - this.minCorner.getY() + 1;
    }

    public int length() {
        return this.maxCorner.getZ() - this.minCorner.getZ() + 1;
    }

    public Point3D minCorner() {
        return this.minCorner;
    }

    public Point3D maxCorner() {
        return this.maxCorner;
    }

    public boolean contains(int x, int y, int z) {
        return this.minCorner.getX() <= x && x <= this.maxCorner.getX() && this.minCorner.getY() <= y && y <= this.maxCorner.getY() && this.minCorner.getZ() <= z && z <= this.maxCorner.getZ();
    }

    public boolean intersects(BoundingBox other) {
        boolean xi = this.minCorner.getX() <= other.minCorner.getX() && other.minCorner.getX() <= this.maxCorner.getX() || other.minCorner.getX() <= this.minCorner.getX() && this.minCorner.getX() <= other.maxCorner.getX();
        boolean yi = this.minCorner.getY() <= other.minCorner.getY() && other.minCorner.getY() <= this.maxCorner.getY() || other.minCorner.getY() <= this.minCorner.getY() && this.minCorner.getY() <= other.maxCorner.getY();
        boolean zi = this.minCorner.getZ() <= other.minCorner.getZ() && other.minCorner.getZ() <= this.maxCorner.getZ() || other.minCorner.getZ() <= this.minCorner.getZ() && this.minCorner.getZ() <= other.maxCorner.getZ();
        return xi && yi && zi;
    }
}

