/*
 * Decompiled with CFR 0.152.
 */
package openeye.utils;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import openeye.logic.Sanitizers;

public abstract class NameCollector {
    private static void tryAddPlayer(EntityPlayer player) {
        GameProfile profile = player.func_146103_bH();
        if (profile != null) {
            Sanitizers.mainSanitizer.addPre(200, Sanitizers.replaceNoDuplicates(profile.getId(), "[player id]"));
            Sanitizers.mainSanitizer.addPre(300, Sanitizers.replaceNoDuplicates(profile.getName(), "[player name]"));
        }
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new ForgeHooks());
        FMLCommonHandler.instance().bus().register((Object)new FmlHooks());
    }

    public static class FmlHooks {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent evt) {
            NameCollector.tryAddPlayer(evt.player);
        }
    }

    public static class ForgeHooks {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void onWorldLoad(WorldEvent.Load evt) {
            Sanitizers.addWorldNames(evt.world);
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void onEntityJoin(EntityJoinWorldEvent evt) {
            if (evt.entity instanceof EntityPlayer) {
                NameCollector.tryAddPlayer((EntityPlayer)evt.entity);
            }
        }
    }
}

