/*
 * Decompiled with CFR 0.152.
 */
package openeye.notes.entries;

import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import java.io.File;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import openeye.notes.NoteCategory;
import openeye.notes.entries.NoteEntry;
import openeye.responses.ResponseModMsgAction;

public class MsgNoteEntry
extends NoteEntry {
    private final String description;
    private final String signature;
    private final String payload;

    public MsgNoteEntry(File file, ResponseModMsgAction msg) {
        super(file, MsgNoteEntry.calculateFromLevel(msg.level), msg.level);
        this.signature = msg.signature;
        this.description = msg.description;
        this.payload = msg.payload;
    }

    private static NoteCategory calculateFromLevel(int level) {
        if (level > 64) {
            return NoteCategory.CRITICAL;
        }
        if (level > 32) {
            return NoteCategory.ALERT;
        }
        if (level > 16) {
            return NoteCategory.WARNING;
        }
        return NoteCategory.INFO;
    }

    @Override
    public String url() {
        return null;
    }

    @Override
    public IChatComponent title() {
        return new ChatComponentTranslation("openeye.notes.title.note", new Object[]{this.file.getName()});
    }

    @Override
    public IChatComponent content() {
        return new ChatComponentText(Strings.nullToEmpty((String)this.description));
    }

    @Override
    public JsonObject toJson() {
        JsonObject result = super.toJson();
        result.addProperty("signature", this.signature);
        result.addProperty("payload", this.payload);
        return result;
    }
}

