/*
 * Decompiled with CFR 0.152.
 */
package openeye.logic;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import openeye.logic.Config;

public class TagsCollector {
    private static final String ELEMENT_NAME = "openeye.tags";
    private static final Splitter TAG_SPLITTER = Splitter.on((char)',');
    private Set<String> tags;

    public Set<String> getTags() {
        if (this.tags == null) {
            this.tags = Sets.newHashSet();
            TagsCollector.addBlackboardTags(this.tags);
            TagsCollector.addEnvTags(this.tags);
            TagsCollector.addArgsTags(this.tags);
            TagsCollector.addConfigTags(this.tags);
        }
        return this.tags;
    }

    private static void addConfigTags(Set<String> result) {
        if (Config.tags != null) {
            result.addAll(Config.tags);
        }
    }

    private static void addArgsTags(Set<String> result) {
        Map args = (Map)Launch.blackboard.get("launchArgs");
        String tags = (String)args.get(ELEMENT_NAME);
        if (tags != null) {
            Iterables.addAll(result, (Iterable)TAG_SPLITTER.split((CharSequence)tags));
        }
    }

    private static void addEnvTags(Set<String> result) {
        Map<String, String> env = System.getenv();
        if (env.containsKey(ELEMENT_NAME)) {
            String tags = env.get(ELEMENT_NAME);
            Iterables.addAll(result, (Iterable)TAG_SPLITTER.split((CharSequence)tags));
        }
    }

    private static void addBlackboardTags(Set<String> result) {
        Object tags = Launch.blackboard.get(ELEMENT_NAME);
        if (tags instanceof Set) {
            result.addAll((Set)tags);
        }
    }
}

