/*
 * Decompiled with CFR 0.152.
 */
package openeye.logic;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Set;
import openeye.logic.IContext;
import openeye.logic.ModMetaCollector;
import openeye.protocol.reports.IReport;
import openeye.struct.TypedCollections;

class ReportContext
implements IContext {
    private final ModMetaCollector collector;
    private final TypedCollections.ReportsList result = new TypedCollections.ReportsList();
    private final Set<String> addedFileInfos = Sets.newHashSet();
    private final Set<String> addedFileContents = Sets.newHashSet();
    private final Set<String> unwantedSignatures = Sets.newHashSet();

    public ReportContext(ModMetaCollector collector) {
        this.collector = collector;
    }

    @Override
    public Set<String> getModsForSignature(String signature) {
        return this.collector.getModsForSignature(signature);
    }

    @Override
    public File getFileForSignature(String signature) {
        return this.collector.getContainerForSignature(signature);
    }

    @Override
    public void queueReport(IReport report) {
        this.result.add(report);
    }

    @Override
    public void queueFileReport(String signature) {
        if (!signature.startsWith("special:") && !this.addedFileInfos.contains(signature)) {
            this.result.add(this.collector.generateFileReport(signature));
            this.addedFileInfos.add(signature);
        }
    }

    @Override
    public void queueFileContents(String signature) {
        if (!this.addedFileContents.contains(signature)) {
            this.result.add(this.collector.generateFileContentsReport(signature));
            this.addedFileContents.add(signature);
        }
    }

    @Override
    public void markUnwantedSignature(String signature) {
        this.unwantedSignatures.add(signature);
    }

    public Set<String> dangerousSignatures() {
        return this.unwantedSignatures;
    }

    public TypedCollections.ReportsList reports() {
        return this.result;
    }
}

