/*
 * Decompiled with CFR 0.152.
 */
package openeye.logic;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import java.io.File;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.common.ForgeVersion;
import openeye.Log;
import openeye.Proxy;
import openeye.logic.Bootstrap;
import openeye.logic.ModMetaCollector;
import openeye.logic.Sanitizers;
import openeye.logic.TagsCollector;
import openeye.protocol.reports.ReportAnalytics;
import openeye.protocol.reports.ReportCrash;
import openeye.protocol.reports.ReportEnvironment;
import openeye.protocol.reports.ReportFileContents;
import openeye.protocol.reports.ReportKnownFiles;

public class ReportBuilders {
    private static final TagsCollector TAGS_COLLECTOR = new TagsCollector();
    private static final Random RANDOM = new Random();
    private static final char[] HEX = "0123456789abcdef".toCharArray();

    private static String getSide() {
        return FMLCommonHandler.instance().getSide().toString().toLowerCase(Locale.ENGLISH);
    }

    public static ReportKnownFiles buildKnownFilesReport(ModMetaCollector data) {
        ReportKnownFiles result = new ReportKnownFiles();
        result.signatures = data.getAllFiles();
        return result;
    }

    private static String getJavaVersion() {
        String vendor = Strings.nullToEmpty((String)System.getProperty("java.vendor"));
        String version = Strings.nullToEmpty((String)System.getProperty("java.version"));
        return vendor + " " + version;
    }

    private static Map<String, String> getEnvVersions() {
        ImmutableMap.Builder versions = ImmutableMap.builder();
        versions.put((Object)"mcp", (Object)Loader.instance().getMCPVersionString());
        versions.put((Object)"fml", (Object)Loader.instance().getFMLVersionString());
        versions.put((Object)"forge", (Object)ForgeVersion.getVersion());
        return versions.build();
    }

    private static void fillEnvInfo(ReportEnvironment report) {
        report.branding = FMLCommonHandler.instance().getBrandings(true);
        report.runtime = ReportBuilders.getEnvVersions();
        report.minecraft = Loader.instance().getMCVersionString();
        report.javaVersion = ReportBuilders.getJavaVersion();
        report.side = ReportBuilders.getSide();
        report.obfuscated = Bootstrap.instance.isRuntimeDeobfuscationEnabled();
        Set<String> tags = TAGS_COLLECTOR.getTags();
        if (!tags.isEmpty()) {
            report.tags = tags;
        }
    }

    public static ReportAnalytics buildAnalyticsReport(ModMetaCollector data, Set<String> prevSignatures) {
        ReportAnalytics analytics = new ReportAnalytics();
        ReportBuilders.fillEnvInfo(analytics);
        String language = Proxy.instance().getLanguage();
        analytics.language = Strings.isNullOrEmpty((String)language) ? "invalid" : language;
        analytics.locale = Locale.getDefault().toString();
        TimeZone tz = Calendar.getInstance().getTimeZone();
        analytics.timezone = tz.getID();
        analytics.workTime = (float)data.getCollectingDuration() / 1000.0f;
        analytics.signatures = data.getAllFiles();
        Set<String> currentSignatures = data.getAllSignatures();
        analytics.installedSignatures = Sets.difference(currentSignatures, prevSignatures);
        analytics.uninstalledSignatures = Sets.difference(prevSignatures, currentSignatures);
        return analytics;
    }

    private static ReportCrash.StackTrace createStackTraceElement(StackTraceElement e, ModMetaCollector collector) {
        ModMetaCollector.ClassSource source;
        String clsName;
        ReportCrash.StackTrace el = new ReportCrash.StackTrace();
        el.className = clsName = e.getClassName();
        el.fileName = e.getFileName();
        el.methodName = e.getMethodName();
        el.lineNumber = e.getLineNumber();
        if (collector != null && (source = collector.identifyClassSource(clsName)) != null) {
            el.signatures = source.containingClasses;
            if (source.loadedFrom != null) {
                el.source = source.loadedFrom;
                el.signatures.add(source.loadedFrom);
            }
        }
        return el;
    }

    private static ReportCrash.ExceptionInfo createStackTrace(Throwable throwable, StackTraceElement[] prevStacktrace, Set<Throwable> alreadySerialized, ModMetaCollector collector) {
        if (alreadySerialized.contains(throwable)) {
            return null;
        }
        ReportCrash.ExceptionInfo info = new ReportCrash.ExceptionInfo();
        info.exceptionCls = throwable.getClass().getName();
        info.message = Sanitizers.getSanitizerForThrowable(throwable.getClass()).sanitize(throwable.getMessage());
        alreadySerialized.add(throwable);
        info.stackTrace = Lists.newArrayList();
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        int m = stackTrace.length - 1;
        for (int n = prevStacktrace.length - 1; m >= 0 && n >= 0 && stackTrace[m].equals(prevStacktrace[n]); --m, --n) {
        }
        for (int i = 0; i <= m; ++i) {
            info.stackTrace.add(ReportBuilders.createStackTraceElement(stackTrace[i], collector));
        }
        Throwable cause = throwable.getCause();
        if (cause != null) {
            info.cause = ReportBuilders.createStackTrace(cause, stackTrace, alreadySerialized, collector);
        }
        return info;
    }

    public static ReportCrash buildCrashReport(Throwable throwable, String location, ModMetaCollector collector) {
        ReportCrash crash = new ReportCrash();
        ReportBuilders.fillEnvInfo(crash);
        crash.timestamp = new Date().getTime();
        crash.location = location;
        Set blacklist = Sets.newSetFromMap(new IdentityHashMap());
        crash.exception = ReportBuilders.createStackTrace(throwable, new StackTraceElement[0], blacklist, collector);
        if (collector != null) {
            crash.states = collector.collectStates();
        }
        crash.random = RANDOM.nextInt();
        crash.resolved = collector != null;
        return crash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillFileContents(File container, ReportFileContents report) {
        try {
            ZipFile jarFile = new ZipFile(container);
            ArrayList dirs = Lists.newArrayList();
            ArrayList files = Lists.newArrayList();
            try {
                Enumeration<? extends ZipEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    ReportFileContents.ArchiveEntry resultEntry;
                    ZipEntry zipEntry = entries.nextElement();
                    if (zipEntry.isDirectory()) {
                        resultEntry = new ReportFileContents.ArchiveDirEntry();
                        ReportBuilders.fillCommonFields(zipEntry, resultEntry);
                        dirs.add(resultEntry);
                        continue;
                    }
                    resultEntry = new ReportFileContents.ArchiveFileEntry();
                    ReportBuilders.fillCommonFields(zipEntry, resultEntry);
                    ((ReportFileContents.ArchiveFileEntry)resultEntry).size = zipEntry.getSize();
                    ((ReportFileContents.ArchiveFileEntry)resultEntry).crc = Long.toHexString(zipEntry.getCrc());
                    ((ReportFileContents.ArchiveFileEntry)resultEntry).signature = ReportBuilders.createSignature(jarFile.getInputStream(zipEntry));
                    files.add(resultEntry);
                }
            }
            finally {
                jarFile.close();
            }
            report.dirs = dirs;
            report.files = files;
        }
        catch (Exception e) {
            Log.warn(e, "Failed to get contents of file %s", container);
        }
    }

    private static void fillCommonFields(ZipEntry zipEntry, ReportFileContents.ArchiveEntry resultEntry) {
        resultEntry.filename = zipEntry.getName();
        resultEntry.timestamp = zipEntry.getTime();
        resultEntry.comment = zipEntry.getComment();
    }

    private static String createSignature(InputStream is) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        DigestInputStream dis = new DigestInputStream(is, md);
        byte[] buffer = new byte[1024];
        while (dis.read(buffer) != -1) {
        }
        dis.close();
        byte[] digest = md.digest();
        return "sha256:" + ReportBuilders.bytesToHex(digest);
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            sb.append(HEX[b >> 4 & 0xF]).append(HEX[b & 0xF]);
        }
        return sb.toString();
    }
}

