/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.node;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.LinkedHashMap;
import java.util.Map;
import makeo.gadomancy.common.blocks.tiles.TileExtendedNode;
import makeo.gadomancy.common.network.PacketHandler;
import makeo.gadomancy.common.network.packets.PacketAnimationAbsorb;
import makeo.gadomancy.common.network.packets.PacketTCNodeBolt;
import makeo.gadomancy.common.registration.RegisteredBlocks;
import makeo.gadomancy.common.utils.ResearchHelper;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.entities.EntityAspectOrb;
import thaumcraft.common.tiles.TileNode;

public class GrowingNodeBehavior {
    public static final double SATURATION_DIFFICULTY = 15.0;
    public static final double SATURATION_CAP = 110.0;
    public static final int HAPPINESS_CAP = 400;
    private TileNode fixedNode;
    private final TileExtendedNode owningNode;
    private double overallHappiness = 0.0;
    private Map<Aspect, Double> aspectSaturation = new LinkedHashMap<Aspect, Double>();
    private Aspect lastFedAspect = null;
    private int lastFedRow = 0;
    private boolean isSaturated = false;

    public GrowingNodeBehavior(TileExtendedNode owningNode) {
        this.owningNode = owningNode;
    }

    public void addAspect(AspectType type, Aspect aspect, int value) {
        if (this.isSaturated) {
            return;
        }
        double increasedSaturation = this.getSaturation(type, aspect);
        this.addSaturation(aspect, increasedSaturation);
        this.owningNode.getAspectsBase().add(aspect, value);
        ResearchHelper.distributeResearch("gadomancy".toUpperCase() + ".GROWING_GROWTH", this.owningNode.func_145831_w(), this.owningNode.field_145851_c, this.owningNode.field_145848_d, this.owningNode.field_145849_e, 6.0);
        this.computeOverallSaturation();
    }

    private void computeOverallSaturation() {
        if (this.isSaturated) {
            return;
        }
        double completeSaturation = 0.0;
        int aspects = this.aspectSaturation.keySet().size();
        for (Aspect a : this.aspectSaturation.keySet()) {
            completeSaturation += this.aspectSaturation.get(a).doubleValue();
        }
        double percentSaturation = completeSaturation / (double)aspects;
        double satCmp = 110.0;
        satCmp *= 8.5;
        satCmp /= 10.0;
        if (this.overallHappiness > 400.0) {
            this.overallHappiness /= 10.0;
            this.owningNode.triggerVortexExplosion();
        }
        if (percentSaturation > satCmp) {
            this.isSaturated = true;
        }
    }

    public boolean mayZapNow() {
        return this.overallHappiness > (double)this.owningNode.func_145831_w().field_73012_v.nextInt(160000);
    }

    public float getZapDamage() {
        float happinessPerc = (float)this.overallHappiness / 400.0f;
        return (double)happinessPerc > 0.3 ? ((double)happinessPerc > 0.6 ? ((double)happinessPerc > 0.9 ? 12.0f : 8.0f) : 5.0f) : 2.0f;
    }

    private void addSaturation(Aspect aspect, double increasedSaturation) {
        double overallReduction = 0.06666666666666667;
        if (this.aspectSaturation.containsKey(aspect)) {
            this.aspectSaturation.put(aspect, this.aspectSaturation.get(aspect) + increasedSaturation);
        } else {
            this.aspectSaturation.put(aspect, increasedSaturation);
        }
        for (Aspect a : this.aspectSaturation.keySet()) {
            if (a.equals(aspect)) continue;
            double newSaturation = this.aspectSaturation.get(a) - overallReduction;
            newSaturation = newSaturation < 0.0 ? 0.0 : newSaturation;
            this.aspectSaturation.put(a, newSaturation);
        }
    }

    private double getSaturation(AspectType type, Aspect aspect) {
        double mult = 1.0;
        switch (type) {
            case WISP: {
                mult -= 0.2;
                break;
            }
            case WISP_ESSENCE: {
                mult += 0.2;
                break;
            }
            case ASPECT_ORB: {
                mult -= 0.3;
                break;
            }
            case MANA_BEAN: 
            case CRYSTAL_ESSENCE: {
                mult += 0.4;
            }
        }
        if (this.lastFedAspect != null && this.lastFedAspect.equals(aspect)) {
            mult += 0.4;
            ++this.lastFedRow;
        }
        this.lastFedAspect = aspect;
        double sat = aspect.isPrimal() ? 1.4 : 1.0;
        return sat * mult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean updateBehavior(boolean needUpdate) {
        if (this.fixedNode == null) return needUpdate;
        if (this.owningNode.ticksExisted % 3 != 0) return needUpdate;
        if (this.owningNode.func_145831_w().func_147439_a(this.fixedNode.field_145851_c, this.fixedNode.field_145848_d, this.fixedNode.field_145849_e) != RegisteredBlocks.blockNode || this.owningNode.func_145831_w().func_147438_o(this.fixedNode.field_145851_c, this.fixedNode.field_145848_d, this.fixedNode.field_145849_e) == null || this.fixedNode.func_145837_r()) {
            this.fixedNode = null;
            return needUpdate;
        }
        AspectList currentAspects = this.fixedNode.getAspects();
        AspectList baseAspects = this.fixedNode.getAspectsBase();
        if (baseAspects.getAspects().length == 0) {
            int x = this.fixedNode.field_145851_c;
            int y = this.fixedNode.field_145848_d;
            int z = this.fixedNode.field_145849_e;
            this.removeFixedNode(x, y, z);
            return needUpdate;
        }
        Aspect a = baseAspects.getAspects()[this.owningNode.func_145831_w().field_73012_v.nextInt(baseAspects.getAspects().length)];
        if (baseAspects.getAmount(a) > 0) {
            if (baseAspects.reduce(a, 1)) {
                World world = this.owningNode.func_145831_w();
                int fx = this.fixedNode.field_145851_c;
                int fy = this.fixedNode.field_145848_d;
                int fz = this.fixedNode.field_145849_e;
                int ox = this.owningNode.field_145851_c;
                int oy = this.owningNode.field_145848_d;
                int oz = this.owningNode.field_145849_e;
                currentAspects.reduce(a, 1);
                ResearchHelper.distributeResearch("gadomancy".toUpperCase() + ".GROWING_ATTACK", this.owningNode.func_145831_w(), this.owningNode.field_145851_c, this.owningNode.field_145848_d, this.owningNode.field_145849_e, 16.0);
                EntityAspectOrb aspectOrb = new EntityAspectOrb(world, (double)fx + 0.5, (double)fy + 0.5, (double)fz + 0.5, a, 1);
                Vec3 dir = Vec3.func_72443_a((double)((double)fx + 0.5), (double)((double)fy + 0.5), (double)((double)fz + 0.5)).func_72444_a(Vec3.func_72443_a((double)((double)ox + 0.5), (double)((double)oy + 0.5), (double)((double)oz + 0.5))).func_72432_b();
                dir.func_72441_c((double)this.randOffset(), (double)this.randOffset(), (double)this.randOffset()).func_72432_b();
                aspectOrb.field_70159_w = dir.field_72450_a;
                aspectOrb.field_70181_x = dir.field_72448_b;
                aspectOrb.field_70179_y = dir.field_72449_c;
                this.fixedNode.func_145831_w().func_72838_d((Entity)aspectOrb);
                NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)((float)ox + 0.5f), (double)((float)oy + 0.5f), (double)((float)oz + 0.5f), 32.0);
                PacketTCNodeBolt bolt = new PacketTCNodeBolt((float)ox + 0.5f, (float)oy + 0.5f, (float)oz + 0.5f, (float)fx + 0.5f, (float)fy + 0.5f, (float)fz + 0.5f, 0, false);
                PacketHandler.INSTANCE.sendToAllAround((IMessage)bolt, point);
                PacketAnimationAbsorb packet = new PacketAnimationAbsorb(ox, oy, oz, fx, fy, fz, 7);
                PacketHandler.INSTANCE.sendToAllAround((IMessage)packet, point);
                world.func_147471_g(fx, fy, fz);
                this.fixedNode.func_70296_d();
                return true;
            }
            if (baseAspects.size() <= 1) {
                int x = this.fixedNode.field_145851_c;
                int y = this.fixedNode.field_145848_d;
                int z = this.fixedNode.field_145849_e;
                this.removeFixedNode(x, y, z);
                needUpdate = true;
            }
            baseAspects.remove(a);
            currentAspects.remove(a);
            return needUpdate;
        }
        if (baseAspects.size() <= 1) {
            int x = this.fixedNode.field_145851_c;
            int y = this.fixedNode.field_145848_d;
            int z = this.fixedNode.field_145849_e;
            this.removeFixedNode(x, y, z);
            needUpdate = true;
        }
        baseAspects.remove(a);
        currentAspects.remove(a);
        return needUpdate;
    }

    private void removeFixedNode(int x, int y, int z) {
        this.owningNode.func_145831_w().func_147468_f(x, y, z);
        this.owningNode.func_145831_w().func_147475_p(x, y, z);
        this.owningNode.func_145831_w().func_147471_g(x, y, z);
        this.fixedNode = null;
    }

    private float randOffset() {
        return this.owningNode.func_145831_w().field_73012_v.nextFloat() / 3.0f;
    }

    public boolean doesAccept(Aspect aspect) {
        if (this.isSaturated) {
            this.handleOverfeed();
            return false;
        }
        if (this.aspectSaturation.containsKey(aspect)) {
            boolean mayAdd;
            double percentageToSaturation = this.aspectSaturation.get(aspect) / 110.0;
            boolean bl = mayAdd = (double)this.owningNode.func_145831_w().field_73012_v.nextFloat() > percentageToSaturation;
            if (mayAdd) {
                double inc = 1.0 / (1.0 - percentageToSaturation);
                if (this.lastFedAspect != null) {
                    if (aspect.equals(this.lastFedAspect)) {
                        inc *= this.evaluateFeedingDenialFunc(this.lastFedRow > 0 ? this.lastFedRow : 1);
                    } else {
                        inc *= -10.0;
                        this.lastFedRow = 0;
                    }
                }
                this.overallHappiness += inc;
                if (this.overallHappiness < 0.0) {
                    this.overallHappiness = 0.0;
                }
            }
            return mayAdd;
        }
        this.overallHappiness /= 15.0;
        return true;
    }

    private double evaluateFeedingDenialFunc(double i) {
        return Math.log(i) / 6.0 + 1.0;
    }

    private void handleOverfeed() {
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        this.isSaturated = nbtTagCompound.func_74767_n("overallSaturated");
        this.overallHappiness = nbtTagCompound.func_74769_h("overallHappiness");
        if (nbtTagCompound.func_74764_b("lastFed")) {
            this.lastFedAspect = Aspect.getAspect((String)nbtTagCompound.func_74779_i("lastFedAspect"));
            this.lastFedRow = nbtTagCompound.func_74762_e("lastFedRow");
        }
        NBTTagList list = nbtTagCompound.func_150295_c("saturationValues", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound aspectCompound = list.func_150305_b(i);
            String name = aspectCompound.func_74779_i("aspectName");
            double saturation = aspectCompound.func_74769_h("aspectSaturation");
            Aspect a = Aspect.getAspect((String)name);
            if (a == null) continue;
            this.aspectSaturation.put(a, saturation);
        }
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74757_a("overallSaturated", this.isSaturated);
        nbtTagCompound.func_74780_a("overallHappiness", this.overallHappiness);
        if (this.lastFedAspect != null) {
            nbtTagCompound.func_74778_a("lastFedAspect", this.lastFedAspect.getTag());
            nbtTagCompound.func_74768_a("lastFedRow", this.lastFedRow);
        }
        NBTTagList list = new NBTTagList();
        for (Aspect a : this.aspectSaturation.keySet()) {
            double saturation = this.aspectSaturation.get(a);
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("aspectName", a.getTag());
            compound.func_74780_a("aspectSaturation", saturation);
            list.func_74742_a((NBTBase)compound);
        }
        nbtTagCompound.func_74782_a("saturationValues", (NBTBase)list);
    }

    public boolean lookingForNode() {
        return this.fixedNode == null;
    }

    public void lockOnTo(TileNode node) {
        if (this.fixedNode == null) {
            this.fixedNode = node;
        }
    }

    public static enum AspectType {
        WISP,
        WISP_ESSENCE,
        ASPECT_ORB,
        MANA_BEAN,
        CRYSTAL_ESSENCE;

    }
}

