/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.familiar;

import baubles.api.BaublesApi;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import makeo.gadomancy.common.familiar.FamiliarAugment;
import makeo.gadomancy.common.items.baubles.ItemEtherealFamiliar;
import makeo.gadomancy.common.network.PacketHandler;
import makeo.gadomancy.common.network.packets.PacketFamiliarBolt;
import makeo.gadomancy.common.utils.MiscUtils;
import makeo.gadomancy.common.utils.Vector3;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.config.Config;
import thaumcraft.common.items.baubles.ItemAmuletVis;
import thaumcraft.common.items.wands.ItemWandCasting;

public class FamiliarController {
    public static final double RANGE_DEF = 6.0;
    public static final int AS_DELAY_DEF = 32;
    public static final double DMG_DEF = 1.0;
    public static final double RANGE_INC = 1.8;
    public static final int AS_INC = 6;
    public static final double DMG_INC = 1.1;
    public static final double SHOCK_DMG_INC = 0.8;
    public static final double FIRE_DMG_INC = 0.5;
    public static final double POISON_RANGE_INC = 0.6;
    public static final double WEAKNESS_DMG_DEC = 0.3;
    private static final Random RAND = new Random();
    private int tickLastEffect = 0;
    private final EntityPlayer owningPlayer;

    public FamiliarController(EntityPlayer owner) {
        this.owningPlayer = owner;
    }

    public void tick() {
        IInventory baubles = BaublesApi.getBaubles((EntityPlayer)this.owningPlayer);
        ItemStack stack = baubles.func_70301_a(0);
        if (stack == null || !(stack.func_77973_b() instanceof ItemEtherealFamiliar)) {
            return;
        }
        if (this.tickLastEffect > 0) {
            --this.tickLastEffect;
            return;
        }
        FamiliarAugment.FamiliarAugmentList augments = ItemEtherealFamiliar.getAugments(stack);
        if (augments == null) {
            return;
        }
        if (augments.isEmpty()) {
            this.doDefaultAttack();
            this.tickLastEffect = 32;
        } else {
            int rangeLevel;
            int attackSpeedLevel;
            FamiliarAugment.FamiliarAugmentPair effectElement = null;
            for (FamiliarAugment.FamiliarAugmentPair pair : augments) {
                FamiliarAugment augment = pair.augment;
                if (!augment.equals(FamiliarAugment.SHOCK) && !augment.equals(FamiliarAugment.FIRE) && !augment.equals(FamiliarAugment.POISON) && !augment.equals(FamiliarAugment.WEAKNESS)) continue;
                effectElement = pair;
                break;
            }
            AspectList costs = new AspectList();
            int dmgLevel = augments.getLevel(FamiliarAugment.DAMAGE_INCREASE);
            if (dmgLevel > 0) {
                for (int i = 0; i < dmgLevel; ++i) {
                    costs.add(FamiliarAugment.DAMAGE_INCREASE.getCostsPerLevel());
                }
            }
            if ((attackSpeedLevel = augments.getLevel(FamiliarAugment.ATTACK_SPEED)) > 0) {
                for (int i = 0; i < attackSpeedLevel; ++i) {
                    costs.add(FamiliarAugment.ATTACK_SPEED.getCostsPerLevel());
                }
            }
            if ((rangeLevel = augments.getLevel(FamiliarAugment.RANGE_INCREASE)) > 0) {
                for (int i = 0; i < rangeLevel; ++i) {
                    costs.add(FamiliarAugment.RANGE_INCREASE.getCostsPerLevel());
                }
            }
            double damage = 1.0 + (dmgLevel != -1 ? 1.1 * (double)dmgLevel : 0.0);
            int ticksUntilNextAttack = 32 - (attackSpeedLevel != -1 ? 6 * attackSpeedLevel : 0);
            double range = 6.0 + (rangeLevel != -1 ? 1.8 * (double)rangeLevel : 0.0);
            if (effectElement != null) {
                for (int i = 0; i < effectElement.level; ++i) {
                    costs.add(effectElement.augment.getCostsPerLevel());
                }
            }
            if (!this.owningPlayer.field_71075_bZ.field_75098_d && !FamiliarController.consumeVisFromInventory(this.owningPlayer, costs, false)) {
                return;
            }
            if (effectElement == null) {
                if (this.doEnhancedDefaultAttack(damage, range)) {
                    this.tickLastEffect = ticksUntilNextAttack;
                    if (!this.owningPlayer.field_71075_bZ.field_75098_d && RAND.nextInt(3) == 0) {
                        FamiliarController.consumeVisFromInventory(this.owningPlayer, costs, true);
                    }
                }
            } else if (this.doAttack(effectElement, damage, range)) {
                this.tickLastEffect = ticksUntilNextAttack;
                if (!this.owningPlayer.field_71075_bZ.field_75098_d && RAND.nextInt(3) == 0) {
                    FamiliarController.consumeVisFromInventory(this.owningPlayer, costs, true);
                }
            }
        }
    }

    private boolean doAttack(FamiliarAugment.FamiliarAugmentPair element, double damage, double range) {
        block19: {
            List<EntityLivingBase> toAttack;
            FamiliarAugment augment;
            int effectLevel;
            block21: {
                block20: {
                    block18: {
                        int toSelect = 1;
                        effectLevel = element.level;
                        augment = element.augment;
                        int boltType = 6;
                        if (augment.equals(FamiliarAugment.SHOCK)) {
                            boltType = 1;
                            damage += (double)effectLevel * 0.8;
                        } else if (augment.equals(FamiliarAugment.FIRE)) {
                            boltType = 4;
                            damage += (double)effectLevel * 0.5;
                        } else if (augment.equals(FamiliarAugment.POISON)) {
                            boltType = 3;
                            range += (double)effectLevel * 0.6;
                        } else if (augment.equals(FamiliarAugment.WEAKNESS)) {
                            boltType = 5;
                            damage -= (double)effectLevel * 0.3;
                            if (effectLevel == 3) {
                                toSelect = 3;
                            }
                        }
                        toAttack = this.selectEntityToAttack(range, toSelect);
                        if (toAttack == null || toAttack.isEmpty()) {
                            return false;
                        }
                        for (EntityLivingBase entity : toAttack) {
                            this.attack(entity, damage, boltType);
                        }
                        if (!augment.equals(FamiliarAugment.SHOCK)) break block18;
                        for (EntityLivingBase entity : toAttack) {
                            if (!RAND.nextBoolean()) continue;
                            Vector3 vel = MiscUtils.getPositionVector((Entity)entity).subtract(MiscUtils.getPositionVector((Entity)this.owningPlayer)).normalize().divide(2.0).multiply(0.8 * (double)effectLevel);
                            if (vel.getY() < 0.0) {
                                vel.setY(-vel.getY());
                            }
                            entity.field_70159_w += vel.getX();
                            entity.field_70181_x += vel.getY();
                            entity.field_70179_y += vel.getZ();
                        }
                        break block19;
                    }
                    if (!augment.equals(FamiliarAugment.FIRE)) break block20;
                    int fireDur = 14;
                    for (int i = 0; i < effectLevel; ++i) {
                        fireDur *= 2;
                    }
                    for (EntityLivingBase entity : toAttack) {
                        entity.func_70015_d(fireDur);
                        if (effectLevel != 3) continue;
                        entity.func_70690_d(new PotionEffect(Config.potionSunScornedID, MiscUtils.ticksForMinutes(1), 2));
                    }
                    break block19;
                }
                if (!augment.equals(FamiliarAugment.POISON)) break block21;
                int potionLvl = 0;
                if (effectLevel > 1) {
                    ++potionLvl;
                }
                for (EntityLivingBase entity : toAttack) {
                    entity.func_70690_d(new PotionEffect(Potion.field_76436_u.func_76396_c(), MiscUtils.ticksForSeconds(30), potionLvl));
                    if (effectLevel != 3) continue;
                    entity.func_70690_d(new PotionEffect(Potion.field_76438_s.func_76396_c(), MiscUtils.ticksForMinutes(2), 3));
                }
                break block19;
            }
            if (!augment.equals(FamiliarAugment.WEAKNESS)) break block19;
            int potionLvl = 0;
            if (effectLevel == 3) {
                ++potionLvl;
            }
            int dur = MiscUtils.ticksForSeconds(30);
            for (EntityLivingBase entity : toAttack) {
                entity.func_70690_d(new PotionEffect(Potion.field_76437_t.func_76396_c(), dur, potionLvl));
                entity.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), dur, potionLvl));
            }
        }
        return true;
    }

    public static boolean consumeVisFromInventory(EntityPlayer player, AspectList cost, boolean doit) {
        int a;
        IInventory baubles = BaublesApi.getBaubles((EntityPlayer)player);
        for (a = 0; a < 4; ++a) {
            boolean done;
            if (baubles.func_70301_a(a) == null || !(baubles.func_70301_a(a).func_77973_b() instanceof ItemAmuletVis) || !(done = ((ItemAmuletVis)baubles.func_70301_a(a).func_77973_b()).consumeAllVis(baubles.func_70301_a(a), player, cost, doit, true))) continue;
            return true;
        }
        for (a = player.field_71071_by.field_70462_a.length - 1; a >= 0; --a) {
            boolean done;
            ItemStack item = player.field_71071_by.field_70462_a[a];
            if (item == null || !(item.func_77973_b() instanceof ItemWandCasting) || !(done = ((ItemWandCasting)item.func_77973_b()).consumeAllVis(item, player, cost, doit, true))) continue;
            return true;
        }
        return false;
    }

    private boolean doEnhancedDefaultAttack(double damage, double range) {
        List<EntityLivingBase> toAttack = this.selectEntityToAttack(range, 1);
        if (toAttack == null || toAttack.isEmpty()) {
            return false;
        }
        this.attack(toAttack.get(0), damage, 6);
        return true;
    }

    private boolean doDefaultAttack() {
        List<EntityLivingBase> toAttack = this.selectEntityToAttack(6.0, 1);
        if (toAttack == null || toAttack.isEmpty()) {
            return false;
        }
        this.attack(toAttack.get(0), 1.0, 6);
        return true;
    }

    private void attack(EntityLivingBase toAttack, double damage, int boltType) {
        toAttack.func_70097_a(DamageSource.field_76376_m, (float)damage);
        toAttack.field_70170_p.func_72908_a(toAttack.field_70165_t + 0.5, toAttack.field_70163_u + 0.5, toAttack.field_70161_v + 0.5, "thaumcraft:zap", 0.8f, 1.0f);
        PacketFamiliarBolt bolt = new PacketFamiliarBolt(this.owningPlayer.func_70005_c_(), (float)toAttack.field_70165_t, (float)toAttack.field_70163_u, (float)toAttack.field_70161_v, boltType, true);
        PacketHandler.INSTANCE.sendToAllAround((IMessage)bolt, new NetworkRegistry.TargetPoint(toAttack.field_70170_p.field_73011_w.field_76574_g, this.owningPlayer.field_70165_t, this.owningPlayer.field_70163_u, this.owningPlayer.field_70161_v, 16.0));
    }

    private List<EntityLivingBase> selectEntityToAttack(double rad, int amountToSelectMax) {
        List<EntityLivingBase> attackable = this.getAttackableEntities(rad);
        if (attackable.size() <= 0) {
            return null;
        }
        ArrayList<EntityLivingBase> entities = new ArrayList<EntityLivingBase>();
        if (attackable.size() <= amountToSelectMax) {
            entities.addAll(attackable);
        } else {
            for (int i = 0; i < amountToSelectMax; ++i) {
                entities.add(attackable.remove(RAND.nextInt(attackable.size())));
            }
        }
        return entities;
    }

    private List<EntityLivingBase> getAttackableEntities(double rad) {
        double x = this.owningPlayer.field_70165_t;
        double y = this.owningPlayer.field_70163_u;
        double z = this.owningPlayer.field_70161_v;
        List entities = this.owningPlayer.field_70170_p.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(x - 0.5), (double)(y - 0.5), (double)(z - 0.5), (double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5)).func_72314_b(rad, rad, rad));
        Iterator it = entities.iterator();
        while (it.hasNext()) {
            EntityLivingBase base = (EntityLivingBase)it.next();
            if (base != null && !base.field_70128_L && !(base instanceof EntityPlayer) && base instanceof IMob) continue;
            it.remove();
        }
        return entities;
    }
}

