/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.entities;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import makeo.gadomancy.client.effect.EffectHandler;
import makeo.gadomancy.client.effect.fx.EntityFXFlowPolicy;
import makeo.gadomancy.client.effect.fx.FXFlow;
import makeo.gadomancy.client.effect.fx.Orbital;
import makeo.gadomancy.common.data.config.ModConfig;
import makeo.gadomancy.common.items.ItemAuraCore;
import makeo.gadomancy.common.network.PacketHandler;
import makeo.gadomancy.common.network.packets.PacketStartAnimation;
import makeo.gadomancy.common.registration.RegisteredItems;
import makeo.gadomancy.common.utils.MiscUtils;
import makeo.gadomancy.common.utils.PrimalAspectList;
import makeo.gadomancy.common.utils.Vector3;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.ScanResult;
import thaumcraft.common.lib.research.ScanManager;
import thaumcraft.common.lib.utils.BlockUtils;

public class EntityAuraCore
extends EntityItem
implements IEntityAdditionalSpawnData {
    private static final String SPLIT = ";";
    private static final int PRE_GATHER_EFFECT_LENGTH = 50;
    private static final int GATHER_EFFECT_LENGTH = 500;
    private static final int GATHER_RANGE = 4;
    private static final int CLUSTER_WEIGHT = 10;
    public static final int CLUSTER_RANGE = 10;
    private static final int REQUIRED_BLOCKS = (int)Math.round(Math.pow(9.0, 3.0) * 0.15);
    public PrimalAspectList internalAuraList = new PrimalAspectList();
    public Orbital auraOrbital = null;
    private Aspect[] effectAspects = new Aspect[6];
    private Orbital.OrbitalRenderProperties[] effectProperties = new Orbital.OrbitalRenderProperties[6];
    private FXFlow[] flows = new FXFlow[6];
    private String oldAspectDataSent = null;
    public ChunkCoordinates activationLocation = null;
    private int blockCount;
    private List<ChunkCoordinates> markedLocations;

    public EntityAuraCore(World world) {
        super(world);
    }

    public EntityAuraCore(World world, double x, double y, double z, ItemStack stack, ChunkCoordinates startingCoords, Aspect[] aspects) {
        super(world, x, y, z, stack);
        this.activationLocation = startingCoords;
        if (aspects.length == 1) {
            this.internalAuraList.add(aspects[0], 60);
        } else {
            for (Aspect a : aspects) {
                if (a == null) continue;
                this.internalAuraList.add(a, 10);
            }
        }
        this.sendAspectData(this.electParliament());
        this.initGathering();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70096_w().func_82709_a(ModConfig.entityAuraCoreDatawatcherAspectsId, 4);
        this.func_70096_w().func_75692_b(ModConfig.entityAuraCoreDatawatcherAspectsId, (Object)"");
    }

    public void func_70071_h_() {
        block14: {
            int i;
            block15: {
                Orbital.OrbitalRenderProperties node;
                block12: {
                    block13: {
                        super.func_70071_h_();
                        if (this.auraOrbital == null && !MiscUtils.getPositionVector((Entity)this).equals(Vector3.ZERO) && this.field_70170_p.field_72995_K) {
                            this.auraOrbital = new Orbital(MiscUtils.getPositionVector((Entity)this), this.field_70170_p);
                        }
                        if (this.auraOrbital != null && this.field_70170_p.field_72995_K) {
                            if (!this.auraOrbital.registered) {
                                EffectHandler.getInstance().registerOrbital(this.auraOrbital);
                            }
                            this.auraOrbital.updateCenter(MiscUtils.getPositionVector((Entity)this));
                            if (this.field_70173_aa > 50) {
                                int part = this.field_70173_aa - 50;
                                float perc = (500.0f - (float)part) / 500.0f;
                                this.auraOrbital.reduceAllOffsets(perc);
                            }
                        }
                        if (this.field_70292_b + 5 >= this.lifespan) {
                            this.field_70292_b = 0;
                        }
                        if (this.field_70170_p.field_72995_K) break block12;
                        if (this.field_70173_aa <= 500) break block13;
                        this.finishCore();
                        break block14;
                    }
                    if (this.field_70173_aa <= 50) break block14;
                    this.auraGatherCycle();
                    break block14;
                }
                boolean changed = this.recieveAspectData();
                for (i = 0; i < this.effectProperties.length; ++i) {
                    Color c;
                    node = this.effectProperties[i];
                    if (node == null) {
                        if (this.effectAspects[i] == null) continue;
                        node = new Orbital.OrbitalRenderProperties(Orbital.Axis.persisentRandomAxis(), 1.0);
                        node.setColor(new Color(this.effectAspects[i].getColor())).setTicksForFullCircle(120 + this.field_70146_Z.nextInt(40));
                        node.setOffsetTicks(this.field_70146_Z.nextInt(80));
                        c = this.getSubParticleColor(this.effectAspects[i]);
                        node.setSubParticleColor(c);
                        node.setParticleSize(0.1f);
                        node.setSubSizeRunnable(new Orbital.OrbitalSubSizeRunnable(){

                            @Override
                            public float getSubParticleSize(Random rand, int orbitalExisted) {
                                return 0.05f + (rand.nextBoolean() ? 0.0f : 0.025f);
                            }
                        });
                        this.effectProperties[i] = node;
                    }
                    if (this.flows[i] == null && this.field_70173_aa < 50) {
                        Vector3 v = new Vector3((double)this.activationLocation.field_71574_a + 0.5, (double)this.activationLocation.field_71572_b + 0.5, (double)this.activationLocation.field_71573_c + 0.5);
                        this.flows[i] = EffectHandler.getInstance().effectFlow(this.field_70170_p, v, new FXFlow.EntityFlowProperties().setPolicy(EntityFXFlowPolicy.Policies.DEFAULT).setTarget(this.auraOrbital.getOrbitalStartPoints(node)[0]).setColor(new Color(this.effectAspects[i].getColor())).setFading(this.getSubParticleColor(this.effectAspects[i])));
                        this.flows[i].setLivingTicks(50 - this.field_70173_aa);
                    }
                    if (this.flows[i] != null) {
                        this.flows[i].applyTarget(this.auraOrbital.getOrbitalStartPoints(node)[0]);
                    }
                    if (!changed) continue;
                    if (this.effectProperties[i] != null) {
                        this.effectProperties[i].setColor(new Color(this.effectAspects[i].getColor()));
                        c = this.getSubParticleColor(this.effectAspects[i]);
                        node.setSubParticleColor(c);
                    }
                    if (this.flows[i] == null) continue;
                    this.flows[i].setColor(this.getSubParticleColor(this.effectAspects[i]));
                    this.flows[i].setColor(new Color(this.effectAspects[i].getColor()));
                }
                if (this.field_70173_aa < 49) break block15;
                if (this.auraOrbital.orbitalsSize() != 0) break block14;
                for (i = 0; i < 6; ++i) {
                    node = this.effectProperties[i];
                    this.auraOrbital.addOrbitalPoint(node);
                }
                break block14;
            }
            for (i = 0; i < 6; ++i) {
                if (this.flows[i] == null) continue;
                this.flows[i].lastUpdateCall = System.currentTimeMillis();
            }
        }
    }

    private void finishCore() {
        ItemStack auraCore = new ItemStack((Item)RegisteredItems.itemAuraCore, 1, 0);
        boolean success = false;
        if (this.blockCount >= REQUIRED_BLOCKS) {
            double avg = (double)this.internalAuraList.visSize() / (double)this.internalAuraList.size();
            Aspect[] sortedHtL = this.internalAuraList.getAspectsSortedAmount();
            AspectList al = new AspectList();
            for (Aspect a : sortedHtL) {
                if (a == null) {
                    return;
                }
                int am = this.internalAuraList.getAmount(a);
                if (!((double)am >= avg)) continue;
                al.add(a, am);
            }
            ArrayList<AspectWRItem> rand = new ArrayList<AspectWRItem>();
            for (Aspect a : al.getAspects()) {
                if (a == null) continue;
                rand.add(new AspectWRItem(al.getAmount(a), a));
            }
            Aspect aura = ((AspectWRItem)WeightedRandom.func_76271_a((Random)this.field_70170_p.field_73012_v, rand)).getAspect();
            for (ItemAuraCore.AuraCoreType type : ItemAuraCore.AuraCoreType.values()) {
                if (!type.isAspect() || !type.getAspect().equals(aura)) continue;
                RegisteredItems.itemAuraCore.setCoreType(auraCore, type);
                success = true;
            }
        }
        PacketStartAnimation animationPacket = !success ? new PacketStartAnimation(7, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, Float.floatToIntBits(2.0f)) : new PacketStartAnimation(4, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
        PacketHandler.INSTANCE.sendToAllAround((IMessage)animationPacket, MiscUtils.getTargetPoint(this.field_70170_p, (Entity)this, 32.0));
        EntityItem ei = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, auraCore);
        ei.field_70159_w = 0.0;
        ei.field_70181_x = 0.0;
        ei.field_70179_y = 0.0;
        this.field_70170_p.func_72838_d((Entity)ei);
        this.func_70106_y();
    }

    private void initGathering() {
        this.markedLocations = new ArrayList<ChunkCoordinates>((int)Math.pow(9.0, 3.0));
        for (int x = -4; x <= 4; ++x) {
            for (int y = -4; y <= 4; ++y) {
                for (int z = -4; z <= 4; ++z) {
                    this.markedLocations.add(new ChunkCoordinates(x, y, z));
                }
            }
        }
        Collections.shuffle(this.markedLocations, new Random(this.activationLocation.hashCode()));
    }

    private void auraGatherCycle() {
        if (this.field_70173_aa >= 50) {
            int elapsed = this.field_70173_aa - 50 - 1;
            float dist = 450.0f / (float)this.markedLocations.size();
            int index = (int)((float)elapsed / dist);
            int lastIndex = (int)((float)(elapsed - 1) / dist);
            if (index < this.markedLocations.size() && index > lastIndex) {
                int diff = index - lastIndex;
                for (int i = 0; i < diff; ++i) {
                    AspectList aspects;
                    ChunkCoordinates coord = this.markedLocations.get(index + i);
                    int x = (int)((double)coord.field_71574_a + this.field_70165_t);
                    int y = (int)((double)coord.field_71572_b + this.field_70163_u);
                    int z = (int)((double)coord.field_71573_c + this.field_70161_v);
                    Block block = this.field_70170_p.func_147439_a(x, y, z);
                    if (block == Blocks.field_150350_a) continue;
                    int meta = this.field_70170_p.func_72805_g(x, y, z);
                    ScanResult result = null;
                    MovingObjectPosition pos = new MovingObjectPosition(x, y, z, ForgeDirection.UP.ordinal(), Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0), true);
                    ItemStack is = null;
                    try {
                        is = block.getPickBlock(pos, this.field_70170_p, x, y, z);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        if (is == null) {
                            is = BlockUtils.createStackedBlock((Block)block, (int)meta);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        result = is == null ? new ScanResult(1, Block.func_149682_b((Block)block), meta, null, "") : new ScanResult(1, Item.func_150891_b((Item)is.func_77973_b()), is.func_77960_j(), null, "");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (result == null || (aspects = ScanManager.getScanAspects(result, (World)this.field_70170_p)).size() <= 0) continue;
                    this.internalAuraList.add(aspects);
                    ++this.blockCount;
                }
            }
            this.sendAspectData(this.electParliament());
        }
    }

    private Aspect[] electParliament() {
        Aspect[] colors = new Aspect[6];
        Aspect[] aspects = this.internalAuraList.getAspectsSortedAmount();
        int totalSize = this.internalAuraList.visSize();
        int availableSeats = 6;
        for (Aspect aspect : aspects) {
            float percent = (float)this.internalAuraList.getAmount(aspect) / (float)totalSize;
            int seats = (int)Math.ceil((float)availableSeats * percent);
            seats = Math.min(seats, availableSeats);
            availableSeats -= seats;
            for (int i = 0; i < colors.length && seats > 0; ++i) {
                if (colors[i] != null) continue;
                colors[i] = aspect;
                --seats;
            }
            if (availableSeats <= 0) break;
        }
        for (int i = 0; i < colors.length; ++i) {
            if (colors[i] != null) continue;
            colors[i] = aspects[0];
        }
        return colors;
    }

    private Color getSubParticleColor(Aspect a) {
        Color c = null;
        if (a.equals(Aspect.AIR)) {
            c = new Color(16711625);
        } else if (a.equals(Aspect.FIRE)) {
            c = new Color(16755260);
        } else if (a.equals(Aspect.EARTH)) {
            c = new Color(8315743);
        } else if (a.equals(Aspect.WATER)) {
            c = new Color(7917516);
        } else if (a.equals(Aspect.ORDER)) {
            c = new Color(0xFFFFFF);
        } else if (a.equals(Aspect.ENTROPY)) {
            c = new Color(0);
        }
        return c;
    }

    private boolean recieveAspectData() {
        String rec = this.func_70096_w().func_75681_e(ModConfig.entityAuraCoreDatawatcherAspectsId);
        if (this.oldAspectDataSent != null && this.oldAspectDataSent.equals(rec)) {
            return false;
        }
        this.oldAspectDataSent = rec;
        if (rec.equals("")) {
            return false;
        }
        String[] arr = rec.split(SPLIT);
        if (arr.length != 6) {
            throw new IllegalStateException("Server sent wrong Aura Data! '" + rec + "' Please report this error to the mod authors!");
        }
        for (int i = 0; i < arr.length; ++i) {
            Aspect a;
            String s = arr[i];
            this.effectAspects[i] = a = Aspect.getAspect((String)s);
        }
        return true;
    }

    private void sendAspectData(Aspect[] aspects) {
        StringBuilder sb = new StringBuilder();
        for (Aspect aspect : aspects) {
            if (sb.length() > 0) {
                sb.append(SPLIT);
            }
            sb.append(aspect.getTag());
        }
        String toSend = sb.toString();
        if (this.oldAspectDataSent == null || !this.oldAspectDataSent.equals(toSend)) {
            this.oldAspectDataSent = toSend;
            this.func_70096_w().func_75692_b(ModConfig.entityAuraCoreDatawatcherAspectsId, (Object)toSend);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.internalAuraList = new PrimalAspectList();
        this.field_70173_aa = compound.func_74762_e("ticksExisted");
        NBTTagList list = compound.func_150295_c("auraList", (int)compound.func_74732_a());
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound cmp = list.func_150305_b(i);
            if (!cmp.func_74764_b("tag") || !cmp.func_74764_b("amt")) continue;
            this.internalAuraList.add(Aspect.getAspect((String)cmp.func_74779_i("tag")), cmp.func_74762_e("amt"));
        }
        if (compound.func_74764_b("activationVecX") && compound.func_74764_b("activationVecY") && compound.func_74764_b("activationVecZ")) {
            int x = compound.func_74762_e("activationVecX");
            int y = compound.func_74762_e("activationVecY");
            int z = compound.func_74762_e("activationVecZ");
            this.activationLocation = new ChunkCoordinates(x, y, z);
        }
        this.sendAspectData(this.electParliament());
        this.initGathering();
        this.blockCount = compound.func_74762_e("blockCount");
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("ticksExisted", this.field_70173_aa);
        NBTTagList list = new NBTTagList();
        for (Aspect a : this.internalAuraList.getAspects()) {
            if (a == null) continue;
            NBTTagCompound aspectCompound = new NBTTagCompound();
            aspectCompound.func_74778_a("tag", a.getTag());
            aspectCompound.func_74768_a("amt", this.internalAuraList.getAmount(a));
            list.func_74742_a((NBTBase)aspectCompound);
        }
        compound.func_74782_a("auraList", (NBTBase)list);
        if (this.activationLocation != null) {
            compound.func_74768_a("activationVecX", this.activationLocation.field_71574_a);
            compound.func_74768_a("activationVecY", this.activationLocation.field_71572_b);
            compound.func_74768_a("activationVecZ", this.activationLocation.field_71573_c);
        }
        compound.func_74768_a("blockCount", this.blockCount);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.field_70173_aa);
        buffer.writeInt(this.activationLocation.field_71574_a);
        buffer.writeInt(this.activationLocation.field_71572_b);
        buffer.writeInt(this.activationLocation.field_71573_c);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.field_70173_aa = buffer.readInt();
        this.activationLocation = new ChunkCoordinates();
        this.activationLocation.field_71574_a = buffer.readInt();
        this.activationLocation.field_71572_b = buffer.readInt();
        this.activationLocation.field_71573_c = buffer.readInt();
    }

    public static final class AspectWRItem
    extends WeightedRandom.Item {
        private final Aspect aspect;

        public AspectWRItem(int weight, Aspect aspect) {
            super(weight);
            this.aspect = aspect;
        }

        public Aspect getAspect() {
            return this.aspect;
        }
    }
}

