/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.blocks.tiles;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import makeo.gadomancy.common.network.PacketHandler;
import makeo.gadomancy.common.network.packets.PacketTCNodeBolt;
import makeo.gadomancy.common.node.ExtendedNodeType;
import makeo.gadomancy.common.node.GrowingNodeBehavior;
import makeo.gadomancy.common.utils.ExplosionHelper;
import makeo.gadomancy.common.utils.ResearchHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.EnumDifficulty;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.api.nodes.INode;
import thaumcraft.common.entities.EntityAspectOrb;
import thaumcraft.common.entities.monster.EntityWisp;
import thaumcraft.common.items.ItemCrystalEssence;
import thaumcraft.common.items.ItemManaBean;
import thaumcraft.common.items.ItemWispEssence;
import thaumcraft.common.tiles.TileNode;

public class TileExtendedNode
extends TileNode
implements INode {
    public int ticksExisted = 0;
    private ExtendedNodeType extendedNodeType;
    private GrowingNodeBehavior behavior = new GrowingNodeBehavior(this);
    private boolean doingVortexExplosion = false;
    private ExplosionHelper.VortexExplosion vortexExplosion;

    public void func_145845_h() {
        super.func_145845_h();
        ++this.ticksExisted;
        if (this.doingVortexExplosion) {
            if (this.vortexExplosion == null) {
                this.vortexExplosion = new ExplosionHelper.VortexExplosion(this);
            }
            if (this.vortexExplosion.isFinished()) {
                this.vortexExplosion = null;
                this.doingVortexExplosion = false;
            } else {
                this.vortexExplosion.update();
            }
        }
        boolean needUpdate = this.handleGrowingNodeFirst(false);
        needUpdate = this.handleGrowingNodeSecond(needUpdate);
        if (!this.field_145850_b.field_72995_K && needUpdate) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        }
    }

    private boolean handleGrowingNodeSecond(boolean needUpdate) {
        if (this.extendedNodeType == null || this.extendedNodeType != ExtendedNodeType.GROWING) {
            return needUpdate;
        }
        if (this.field_145850_b.field_73013_u == EnumDifficulty.PEACEFUL) {
            return needUpdate;
        }
        if (this.field_145850_b.field_72995_K) {
            return needUpdate;
        }
        if (this.ticksExisted % 8 != 0) {
            return needUpdate;
        }
        List livingEntities = this.field_145850_b.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72314_b(6.0, 6.0, 6.0));
        if (livingEntities != null && livingEntities.size() > 0) {
            for (Object e : livingEntities) {
                EntityLivingBase livingEntity = (EntityLivingBase)e;
                if (!livingEntity.func_70089_S() || livingEntity.func_85032_ar() || livingEntity instanceof EntityPlayer && ((EntityPlayer)livingEntity).field_71075_bZ.field_75098_d || !this.behavior.mayZapNow()) continue;
                ResearchHelper.distributeResearch("gadomancy".toUpperCase() + ".GROWING_AGGRESSION", this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 6.0);
                livingEntity.func_70097_a(DamageSource.field_76376_m, this.behavior.getZapDamage());
                this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "thaumcraft:zap", 0.8f, 1.0f);
                PacketTCNodeBolt packet = new PacketTCNodeBolt((float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 0.5f, (float)this.field_145849_e + 0.5f, (float)livingEntity.field_70165_t, (float)(livingEntity.field_70163_u + (double)livingEntity.field_70131_O), (float)livingEntity.field_70161_v, 0, false);
                PacketHandler.INSTANCE.sendToAllAround((IMessage)packet, new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 32.0));
            }
        }
        return needUpdate;
    }

    private boolean handleGrowingNodeFirst(boolean needUpdate) {
        if (this.extendedNodeType == null || this.extendedNodeType != ExtendedNodeType.GROWING) {
            return needUpdate;
        }
        needUpdate = this.doVortex(EntityAspectOrb.class, needUpdate, new GrowingNodeVortexRunnable<EntityAspectOrb>(){

            @Override
            public Aspect getAspect(EntityAspectOrb entity) {
                return entity.getAspect();
            }

            @Override
            public GrowingNodeBehavior.AspectType getAspectType(EntityAspectOrb entity) {
                return GrowingNodeBehavior.AspectType.ASPECT_ORB;
            }
        });
        needUpdate = this.doVortex(EntityItem.class, needUpdate, new GrowingNodeVortexRunnable<EntityItem>(){

            @Override
            public boolean doesVortex(EntityItem entity) {
                return entity.func_92059_d().func_77973_b() instanceof ItemWispEssence || entity.func_92059_d().func_77973_b() instanceof ItemManaBean || entity.func_92059_d().func_77973_b() instanceof ItemCrystalEssence;
            }

            @Override
            public Aspect getAspect(EntityItem entity) {
                IEssentiaContainerItem container = (IEssentiaContainerItem)entity.func_92059_d().func_77973_b();
                return container.getAspects(entity.func_92059_d()).getAspects().length > 0 ? container.getAspects(entity.func_92059_d()).getAspects()[0] : null;
            }

            @Override
            public GrowingNodeBehavior.AspectType getAspectType(EntityItem entity) {
                return entity.func_92059_d().func_77973_b() instanceof ItemWispEssence ? GrowingNodeBehavior.AspectType.WISP_ESSENCE : (entity.func_92059_d().func_77973_b() instanceof ItemCrystalEssence ? GrowingNodeBehavior.AspectType.CRYSTAL_ESSENCE : GrowingNodeBehavior.AspectType.MANA_BEAN);
            }
        });
        needUpdate = this.doVortex(EntityWisp.class, needUpdate, new GrowingNodeVortexRunnable<EntityWisp>(){

            @Override
            public Aspect getAspect(EntityWisp entity) {
                return Aspect.getAspect((String)entity.getType());
            }

            @Override
            public GrowingNodeBehavior.AspectType getAspectType(EntityWisp entity) {
                return GrowingNodeBehavior.AspectType.WISP;
            }
        });
        if (this.field_145850_b.field_72995_K) {
            return needUpdate;
        }
        if (this.behavior.lookingForNode()) {
            int zz;
            int yy;
            int xx = this.field_145850_b.field_73012_v.nextInt(8) - this.field_145850_b.field_73012_v.nextInt(8);
            TileEntity t = this.field_145850_b.func_147438_o(this.field_145851_c + xx, this.field_145848_d + (yy = this.field_145850_b.field_73012_v.nextInt(8) - this.field_145850_b.field_73012_v.nextInt(8)), this.field_145849_e + (zz = this.field_145850_b.field_73012_v.nextInt(8) - this.field_145850_b.field_73012_v.nextInt(8)));
            if (t != null && t instanceof TileNode && (xx != 0 || yy != 0 || zz != 0)) {
                int othersSize;
                TileNode node = (TileNode)t;
                int thisSize = this.getAspectsBase().visSize();
                if (thisSize >= (othersSize = node.getAspectsBase().visSize())) {
                    this.behavior.lockOnTo(node);
                    this.field_145850_b.func_147471_g(this.field_145851_c + xx, this.field_145848_d + yy, this.field_145849_e + zz);
                    node.func_70296_d();
                    needUpdate = true;
                }
            }
        } else {
            needUpdate = this.behavior.updateBehavior(needUpdate);
        }
        return needUpdate;
    }

    private void applyMovementVectors(Entity entity) {
        double var3 = ((double)this.field_145851_c + 0.5 - entity.field_70165_t) / 15.0;
        double var5 = ((double)this.field_145848_d + 0.5 - entity.field_70163_u) / 15.0;
        double var7 = ((double)this.field_145849_e + 0.5 - entity.field_70161_v) / 15.0;
        double var9 = Math.sqrt(var3 * var3 + var5 * var5 + var7 * var7);
        double var11 = 1.0 - var9;
        if (var11 > 0.0) {
            var11 *= var11;
            entity.field_70159_w += var3 / var9 * var11 * 0.15;
            entity.field_70181_x += var5 / var9 * var11 * 0.25;
            entity.field_70179_y += var7 / var9 * var11 * 0.15;
        }
    }

    private <E extends Entity> boolean doVortex(Class<E> entityClass, boolean needUpdate, GrowingNodeVortexRunnable<E> runnable) {
        List entities = this.field_145850_b.func_72872_a(entityClass, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72314_b(15.0, 15.0, 15.0));
        if (entities != null && entities.size() > 0) {
            for (Object eObj : entities) {
                double d;
                Entity entity = (Entity)eObj;
                if (!runnable.doesVortex(entity)) continue;
                if (entity.func_70089_S() && !entity.func_85032_ar() && (d = this.getDistanceTo(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v)) < 0.5) {
                    Aspect a = runnable.getAspect(entity);
                    if (a != null) {
                        if (this.getAspects().getAmount(a) < this.getNodeVisBase(a)) {
                            this.addToContainer(a, 1);
                        } else if (!this.field_145850_b.field_72995_K && this.behavior.doesAccept(a)) {
                            this.behavior.addAspect(runnable.getAspectType(entity), a, 1);
                        }
                    }
                    needUpdate = true;
                    entity.func_70106_y();
                }
                this.applyMovementVectors(entity);
            }
        }
        return needUpdate;
    }

    public ExtendedNodeType getExtendedNodeType() {
        return this.extendedNodeType;
    }

    public void setExtendedNodeType(ExtendedNodeType extendedNodeType) {
        this.extendedNodeType = extendedNodeType;
    }

    public NBTTagCompound getBehaviorSnapshot() {
        if (this.extendedNodeType != null && this.extendedNodeType == ExtendedNodeType.GROWING) {
            NBTTagCompound behaviorCompound = new NBTTagCompound();
            this.behavior.writeToNBT(behaviorCompound);
            return behaviorCompound;
        }
        return null;
    }

    public void readBehaviorSnapshot(NBTTagCompound tagCompound) {
        if (tagCompound != null && this.extendedNodeType != null && this.extendedNodeType == ExtendedNodeType.GROWING) {
            this.behavior.readFromNBT(tagCompound);
        }
    }

    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        NBTTagCompound compound = nbttagcompound.func_74775_l("Gadomancy");
        String exName = compound.func_74779_i("exNodeType");
        this.extendedNodeType = exName != null && !exName.isEmpty() ? ExtendedNodeType.valueOf(exName) : null;
        if (this.extendedNodeType != null && this.extendedNodeType == ExtendedNodeType.GROWING) {
            NBTTagCompound growingNodeBehavior = compound.func_74775_l("NodeBehavior");
            this.behavior.readFromNBT(growingNodeBehavior);
        }
    }

    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        super.writeCustomNBT(nbttagcompound);
        NBTTagCompound compound = new NBTTagCompound();
        if (this.extendedNodeType != null) {
            compound.func_74778_a("exNodeType", this.extendedNodeType.name());
            if (this.extendedNodeType == ExtendedNodeType.GROWING) {
                NBTTagCompound behaviorCompound = new NBTTagCompound();
                this.behavior.writeToNBT(behaviorCompound);
                compound.func_74782_a("NodeBehavior", (NBTBase)behaviorCompound);
            }
        }
        nbttagcompound.func_74782_a("Gadomancy", (NBTBase)compound);
    }

    public void triggerVortexExplosion() {
        this.doingVortexExplosion = true;
    }

    private static abstract class GrowingNodeVortexRunnable<E> {
        private GrowingNodeVortexRunnable() {
        }

        public boolean doesVortex(E entity) {
            return true;
        }

        public abstract Aspect getAspect(E var1);

        public abstract GrowingNodeBehavior.AspectType getAspectType(E var1);
    }
}

