/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.rendering;

import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.Config;
import jds.bibliocraft.models.ModelPaneler;
import jds.bibliocraft.tileentities.TileEntityFurniturePaneler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class TileEntityFurniturePanelerRenderer
extends TileEntitySpecialRenderer {
    private ModelPaneler model = new ModelPaneler();
    private int angle = 0;
    private TileEntityFurniturePaneler tile;
    private int panelStackSize;
    private ItemStack panelStack;
    private float degreeAngle = 0.0f;
    private RenderItem itemRenderer = null;
    private RenderManager renderManager = RenderManager.field_78727_a;
    private ItemStack inputStack;
    private ItemStack outputStack;
    private String customTex = "none";
    private ResourceLocation customTexture = null;
    private String customCraftingTex = "none";
    private ResourceLocation customCraftingTexture = null;

    public void func_147500_a(TileEntity tileEntity, double i, double j, double k, float tick) {
        this.tile = (TileEntityFurniturePaneler)tileEntity;
        if (this.tile != null) {
            this.angle = this.tile.getAngle();
            this.panelStack = this.tile.func_70301_a(0);
            this.inputStack = this.tile.func_70301_a(1);
            this.outputStack = this.tile.func_70301_a(2);
            this.customTex = this.tile.getCustomTexString();
            this.customTexture = this.tile.getCustomTex();
            this.customCraftingTex = this.tile.getCustomCraftingTextureString();
            this.customCraftingTexture = this.tile.getCustomCraftingTex();
            this.panelStackSize = this.panelStack != null ? this.panelStack.field_77994_a : 0;
            if (this.panelStackSize == 64) {
                --this.panelStackSize;
            }
        }
        if (this.itemRenderer == null) {
            this.itemRenderer = new RenderItem(){

                public byte getMiniBlockCount(ItemStack stack, byte original) {
                    return 1;
                }

                public boolean shouldBob() {
                    return false;
                }

                public boolean shouldSpreadItems() {
                    return false;
                }
            };
            this.itemRenderer.func_76976_a(this.renderManager);
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)(i + 0.5), (double)j, (double)(k + 0.5));
        switch (this.angle) {
            case 0: {
                this.degreeAngle = 180.0f;
                break;
            }
            case 1: {
                this.degreeAngle = 90.0f;
                break;
            }
            case 2: {
                this.degreeAngle = 0.0f;
                break;
            }
            case 3: {
                this.degreeAngle = -90.0f;
            }
        }
        GL11.glRotatef((float)this.degreeAngle, (float)0.0f, (float)1.0f, (float)0.0f);
        if (this.customTex.contentEquals("none") || this.customTexture == null || this.customTex.contentEquals("")) {
            this.func_147499_a(this.getModelTexture(this.tile.func_145832_p()));
        } else {
            this.func_147499_a(this.customTexture);
        }
        this.model.renderWoodPart();
        this.func_147499_a(CommonProxy.PANELER_BLOCK);
        this.model.renderPanelerToolsTop();
        if (this.panelStackSize > 0 && this.panelStack != null && this.customCraftingTexture != null) {
            this.func_147499_a(this.customCraftingTexture);
            this.model.renderPanel((int)(1.0 + (double)this.panelStackSize / 8.0));
        }
        GL11.glPopMatrix();
        switch (this.angle) {
            case 0: {
                this.renderSlotItem(this.inputStack, i + 0.24, j + 0.77, k + 0.29);
                this.renderSlotItem(this.outputStack, i + 0.24, j + 0.77, k + 0.72);
                break;
            }
            case 1: {
                this.renderSlotItem(this.inputStack, i + 0.71, j + 0.77, k + 0.24);
                this.renderSlotItem(this.outputStack, i + 0.28, j + 0.77, k + 0.24);
                break;
            }
            case 2: {
                this.renderSlotItem(this.inputStack, i + 0.76, j + 0.77, k + 0.72);
                this.renderSlotItem(this.outputStack, i + 0.76, j + 0.77, k + 0.29);
                break;
            }
            case 3: {
                this.renderSlotItem(this.inputStack, i + 0.29, j + 0.77, k + 0.76);
                this.renderSlotItem(this.outputStack, i + 0.72, j + 0.77, k + 0.76);
            }
        }
    }

    private String getIconProperName(ItemStack stack) {
        String name = stack.func_77954_c().func_94215_i();
        if (name.startsWith("wool_colored_") || name.startsWith("hardened_clay_stained_")) {
            if (name.contains("black")) {
                name = name.replace("black", "white");
            } else if (name.contains("colored_red") || name.contains("stained_red")) {
                name = name.contains("colored_red") ? name.replace("colored_red", "colored_orange") : name.replace("red", "orange");
            } else if (name.contains("green")) {
                name = name.replace("green", "magenta");
            } else if (name.contains("brown")) {
                name = name.replace("brown", "light_blue");
            } else if (name.contains("colored_blue") || name.contains("stained_blue")) {
                name = name.replace("blue", "yellow");
            } else if (name.contains("purple")) {
                name = name.replace("purple", "lime");
            } else if (name.contains("cyan")) {
                name = name.replace("cyan", "pink");
            } else if (name.contains("silver")) {
                name = name.replace("silver", "gray");
            } else if (name.contains("gray")) {
                name = name.replace("gray", "silver");
            } else if (name.contains("pink")) {
                name = name.replace("pink", "cyan");
            } else if (name.contains("lime")) {
                name = name.replace("lime", "purple");
            } else if (name.contains("light_blue")) {
                name = name.replace("light_blue", "brown");
            } else if (name.contains("yellow")) {
                name = name.replace("yellow", "blue");
            } else if (name.contains("magenta")) {
                name = name.replace("magenta", "green");
            } else if (name.contains("orange")) {
                name = name.replace("orange", "red");
            } else if (name.contains("white")) {
                name = name.replace("white", "black");
            }
        }
        return name;
    }

    private void renderSlotItem(ItemStack stack, double xAdjust, double yAdjust, double zAdjust) {
        if (stack != null) {
            boolean fancyGraphics = Minecraft.func_71375_t();
            EntityItem slotEntity = new EntityItem(null, 0.0, 0.0, 0.0, stack);
            slotEntity.field_70290_d = 0.0f;
            GL11.glPushMatrix();
            GL11.glTranslated((double)xAdjust, (double)yAdjust, (double)zAdjust);
            GL11.glRotatef((float)this.degreeAngle, (float)0.0f, (float)1.0f, (float)0.0f);
            this.itemRenderer.func_76986_a(slotEntity, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            if (!fancyGraphics && !Config.isBlock(stack)) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                this.itemRenderer.func_76986_a(slotEntity, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            }
            RenderItem.field_82407_g = false;
            GL11.glPopMatrix();
        }
    }

    public ResourceLocation getModelTexture(int metadata) {
        switch (metadata) {
            case 0: {
                return CommonProxy.PLANKSOAK;
            }
            case 1: {
                return CommonProxy.PLANKSSPRUCE;
            }
            case 2: {
                return CommonProxy.PLANKSBIRCH;
            }
            case 3: {
                return CommonProxy.PLANKSJUNGLE;
            }
            case 4: {
                return CommonProxy.PLANKSACACIA;
            }
            case 5: {
                return CommonProxy.PLANKSOLDOAK;
            }
            case 6: {
                return CommonProxy.FRAME_BLOCK;
            }
        }
        return CommonProxy.PLANKSOAK;
    }
}

